/*
 * Decompiled with CFR 0.152.
 */
package peernet.util;

import java.util.NoSuchElementException;
import java.util.Random;
import peernet.util.IndexIterator;

public class WeightedRandPerm
implements IndexIterator {
    private final double[] w;
    private final double[] wsum;
    private int[] buffer = null;
    private double[] weights = null;
    private int len = 0;
    private int pointer = 0;
    private double sum = 0.0;
    private final Random r;

    public WeightedRandPerm(Random r, double[] weights) {
        int i;
        this.r = r;
        this.w = (double[])weights.clone();
        this.wsum = (double[])weights.clone();
        this.weights = new double[this.w.length];
        this.buffer = new int[this.w.length];
        for (i = 0; i < this.w.length; ++i) {
            if (!(this.w[i] <= 0.0)) continue;
            throw new IllegalArgumentException("weights should be positive: w[" + i + "]=" + this.w[i]);
        }
        for (i = 1; i < this.w.length; ++i) {
            int n = i;
            this.wsum[n] = this.wsum[n] + this.wsum[i - 1];
        }
    }

    @Override
    public void reset(int k) {
        if (k < 0 || k > this.w.length) {
            throw new IllegalArgumentException("k should be non-negative and <= " + this.w.length);
        }
        this.pointer = k;
        this.sum = this.wsum[k - 1];
        if (k != this.len) {
            for (int i = 0; i < k; ++i) {
                this.weights[i] = this.w[i];
                this.buffer[i] = i;
            }
            this.len = k;
        }
    }

    @Override
    public int next() {
        if (this.pointer < 1) {
            throw new NoSuchElementException();
        }
        double d = this.sum * this.r.nextDouble();
        int i = this.pointer;
        for (double tmp = this.weights[i - 1]; tmp < d && i > 1; tmp += this.weights[--i - 1]) {
        }
        int a = this.buffer[i - 1];
        double b = this.weights[i - 1];
        this.buffer[i - 1] = this.buffer[this.pointer - 1];
        this.weights[i - 1] = this.weights[this.pointer - 1];
        this.buffer[this.pointer - 1] = a;
        this.weights[this.pointer - 1] = b;
        this.sum -= b;
        return this.buffer[--this.pointer];
    }

    @Override
    public boolean hasNext() {
        return this.pointer > 0;
    }
}

