/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.p2psim.transport;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import peernet.core.CommonState;
import peernet.core.Node;

public class ConnectionData {
    private final Node lowerEndpoint;
    private final Node higherEndpoint;
    private final long timeCreated;
    private final Set<Integer> pids;

    public ConnectionData(Node a, Node b, int pid) {
        assert (a.getID() != b.getID());
        if (a.getID() < b.getID()) {
            this.lowerEndpoint = a;
            this.higherEndpoint = b;
        } else {
            this.lowerEndpoint = b;
            this.higherEndpoint = a;
        }
        this.timeCreated = CommonState.getTime();
        this.pids = new HashSet<Integer>(1);
        this.pids.add(pid);
    }

    public boolean addPid(int pid) {
        return this.pids.add(pid);
    }

    public Iterator<Integer> getPids() {
        return this.pids.iterator();
    }

    public boolean removePid(int pid) {
        return this.pids.remove(pid);
    }

    public int protocolsUsing() {
        return this.pids.size();
    }

    public Node getLowerEndpoint() {
        return this.lowerEndpoint;
    }

    public Node getHigherEndpoint() {
        return this.higherEndpoint;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }
}

