/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.p2psim.transport;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import java.util.stream.DoubleStream;
import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Engine;
import peernet.core.Network;
import peernet.core.Node;
import peernet.transport.Address;
import peernet.transport.AddressSim;
import peernet.transport.ConnectionOrientedTransport;
import peernet.transport.FailureAwareTransport;
import peernet.transport.RouterNetwork;
import peernet.transport.Transport;
import pt.unl.fct.di.novasys.p2psim.transport.ConnectionData;
import pt.unl.fct.di.novasys.p2psim.transport.events.ConnectionDown;
import pt.unl.fct.di.novasys.p2psim.transport.events.ConnectionUp;

public class TCPSimpleTransport
extends Transport
implements ConnectionOrientedTransport,
FailureAwareTransport {
    private static final String PAR_N_NODES = "nodes";
    private static final String PAR_LATENCY_MATRIX_FILE = "latencies";
    private static final String DEFAULT_LATENCY_MATRIX_FLLE = "latency.txt";
    private static final String PAR_PROCESSING_DELAY = "delay";
    private static final int DEFAULT_PROCESSING_DELAY = 0;
    private static final String PAR_PROCESSING_VARIATION = "delay_variation";
    private static final double DEFAULT_PROCESSING_VARIATION = 0.15;
    private static final String PAR_FAILURE_TIMEOUT_FACTOR = "failure_timeout_factor";
    private static final int DEFAULT_FAILURE_TIMEOUT_FACTOR = 4;
    private final int n;
    private File latenciesInputFile;
    private final int[][] latency;
    private final int processingDelay;
    private final double processingVariation;
    private final boolean applyProcessingDelay;
    private final DoubleStream variationGeneration;
    private final Iterator<Double> iterator;
    private final int failureTimeoutFactor;
    private final HashMap<Node, HashMap<Node, ConnectionData>> connections;
    private final HashMap<Node, HashSet<Node>> reverseConnectionAuxiliar;

    public TCPSimpleTransport(String prefix) {
        assert (Engine.instance().getAddressType() == Engine.AddressType.SIM);
        this.n = Configuration.getInt(prefix + ".nodes", Network.size());
        String filename = Configuration.getString(prefix + ".latencies", DEFAULT_LATENCY_MATRIX_FLLE);
        this.latenciesInputFile = new File(filename);
        if (!this.latenciesInputFile.exists()) {
            throw new RuntimeException("Transport (" + this.getClass().getCanonicalName() + "): Latency matrix file '" + filename + "' does not exists.");
        }
        this.latency = new int[this.n][this.n];
        try (Scanner scan = new Scanner(this.latenciesInputFile);){
            int n_lines = 0;
            while (scan.hasNext()) {
                String[] elements = scan.nextLine().split(" ");
                if (elements.length != this.n) {
                    throw new RuntimeException("Incorrect format for the latency file. On line " + n_lines + "1 expected " + this.n + " elements and got " + elements.length);
                }
                for (int i = 0; i < elements.length; ++i) {
                    this.latency[n_lines][i] = Math.round(Float.parseFloat(elements[i]));
                }
                if (++n_lines <= this.n) continue;
                throw new RuntimeException("Incorrect format for the latency File. File has more lines than " + this.n);
            }
            if (n_lines != this.n) {
                throw new RuntimeException("Incorrect format for the latency file. Expected " + this.n + " lines got " + n_lines);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot open the latency file '" + filename + "' for processing.", e);
        }
        this.processingDelay = Configuration.getInt(PAR_PROCESSING_DELAY, 0);
        this.failureTimeoutFactor = Configuration.getInt(PAR_FAILURE_TIMEOUT_FACTOR, 4);
        boolean bl = this.applyProcessingDelay = this.processingDelay > 0;
        if (this.applyProcessingDelay) {
            this.processingVariation = Configuration.getDouble(PAR_PROCESSING_VARIATION, 0.15);
            this.variationGeneration = CommonState.r.doubles(-1.0 * Math.abs(this.processingVariation), Math.abs(this.processingVariation));
            this.iterator = this.variationGeneration.iterator();
        } else {
            this.processingVariation = 0.0;
            this.variationGeneration = null;
            this.iterator = null;
        }
        this.connections = new HashMap();
        this.reverseConnectionAuxiliar = new HashMap();
    }

    private Node getShortEndpoint(Node src, Node dest) {
        assert (src.getID() != dest.getID());
        if (src.getID() < dest.getID()) {
            return src;
        }
        return dest;
    }

    private Node getHighestEndpoint(Node src, Node dest) {
        assert (src.getID() != dest.getID());
        if (src.getID() < dest.getID()) {
            return dest;
        }
        return src;
    }

    private ConnectionData getConnectionData(Node src, Node dest) {
        ConnectionData c = null;
        HashMap<Node, ConnectionData> inner = this.connections.get(this.getShortEndpoint(src, dest));
        if (inner != null) {
            c = inner.get(this.getHighestEndpoint(src, dest));
        }
        return c;
    }

    private ConnectionData removeConnectionData(Node src, Node dest) {
        ConnectionData c = null;
        Node shorter = this.getShortEndpoint(src, dest);
        Node higher = this.getHighestEndpoint(src, dest);
        HashMap<Node, ConnectionData> inner = this.connections.get(shorter);
        if (inner != null) {
            c = inner.remove(higher);
        }
        if (c != null) {
            this.reverseConnectionAuxiliar.get(higher).remove(shorter);
        }
        return c;
    }

    private void setConnectionData(Node src, Node dest, int pid) {
        Node lower = this.getShortEndpoint(src, dest);
        Node higher = this.getHighestEndpoint(src, dest);
        HashMap<Node, ConnectionData> inner = this.connections.get(lower);
        if (inner == null) {
            inner = new HashMap();
            this.connections.put(lower, inner);
            inner.put(higher, new ConnectionData(lower, higher, pid));
            HashSet n = this.reverseConnectionAuxiliar.computeIfAbsent(higher, f -> new HashSet());
            n.add(lower);
        } else if (!inner.containsKey(higher)) {
            inner.put(higher, new ConnectionData(lower, higher, pid));
            HashSet n = this.reverseConnectionAuxiliar.computeIfAbsent(higher, f -> new HashSet());
            n.add(lower);
        } else {
            inner.get(higher).addPid(pid);
        }
    }

    private int delayToConnectNotification(Node src, Node dest) {
        int delayInNotification = 2 * this.getLatency(src, dest) + this.getLatency(dest, src);
        if (this.applyProcessingDelay) {
            delayInNotification += 3 * this.getProcessingDelay();
        }
        return delayInNotification;
    }

    @Override
    public void openConnection(Node src, Node dest, int pid) {
        ConnectionData c = this.getConnectionData(src, dest);
        int delay = this.delayToConnectNotification(src, dest);
        if (c == null) {
            this.setConnectionData(src, dest, pid);
            this.addEventIn(delay, new AddressSim(dest), src, pid, new ConnectionUp(dest));
            this.addEventIn(delay, new AddressSim(src), dest, pid, new ConnectionUp(src));
        } else if (c.addPid(pid)) {
            this.addEventIn(delay, new AddressSim(dest), src, pid, new ConnectionUp(dest));
            this.addEventIn(delay, new AddressSim(src), dest, pid, new ConnectionUp(src));
        }
    }

    @Override
    public void closeConnection(Node src, Node dest, int pid) {
        ConnectionData c = this.getConnectionData(src, dest);
        if (c != null && c.removePid(pid)) {
            int baseDelayInNotification;
            int delaySource = baseDelayInNotification = 2 * this.getLatency(src, dest) + this.getLatency(dest, src);
            int delayDest = baseDelayInNotification;
            if (this.applyProcessingDelay) {
                delaySource += 3 * this.getProcessingDelay();
                delayDest += 3 * this.getProcessingDelay();
            }
            this.addEventIn(delaySource, new AddressSim(dest), src, pid, new ConnectionDown(dest));
            this.addEventIn(delayDest, new AddressSim(src), dest, pid, new ConnectionDown(src));
        }
        if (c != null && c.protocolsUsing() == 0) {
            this.removeConnectionData(src, dest);
        }
    }

    @Override
    public void send(Node src, Address dest, int pid, Object payload) {
        this.send(src, ((AddressSim)dest).node, pid, payload);
    }

    private int getProcessingDelay() {
        if (this.applyProcessingDelay) {
            return (int)((long)this.processingDelay + Math.round(this.iterator.next() * (double)this.processingDelay));
        }
        return 0;
    }

    private int getLatency(Node src, Node dest) {
        return this.latency[(int)src.getID()][(int)dest.getID()];
    }

    @Override
    public void send(Node src, Node dest, int pid, Object payload) {
        int senderRouter = (int)src.getID() % RouterNetwork.getSize();
        int receiverRouter = dest.hashCode() % RouterNetwork.getSize();
        AddressSim senderAddress = new AddressSim(src);
        int latency = RouterNetwork.getLatency(senderRouter, receiverRouter) + this.getProcessingDelay();
        if (latency >= 0) {
            this.addEventIn(latency, senderAddress, dest, pid, payload);
        }
    }

    @Override
    public void fail(Node n) {
        HashSet<Node> outter;
        HashMap<Node, ConnectionData> inner = this.connections.remove(n);
        if (inner != null) {
            for (Node h : inner.keySet()) {
                ConnectionData cd = inner.get(h);
                Iterator<Integer> pids = cd.getPids();
                int delay = this.failureTimeoutFactor * this.getLatency(h, n);
                while (pids.hasNext()) {
                    int pid = pids.next();
                    this.addEventIn(delay + (this.applyProcessingDelay ? this.getProcessingDelay() : 0), new AddressSim(n), h, pid, new ConnectionDown(n));
                }
                this.reverseConnectionAuxiliar.get(h).remove(n);
            }
        }
        if ((outter = this.reverseConnectionAuxiliar.remove(n)) != null) {
            for (Node l : outter) {
                ConnectionData cd = this.connections.get(l).remove(n);
                Iterator<Integer> pids = cd.getPids();
                int delay = this.failureTimeoutFactor * this.getLatency(l, n);
                while (pids.hasNext()) {
                    int pid = pids.next();
                    this.addEventIn(delay + (this.applyProcessingDelay ? this.getProcessingDelay() : 0), new AddressSim(n), l, pid, new ConnectionDown(n));
                }
            }
        }
    }
}

