/*
 * Decompiled with CFR 0.152.
 */
package tardis.app;

import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoRequest;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.notifications.BroadcastDelivery;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.requests.BroadcastRequest;
import pt.unl.fct.di.novasys.network.data.Host;
import tardis.api.UserMessageListener;
import tardis.app.data.UserMessage;

public class DataDisseminationApp
extends GenericProtocol {
    public static final String PROTO_NAME = "TaRDIS Simple App";
    public static final short PROTO_ID = 9999;
    public static final String PAR_BCAST_PROTOCOL_ID = "app.bcast.id";
    private short bcastProtoID;
    public static final String PAR_BCAST_INIT_ENABLED = "app.bcast.enable";
    public static final boolean DEFAULT_BCAST_INIT_ENABLED = true;
    private final Host myself;
    private Logger logger = LogManager.getLogger(DataDisseminationApp.class);
    private AtomicBoolean executing;
    private UserMessageListener listener;

    public DataDisseminationApp(Host myself, UserMessageListener listener) throws HandlerRegistrationException {
        super(PROTO_NAME, (short)9999);
        this.myself = myself;
        this.listener = listener;
        this.subscribeNotification((short)501, this::handleDMessageDeliveryEvent);
    }

    public void init(Properties props) throws HandlerRegistrationException, IOException {
        if (props.containsKey(PAR_BCAST_PROTOCOL_ID)) {
            this.bcastProtoID = Short.parseShort(props.getProperty(PAR_BCAST_PROTOCOL_ID));
            this.logger.debug("DataDisseminationApp is configured to used broadcast protocol with id: " + this.bcastProtoID);
        } else {
            this.logger.error("The applicaiton requires the id of the broadcast protocol being used. Parameter: 'app.bcast.id'");
            System.exit(1);
        }
        boolean b = true;
        if (props.containsKey(PAR_BCAST_INIT_ENABLED)) {
            b = Boolean.parseBoolean(props.getProperty(PAR_BCAST_INIT_ENABLED));
        }
        this.executing = new AtomicBoolean(b);
    }

    public void sendUserMessage(UserMessage message) {
        if (!this.executing.getAcquire()) {
            return;
        }
        boolean success = false;
        byte[] data = null;
        try {
            data = message.toByteArray();
            success = true;
        }
        catch (Exception e) {
            this.logger.error("Failed to serialize UserMessage, falling back to String", (Throwable)e);
            data = message.getMessage().getBytes();
        }
        BroadcastRequest request = new BroadcastRequest(this.myself, data, 9999);
        this.sendRequest((ProtoRequest)request, this.bcastProtoID);
        if (!success) {
            this.logger.info(this.myself + " sent message: [" + this.myself + "::::" + DataDisseminationApp.readableOutput(message.getMessage()) + "]");
        } else if (message.hasAttachment()) {
            this.logger.info(this.myself + " sent message: [" + this.myself + "::::" + DataDisseminationApp.readableOutput(message.getMessage(), message.getAttachmentName()) + "]");
        } else {
            this.logger.info(this.myself + " sent message: [" + this.myself + "::::" + DataDisseminationApp.readableOutput(message.getMessage()) + "]");
        }
    }

    private void handleDMessageDeliveryEvent(BroadcastDelivery msg, short proto) {
        UserMessage um = null;
        String payload = null;
        try {
            um = UserMessage.fromByteArray(msg.getPayload());
            payload = um.getMessage();
        }
        catch (Exception e) {
            this.logger.error("Failed to deserialize UserMessage, falling back to String", (Throwable)e);
            payload = new String(msg.getPayload());
        }
        if (um == null) {
            this.logger.info(this.myself + " recv message: [" + msg.getSender() + "::::" + DataDisseminationApp.readableOutput(payload) + "]");
        } else if (um.hasAttachment()) {
            this.logger.info(this.myself + " recv message: [" + msg.getSender() + "::::" + DataDisseminationApp.readableOutput(um.getMessage(), um.getAttachmentName()) + "]");
        } else {
            this.logger.info(this.myself + " recv message: [" + msg.getSender() + "::::" + DataDisseminationApp.readableOutput(um.getMessage()) + "]");
        }
        if (this.listener != null && um != null) {
            this.logger.trace("Sending message with " + msg.getPayload().length + " bytes to thee external listener.");
            this.listener.deliverUserMessage(um);
        } else {
            this.logger.trace("Did not send message to external Listener. Reason listenner null (" + (this.listener == null) + ") message is null (" + (um == null) + ").");
        }
    }

    public static String readableOutput(String msg, String attachName) {
        return Hashing.sha256().hashString((CharSequence)(msg + "::" + attachName), StandardCharsets.UTF_8).toString();
    }

    private static String readableOutput(String msg) {
        if (msg.length() > 32) {
            return Hashing.sha256().hashString((CharSequence)msg, StandardCharsets.UTF_8).toString();
        }
        return msg;
    }

    public void disableTransmissions() {
        this.executing.set(false);
    }

    public boolean isTransmitting() {
        return this.executing.get();
    }

    public void enableTransmission() {
        this.executing.set(true);
    }
}

