/*
 * Decompiled with CFR 0.152.
 */
package tardis.app.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class UserMessage {
    public static final String PATTERN_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private final long timestamp;
    private final String sender;
    private final String alias;
    private final String message;
    private final String attachmentName;
    private final byte[] attach;

    public UserMessage(String sender, String alias, String msg) {
        this.timestamp = System.currentTimeMillis();
        this.sender = sender;
        this.alias = alias;
        this.message = msg;
        this.attachmentName = null;
        this.attach = null;
    }

    public UserMessage(long ts, String sender, String alias, String msg) {
        this.timestamp = ts;
        this.sender = sender;
        this.alias = alias;
        this.message = msg;
        this.attachmentName = null;
        this.attach = null;
    }

    public UserMessage(String sender, String alias, String msg, File f) throws IOException {
        this.timestamp = System.currentTimeMillis();
        this.sender = sender;
        this.alias = alias;
        this.message = msg;
        this.attachmentName = f.getName();
        this.attach = Files.readAllBytes(f.toPath());
    }

    public UserMessage(String sender, String alias, String msg, String filename, byte[] data) {
        this.timestamp = System.currentTimeMillis();
        this.sender = sender;
        this.alias = alias;
        this.message = msg;
        this.attachmentName = filename;
        this.attach = data;
    }

    public UserMessage(long ts, String sender, String alias, String msg, String filename, byte[] data) {
        this.timestamp = ts;
        this.sender = sender;
        this.alias = alias;
        this.message = msg;
        this.attachmentName = filename;
        this.attach = data;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTimeStampRepresentation() {
        return DateTimeFormatter.ofPattern(PATTERN_FORMAT).withZone(ZoneId.systemDefault()).format(Instant.ofEpochMilli(this.timestamp));
    }

    public String getSender() {
        return this.sender;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessage(int previewLen) {
        if (previewLen < this.message.length()) {
            return this.message.substring(0, previewLen);
        }
        return this.message;
    }

    public boolean hasAttachment() {
        return this.attachmentName != null;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public byte[] getAttach() {
        return this.attach;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeLong(this.timestamp);
        dos.writeUTF(this.sender);
        dos.writeUTF(this.alias);
        dos.writeUTF(this.message);
        if (this.attachmentName != null) {
            dos.writeBoolean(true);
            dos.writeUTF(this.attachmentName);
            dos.writeInt(this.attach.length);
            dos.write(this.attach);
        } else {
            dos.writeBoolean(false);
        }
        return baos.toByteArray();
    }

    public static UserMessage fromByteArray(byte[] uMsg) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(uMsg);
        DataInputStream dis = new DataInputStream(bais);
        long ts = dis.readLong();
        String sender = dis.readUTF();
        String alias = dis.readUTF();
        String message = dis.readUTF();
        if (dis.readBoolean()) {
            String attachName = dis.readUTF();
            byte[] data = new byte[dis.readInt()];
            dis.read(data);
            return new UserMessage(ts, sender, alias, message, attachName, data);
        }
        return new UserMessage(ts, sender, alias, message);
    }

    public int getAttachSize() {
        if (this.attach == null) {
            return 0;
        }
        return this.attach.length;
    }
}

