/*
 * Decompiled with CFR 0.152.
 */
package tardis;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.exceptions.InvalidParameterException;
import pt.unl.fct.di.novasys.babel.exceptions.ProtocolAlreadyExistsException;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.IoTRemoteControlProtocol;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.api.IoTDeviceListener;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.requestsi.ExecuteDeviceOperation;
import pt.unl.fct.di.novasys.babel.protocols.antientropy.AntiEntropy;
import pt.unl.fct.di.novasys.babel.protocols.eagerpush.EagerPushGossipBroadcast;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.HyParView;
import pt.unl.fct.di.novasys.babel.utils.NetworkingUtilities;
import pt.unl.fct.di.novasys.babel.utils.memebership.monitor.MembershipMonitor;
import pt.unl.fct.di.novasys.babel.utils.memebership.monitor.listener.MembershipMonitorListener;
import pt.unl.fct.di.novasys.babel.utils.overlayEstimations.RandomTour.RandomTour;
import pt.unl.fct.di.novasys.network.data.Host;
import tardis.api.UserMessageListener;
import tardis.app.DataDisseminationApp;
import tardis.app.data.UserMessage;

public class SimpleUseCase {
    private static final Logger logger;
    private static final String DEFAULT_CONF = "tardis.conf";
    private final Babel babel = Babel.getInstance();
    private Host myHost;
    private String address;
    private int port;
    private Properties props;
    private DataDisseminationApp app;
    private UserMessageListener listener;
    private IoTDeviceListener iotDeviceListener;
    private HyParView hyparview;
    private MembershipMonitor mm;
    private EagerPushGossipBroadcast bcast;
    private AntiEntropy at;
    private RandomTour randomTour;
    private IoTRemoteControlProtocol iotRemote;

    public SimpleUseCase(String[] args) throws IOException, InvalidParameterException, HandlerRegistrationException {
        if (new File(DEFAULT_CONF).exists()) {
            System.err.println("The config file: tardis.conf is not accessible.");
            System.exit(1);
        }
        this.props = Babel.loadConfig((String[])args, (String)DEFAULT_CONF);
        this.address = null;
        if (this.props.containsKey("babel.interface")) {
            this.address = NetworkingUtilities.getAddress((String)this.props.getProperty("babel.interface"));
        } else if (this.props.containsKey("babel.address")) {
            this.address = this.props.getProperty("babel.address");
        }
        this.port = -1;
        if (this.props.containsKey("babel.port")) {
            this.port = Integer.parseInt(this.props.getProperty("babel.port"));
        }
        this.myHost = this.address == null || this.port == -1 ? null : new Host(InetAddress.getByName(this.address), this.port);
        this.mm = new MembershipMonitor();
    }

    public Host getHost() {
        return this.myHost;
    }

    public void setHost(Host h) {
        this.myHost = h;
        this.props.setProperty("babel.address", this.myHost.getAddress().getHostAddress());
        this.props.setProperty("babel.port", "" + this.myHost.getPort());
    }

    public void setUserMessageListener(UserMessageListener listener) {
        this.listener = listener;
    }

    public void sendUserMessage(UserMessage message) {
        this.app.sendUserMessage(message);
    }

    public void setIoTDeviceListener(IoTDeviceListener listener) {
        this.iotDeviceListener = listener;
    }

    public void sendDeviceCommand(ExecuteDeviceOperation op) {
        this.app.sendDeviceCommand(op);
    }

    public void requestNodeAnnouncements() {
        this.app.requestNodeAnnouncements();
    }

    public void start() throws IOException, HandlerRegistrationException, ProtocolAlreadyExistsException {
        this.hyparview = new HyParView("channel.hyparview", this.props, this.myHost);
        Host gossipHost = new Host(this.myHost.getAddress(), this.myHost.getPort() + 1);
        this.bcast = new EagerPushGossipBroadcast("channel.gossip", this.props, gossipHost);
        this.at = new AntiEntropy(this.props, null);
        this.randomTour = new RandomTour(this.props, null);
        logger.info("Initializing the IoTRemoteControlProtocol with a IoTDeviceListener that is " + this.iotDeviceListener == null ? "null" : "not null");
        this.iotRemote = new IoTRemoteControlProtocol(gossipHost, this.iotDeviceListener);
        this.app = new DataDisseminationApp(gossipHost, this.listener);
        this.props.putIfAbsent("app.bcast.id", "1600");
        this.babel.registerProtocol((GenericProtocol)this.hyparview);
        logger.debug("Loaded: " + this.hyparview.getProtoName() + " " + this.hyparview.getProtoId());
        this.babel.registerProtocol((GenericProtocol)this.mm);
        logger.debug("Loaded: " + this.mm.getProtoName() + " " + this.mm.getProtoId());
        this.babel.registerProtocol((GenericProtocol)this.bcast);
        logger.debug("Loaded: " + this.bcast.getProtoName() + " " + this.bcast.getProtoId());
        this.babel.registerProtocol((GenericProtocol)this.at);
        logger.debug("Loaded: " + this.at.getProtoName() + " " + this.at.getProtoId());
        this.babel.registerProtocol((GenericProtocol)this.iotRemote);
        logger.debug("Loaded: " + this.iotRemote.getProtoName() + " " + this.at.getProtoId());
        this.babel.registerProtocol((GenericProtocol)this.randomTour);
        logger.debug("Loaded:" + this.randomTour.getProtoName() + " " + this.randomTour.getProtoId());
        this.babel.registerProtocol((GenericProtocol)this.app);
        logger.debug("Loaded: " + this.app.getProtoName() + " " + this.app.getProtoId());
        this.hyparview.init(this.props);
        this.mm.init(this.props);
        this.bcast.init(this.props);
        this.at.init(this.props);
        this.iotRemote.init(this.props);
        this.randomTour.init(this.props);
        this.app.init(this.props);
        System.out.println("Setup is complete.");
        this.babel.start();
        System.out.println("System is running.");
    }

    public void setMembershipListener(MembershipMonitorListener mcl) {
        this.mm.addMembershipListener(mcl);
    }

    public Host getMembershipHost() {
        if (this.hyparview != null) {
            return this.hyparview.getMyself();
        }
        return null;
    }

    public Host getGossipHost() {
        if (this.bcast != null) {
            return this.bcast.getHost();
        }
        return null;
    }

    public Host getAntiEntropyHost() {
        if (this.at != null) {
            return this.at.getHost();
        }
        return null;
    }

    public Properties getProperties() {
        return this.props;
    }

    static {
        System.setProperty("log4j.configurationFile", "log4j2.xml");
        System.setProperty("java.net.preferIPv4Stack", "true");
        logger = LogManager.getLogger(SimpleUseCase.class);
    }
}

