/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

@Immutable
public class CqlIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String internal;

    @NonNull
    public static CqlIdentifier fromCql(@NonNull String cql) {
        String internal;
        Preconditions.checkNotNull(cql, "cql must not be null");
        if (Strings.isDoubleQuoted(cql)) {
            internal = Strings.unDoubleQuote(cql);
        } else {
            internal = cql.toLowerCase();
            Preconditions.checkArgument(!Strings.needsDoubleQuotes(internal), "Invalid CQL form [%s]: needs double quotes", (Object)cql);
        }
        return CqlIdentifier.fromInternal(internal);
    }

    @NonNull
    public static CqlIdentifier fromInternal(@NonNull String internal) {
        Preconditions.checkNotNull(internal, "internal must not be null");
        return new CqlIdentifier(internal);
    }

    private CqlIdentifier(String internal) {
        this.internal = internal;
    }

    @NonNull
    public String asInternal() {
        return this.internal;
    }

    @NonNull
    public String asCql(boolean pretty) {
        if (pretty) {
            return Strings.needsDoubleQuotes(this.internal) ? Strings.doubleQuote(this.internal) : this.internal;
        }
        return Strings.doubleQuote(this.internal);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CqlIdentifier) {
            CqlIdentifier that = (CqlIdentifier)other;
            return this.internal.equals(that.internal);
        }
        return false;
    }

    public int hashCode() {
        return this.internal.hashCode();
    }

    public String toString() {
        return this.internal;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Preconditions.checkNotNull(this.internal, "internal must not be null");
    }
}

