/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.adminrequest;

import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRequestHandler;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.protocol.internal.Message;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ThrottledAdminRequestHandler
extends AdminRequestHandler
implements Throttled {
    private final long startTimeNanos = System.nanoTime();
    private final RequestThrottler throttler;
    private final SessionMetricUpdater metricUpdater;

    public ThrottledAdminRequestHandler(DriverChannel channel, Message message, Map<String, ByteBuffer> customPayload, Duration timeout, RequestThrottler throttler, SessionMetricUpdater metricUpdater, String logPrefix, String debugString) {
        super(channel, message, customPayload, timeout, logPrefix, debugString);
        this.throttler = throttler;
        this.metricUpdater = metricUpdater;
    }

    @Override
    public CompletionStage<AdminResult> start() {
        this.throttler.register(this);
        return this.result;
    }

    @Override
    public void onThrottleReady(boolean wasDelayed) {
        if (wasDelayed) {
            this.metricUpdater.updateTimer(DefaultSessionMetric.THROTTLING_DELAY, null, System.nanoTime() - this.startTimeNanos, TimeUnit.NANOSECONDS);
        }
        super.start();
    }

    @Override
    public void onThrottleFailure(@NonNull RequestThrottlingException error) {
        this.metricUpdater.incrementCounter(DefaultSessionMetric.THROTTLING_ERRORS, null);
        this.setFinalError(error);
    }

    @Override
    protected boolean setFinalResult(AdminResult result) {
        boolean wasSet = super.setFinalResult(result);
        if (wasSet) {
            this.throttler.signalSuccess(this);
        }
        return wasSet;
    }

    @Override
    protected boolean setFinalError(Throwable error) {
        boolean wasSet = super.setFinalError(error);
        if (wasSet) {
            if (error instanceof DriverTimeoutException) {
                this.throttler.signalTimeout(this);
            } else if (!(error instanceof RequestThrottlingException)) {
                this.throttler.signalError(this, error);
            }
        }
        return wasSet;
    }
}

