/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.DefaultRow;
import com.datastax.oss.driver.internal.core.cql.EmptyColumnDefinitions;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultAsyncResultSet
implements AsyncResultSet {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAsyncResultSet.class);
    private final ColumnDefinitions definitions;
    private final ExecutionInfo executionInfo;
    private final CqlSession session;
    private final CountingIterator<Row> iterator;
    private final Iterable<Row> currentPage;

    public DefaultAsyncResultSet(final ColumnDefinitions definitions, ExecutionInfo executionInfo, final Queue<List<ByteBuffer>> data, CqlSession session, final InternalDriverContext context) {
        this.definitions = definitions;
        this.executionInfo = executionInfo;
        this.session = session;
        this.iterator = new CountingIterator<Row>(data.size()){

            @Override
            protected Row computeNext() {
                List rowData = (List)data.poll();
                return rowData == null ? (Row)this.endOfData() : new DefaultRow(definitions, rowData, context);
            }
        };
        this.currentPage = () -> this.iterator;
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.definitions;
    }

    @Override
    @NonNull
    public ExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    @Override
    @NonNull
    public Iterable<Row> currentPage() {
        return this.currentPage;
    }

    @Override
    public int remaining() {
        return this.iterator.remaining();
    }

    @Override
    public boolean hasMorePages() {
        return this.executionInfo.getPagingState() != null;
    }

    @Override
    @NonNull
    public CompletionStage<AsyncResultSet> fetchNextPage() throws IllegalStateException {
        ByteBuffer nextState = this.executionInfo.getPagingState();
        if (nextState == null) {
            throw new IllegalStateException("No next page. Use #hasMorePages before calling this method to avoid this error.");
        }
        Statement<?> statement = this.executionInfo.getStatement();
        LOG.trace("Fetching next page for {}", (Object)statement);
        Object nextStatement = statement.copy(nextState);
        return this.session.executeAsync((Statement<?>)nextStatement);
    }

    @Override
    public boolean wasApplied() {
        if (!this.definitions.contains("[applied]") || !this.definitions.get("[applied]").getType().equals(DataTypes.BOOLEAN)) {
            return true;
        }
        if (this.iterator.hasNext()) {
            return this.iterator.peek().getBoolean("[applied]");
        }
        throw new IllegalStateException("This method must be called before consuming all the rows");
    }

    static AsyncResultSet empty(final ExecutionInfo executionInfo) {
        return new AsyncResultSet(){

            @Override
            @NonNull
            public ColumnDefinitions getColumnDefinitions() {
                return EmptyColumnDefinitions.INSTANCE;
            }

            @Override
            @NonNull
            public ExecutionInfo getExecutionInfo() {
                return executionInfo;
            }

            @Override
            @NonNull
            public Iterable<Row> currentPage() {
                return Collections.emptyList();
            }

            @Override
            public int remaining() {
                return 0;
            }

            @Override
            public boolean hasMorePages() {
                return false;
            }

            @Override
            @NonNull
            public CompletionStage<AsyncResultSet> fetchNextPage() throws IllegalStateException {
                throw new IllegalStateException("No next page. Use #hasMorePages before calling this method to avoid this error.");
            }

            @Override
            public boolean wasApplied() {
                return true;
            }
        };
    }
}

