/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class SinglePageResultSet
implements ResultSet {
    private final AsyncResultSet onlyPage;

    public SinglePageResultSet(AsyncResultSet onlyPage) {
        this.onlyPage = onlyPage;
        assert (!onlyPage.hasMorePages());
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.onlyPage.getColumnDefinitions();
    }

    @Override
    @NonNull
    public ExecutionInfo getExecutionInfo() {
        return this.onlyPage.getExecutionInfo();
    }

    @Override
    @NonNull
    public List<ExecutionInfo> getExecutionInfos() {
        return ImmutableList.of(this.onlyPage.getExecutionInfo());
    }

    @Override
    public boolean isFullyFetched() {
        return true;
    }

    @Override
    public int getAvailableWithoutFetching() {
        return this.onlyPage.remaining();
    }

    @Override
    @NonNull
    public Iterator<Row> iterator() {
        return this.onlyPage.currentPage().iterator();
    }

    @Override
    public boolean wasApplied() {
        return this.onlyPage.wasApplied();
    }
}

