/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.data.ValuesHelper;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultTupleValue
implements TupleValue,
Serializable {
    private static final long serialVersionUID = 1L;
    private final TupleType type;
    private final ByteBuffer[] values;

    public DefaultTupleValue(@NonNull TupleType type) {
        this(type, new ByteBuffer[type.getComponentTypes().size()]);
    }

    public DefaultTupleValue(@NonNull TupleType type, Object ... values) {
        this(type, ValuesHelper.encodeValues(values, type.getComponentTypes(), type.getAttachmentPoint().getCodecRegistry(), type.getAttachmentPoint().getProtocolVersion()));
    }

    private DefaultTupleValue(TupleType type, ByteBuffer[] values) {
        Preconditions.checkNotNull(type);
        this.type = type;
        this.values = values;
    }

    @Override
    @NonNull
    public TupleType getType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public ByteBuffer getBytesUnsafe(int i) {
        return this.values[i];
    }

    @Override
    @NonNull
    public TupleValue setBytesUnsafe(int i, @Nullable ByteBuffer v) {
        this.values[i] = v;
        return this;
    }

    @Override
    @NonNull
    public DataType getType(int i) {
        return this.type.getComponentTypes().get(i);
    }

    @Override
    @NonNull
    public CodecRegistry codecRegistry() {
        return this.type.getAttachmentPoint().getCodecRegistry();
    }

    @Override
    @NonNull
    public ProtocolVersion protocolVersion() {
        return this.type.getAttachmentPoint().getProtocolVersion();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TupleValue)) {
            return false;
        }
        TupleValue that = (TupleValue)o;
        if (!this.type.equals(that.getType())) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            DataType thatValue;
            DataType innerThatType;
            DataType innerThisType = this.type.getComponentTypes().get(i);
            if (!innerThisType.equals(innerThatType = that.getType().getComponentTypes().get(i))) {
                return false;
            }
            DataType thisValue = this.codecRegistry().codecFor(innerThisType).decode(this.getBytesUnsafe(i), this.protocolVersion());
            if (Objects.equals(thisValue, thatValue = that.codecRegistry().codecFor(innerThatType).decode(that.getBytesUnsafe(i), that.protocolVersion()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        for (int i = 0; i < this.values.length; ++i) {
            DataType innerThisType = this.type.getComponentTypes().get(i);
            DataType thisValue = this.codecRegistry().codecFor(innerThisType).decode(this.values[i], this.protocolVersion());
            if (thisValue == null) continue;
            result = 31 * result + thisValue.hashCode();
        }
        return result;
    }

    public String toString() {
        return this.codecRegistry().codecFor(this.type).format((TupleType)((Object)this));
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TupleType type;
        private final byte[][] values;

        SerializationProxy(DefaultTupleValue tuple) {
            this.type = tuple.type;
            this.values = new byte[tuple.values.length][];
            for (int i = 0; i < tuple.values.length; ++i) {
                ByteBuffer buffer = tuple.values[i];
                this.values[i] = buffer == null ? null : Bytes.getArray(buffer);
            }
        }

        private Object readResolve() {
            ByteBuffer[] buffers = new ByteBuffer[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                byte[] value = this.values[i];
                buffers[i] = value == null ? null : ByteBuffer.wrap(value);
            }
            return new DefaultTupleValue(this.type, buffers);
        }
    }
}

