/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.protocol.ByteBufCompressor;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Lz4Compressor
extends ByteBufCompressor {
    private static final Logger LOG = LoggerFactory.getLogger(Lz4Compressor.class);
    private final LZ4Compressor compressor;
    private final LZ4FastDecompressor decompressor;

    public Lz4Compressor(DriverContext context) {
        try {
            LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
            LOG.info("[{}] Using {}", (Object)context.getSessionName(), (Object)lz4Factory.toString());
            this.compressor = lz4Factory.fastCompressor();
            this.decompressor = lz4Factory.fastDecompressor();
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException("Error initializing compressor, make sure that the LZ4 library is in the classpath (the driver declares it as an optional dependency, so you need to declare it explicitly)", e);
        }
    }

    @Override
    public String algorithm() {
        return "lz4";
    }

    @Override
    protected ByteBuf compressDirect(ByteBuf input) {
        int maxCompressedLength = this.compressor.maxCompressedLength(input.readableBytes());
        ByteBuf output = input.alloc().directBuffer(4 + maxCompressedLength);
        try {
            ByteBuffer in = Lz4Compressor.inputNioBuffer(input);
            input.readerIndex(input.writerIndex());
            output.writeInt(in.remaining());
            ByteBuffer out = Lz4Compressor.outputNioBuffer(output);
            int written = this.compressor.compress(in, in.position(), in.remaining(), out, out.position(), out.remaining());
            output.writerIndex(output.writerIndex() + written);
        }
        catch (Exception e) {
            output.release();
            throw e;
        }
        return output;
    }

    @Override
    protected ByteBuf compressHeap(ByteBuf input) {
        int maxCompressedLength = this.compressor.maxCompressedLength(input.readableBytes());
        int inOffset = input.arrayOffset() + input.readerIndex();
        byte[] in = input.array();
        int len = input.readableBytes();
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().heapBuffer(4 + maxCompressedLength);
        try {
            output.writeInt(len);
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int written = this.compressor.compress(in, inOffset, len, out, offset);
            output.writerIndex(output.writerIndex() + written);
        }
        catch (Exception e) {
            output.release();
            throw e;
        }
        return output;
    }

    @Override
    protected ByteBuf decompressDirect(ByteBuf input) {
        int readable = input.readableBytes();
        int uncompressedLength = input.readInt();
        ByteBuffer in = Lz4Compressor.inputNioBuffer(input);
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().directBuffer(uncompressedLength);
        try {
            ByteBuffer out = Lz4Compressor.outputNioBuffer(output);
            int read = this.decompressor.decompress(in, in.position(), out, out.position(), out.remaining());
            if (read != readable - 4) {
                throw new IllegalArgumentException("Compressed lengths mismatch");
            }
            output.writerIndex(output.writerIndex() + uncompressedLength);
        }
        catch (Exception e) {
            output.release();
            throw e;
        }
        return output;
    }

    @Override
    protected ByteBuf decompressHeap(ByteBuf input) {
        byte[] in = input.array();
        int len = input.readableBytes();
        int uncompressedLength = input.readInt();
        int inOffset = input.arrayOffset() + input.readerIndex();
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().heapBuffer(uncompressedLength);
        try {
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int read = this.decompressor.decompress(in, inOffset, out, offset, uncompressedLength);
            if (read != len - 4) {
                throw new IllegalArgumentException("Compressed lengths mismatch");
            }
            output.writerIndex(output.writerIndex() + uncompressedLength);
        }
        catch (Exception e) {
            output.release();
            throw e;
        }
        return output;
    }
}

