/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.channels.multi;

import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.channel.ChannelListener;
import pt.unl.fct.di.novasys.channel.base.SingleThreadedBiChannel;
import pt.unl.fct.di.novasys.channel.tcp.ConnectionState;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.NetworkManager;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Host;

class ProtoConnections {
    private static final Logger logger = LogManager.getLogger(ProtoConnections.class);
    static final String PROTO_ID = "Protocol_ID";
    private static final int CONNECTION_OUT = 0;
    private static final int CONNECTION_IN = 1;
    private final Map<Host, LinkedList<Connection<BabelMessage>>> inConnections;
    private final Map<Host, ConnectionState<BabelMessage>> outConnections;
    private final SingleThreadedBiChannel<BabelMessage, BabelMessage> channel;
    private final NetworkManager<BabelMessage> network;
    private final ChannelListener<BabelMessage> listener;
    private final DefaultEventExecutor loop;
    private final Attributes attributes;

    ProtoConnections(DefaultEventExecutor loop, short protoId, Attributes attributes, ChannelListener<BabelMessage> listener, NetworkManager<BabelMessage> network, SingleThreadedBiChannel<BabelMessage, BabelMessage> channel) {
        this.channel = channel;
        this.network = network;
        this.listener = listener;
        this.loop = loop;
        this.attributes = attributes.deepClone();
        this.attributes.putShort(PROTO_ID, protoId);
        this.inConnections = new HashMap<Host, LinkedList<Connection<BabelMessage>>>();
        this.outConnections = new HashMap<Host, ConnectionState<BabelMessage>>();
    }

    void sendMessage(BabelMessage msg, Host peer, int connection) {
        logger.debug("SendMessage " + msg + " " + peer + " " + (connection == 1 ? "IN" : "OUT"));
        if (connection <= 0) {
            ConnectionState conState = this.outConnections.computeIfAbsent(peer, k -> {
                logger.debug("onSendMessage creating connection to: " + peer);
                return new ConnectionState<BabelMessage>(this.network.createConnection(peer, this.attributes, this.channel));
            });
            if (conState.getState() == ConnectionState.State.CONNECTING) {
                conState.getQueue().add(msg);
            } else if (conState.getState() == ConnectionState.State.CONNECTED) {
                this.sendWithListener(msg, peer, conState.getConnection());
            } else if (conState.getState() == ConnectionState.State.DISCONNECTING) {
                conState.getQueue().add(msg);
                conState.setState(ConnectionState.State.DISCONNECTING_RECONNECT);
            } else if (conState.getState() == ConnectionState.State.DISCONNECTING_RECONNECT) {
                conState.getQueue().add(msg);
            }
        } else if (connection == 1) {
            LinkedList<Connection<BabelMessage>> inConnList = this.inConnections.get(peer);
            if (inConnList != null) {
                this.sendWithListener(msg, peer, inConnList.getLast());
            } else {
                this.listener.messageFailed(msg, peer, new IllegalArgumentException("No incoming connection"));
            }
        } else {
            this.listener.messageFailed(msg, peer, new IllegalArgumentException("Invalid connection: " + connection));
            logger.error("Invalid sendMessage mode " + connection);
        }
    }

    private void sendWithListener(BabelMessage msg, Host peer, Connection<BabelMessage> established) {
        Promise<Void> promise = this.loop.newPromise();
        promise.addListener(future -> {
            if (future.isSuccess()) {
                this.listener.messageSent(msg, peer);
            } else {
                this.listener.messageFailed(msg, peer, future.cause());
            }
        });
        established.sendMessage(msg, promise);
    }

    void disconnect(Host peer) {
        logger.debug("CloseConnection " + peer);
        ConnectionState<BabelMessage> conState = this.outConnections.get(peer);
        if (conState != null && (conState.getState() == ConnectionState.State.CONNECTED || conState.getState() == ConnectionState.State.CONNECTING || conState.getState() == ConnectionState.State.DISCONNECTING_RECONNECT)) {
            conState.setState(ConnectionState.State.DISCONNECTING);
            conState.getQueue().clear();
            conState.getConnection().disconnect();
        }
    }

    void addInboundConnection(Host clientSocket, Connection<BabelMessage> connection) {
        LinkedList inConnList = this.inConnections.computeIfAbsent(clientSocket, k -> new LinkedList());
        inConnList.add(connection);
        if (inConnList.size() == 1) {
            logger.debug("InboundConnectionUp " + clientSocket);
            this.listener.deliverEvent(new InConnectionUp(clientSocket));
        } else {
            logger.debug("Multiple InboundConnectionUp " + inConnList.size() + clientSocket);
        }
    }

    void removeInboundConnection(Connection<BabelMessage> connection, Throwable cause) {
        Host clientSocket;
        try {
            clientSocket = connection.getPeerAttributes().getHost("listen_address");
        }
        catch (IOException e) {
            logger.error("Inbound connection without valid listen address in connectionDown: " + e.getMessage());
            connection.disconnect();
            return;
        }
        LinkedList<Connection<BabelMessage>> inConnList = this.inConnections.get(clientSocket);
        if (inConnList == null || inConnList.isEmpty()) {
            throw new AssertionError((Object)("No connections in InboundConnectionDown " + clientSocket));
        }
        if (!inConnList.remove(connection)) {
            throw new AssertionError((Object)("No connection in InboundConnectionDown " + clientSocket));
        }
        if (inConnList.isEmpty()) {
            logger.debug("InboundConnectionDown " + clientSocket + (cause != null ? " " + cause : ""));
            this.listener.deliverEvent(new InConnectionDown(clientSocket, cause));
            this.inConnections.remove(clientSocket);
        } else {
            logger.debug("Extra InboundConnectionDown " + inConnList.size() + clientSocket);
        }
    }

    void addOutboundConnection(Connection<BabelMessage> connection) {
        logger.debug("OutboundConnectionUp " + connection.getPeer());
        ConnectionState<BabelMessage> conState = this.outConnections.get(connection.getPeer());
        if (conState == null) {
            throw new AssertionError((Object)("ConnectionUp with no conState: " + connection));
        }
        if (conState.getState() == ConnectionState.State.CONNECTED) {
            throw new AssertionError((Object)("ConnectionUp in CONNECTED state: " + connection));
        }
        if (conState.getState() == ConnectionState.State.CONNECTING) {
            conState.setState(ConnectionState.State.CONNECTED);
            conState.getQueue().forEach(m4 -> this.sendWithListener((BabelMessage)m4, connection.getPeer(), connection));
            conState.getQueue().clear();
            this.listener.deliverEvent(new OutConnectionUp(connection.getPeer()));
        }
    }

    void removeOutboundConnection(Connection<BabelMessage> connection, Throwable cause) {
        logger.debug("OutboundConnectionDown " + connection.getPeer() + (cause != null ? " " + cause : ""));
        ConnectionState<BabelMessage> conState = this.outConnections.remove(connection.getPeer());
        if (conState == null) {
            throw new AssertionError((Object)("ConnectionDown with no conState: " + connection));
        }
        if (conState.getState() == ConnectionState.State.CONNECTING) {
            throw new AssertionError((Object)("ConnectionDown in CONNECTING state: " + connection));
        }
        if (conState.getState() == ConnectionState.State.CONNECTED) {
            this.listener.deliverEvent(new OutConnectionDown(connection.getPeer(), cause));
        } else if (conState.getState() == ConnectionState.State.DISCONNECTING_RECONNECT) {
            this.outConnections.put(connection.getPeer(), new ConnectionState<BabelMessage>(this.network.createConnection(connection.getPeer(), this.attributes, this.channel), conState.getQueue()));
        }
    }

    void failedOutboundConnection(Connection<BabelMessage> connection, Throwable cause) {
        logger.debug("OutboundConnectionFailed " + connection.getPeer() + (cause != null ? " " + cause : ""));
        ConnectionState<BabelMessage> conState = this.outConnections.remove(connection.getPeer());
        if (conState == null) {
            throw new AssertionError((Object)("ConnectionFailed with no conState: " + connection));
        }
        if (conState.getState() == ConnectionState.State.CONNECTING) {
            this.listener.deliverEvent(new OutConnectionFailed<BabelMessage>(connection.getPeer(), conState.getQueue(), cause));
        } else if (conState.getState() == ConnectionState.State.DISCONNECTING_RECONNECT) {
            this.outConnections.put(connection.getPeer(), new ConnectionState<BabelMessage>(this.network.createConnection(connection.getPeer(), this.attributes, this.channel), conState.getQueue()));
        } else if (conState.getState() == ConnectionState.State.CONNECTED) {
            throw new AssertionError((Object)("ConnectionFailed in state: " + (Object)((Object)conState.getState()) + " - " + connection));
        }
    }

    void deliverMessage(BabelMessage msg, Connection<BabelMessage> connection) {
        Host host;
        if (connection.isInbound()) {
            try {
                host = connection.getPeerAttributes().getHost("listen_address");
            }
            catch (IOException e) {
                logger.error("Inbound connection without valid listen address in deliver message: " + e.getMessage());
                connection.disconnect();
                return;
            }
        } else {
            host = connection.getPeer();
        }
        logger.debug("DeliverMessage " + msg + " " + host + " " + (connection.isInbound() ? "IN" : "OUT"));
        this.listener.deliverMessage(msg, host);
    }
}

