/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.exceptions.NoSuchProtocolException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.generic.ProtoNotification;
import pt.unl.fct.di.novasys.babel.generic.ProtoReply;
import pt.unl.fct.di.novasys.babel.generic.ProtoRequest;
import pt.unl.fct.di.novasys.babel.generic.ProtoTimer;
import pt.unl.fct.di.novasys.babel.handlers.ChannelEventHandler;
import pt.unl.fct.di.novasys.babel.handlers.MessageFailedHandler;
import pt.unl.fct.di.novasys.babel.handlers.MessageInHandler;
import pt.unl.fct.di.novasys.babel.handlers.MessageSentHandler;
import pt.unl.fct.di.novasys.babel.handlers.NotificationHandler;
import pt.unl.fct.di.novasys.babel.handlers.ReplyHandler;
import pt.unl.fct.di.novasys.babel.handlers.RequestHandler;
import pt.unl.fct.di.novasys.babel.handlers.TimerHandler;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.babel.internal.CustomChannelEvent;
import pt.unl.fct.di.novasys.babel.internal.IPCEvent;
import pt.unl.fct.di.novasys.babel.internal.InternalEvent;
import pt.unl.fct.di.novasys.babel.internal.MessageFailedEvent;
import pt.unl.fct.di.novasys.babel.internal.MessageInEvent;
import pt.unl.fct.di.novasys.babel.internal.MessageSentEvent;
import pt.unl.fct.di.novasys.babel.internal.NotificationEvent;
import pt.unl.fct.di.novasys.babel.internal.TimerEvent;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricsManager;
import pt.unl.fct.di.novasys.channel.ChannelEvent;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public abstract class GenericProtocol {
    private static final Logger logger = LogManager.getLogger(GenericProtocol.class);
    private final BlockingQueue<InternalEvent> queue;
    private final Thread executionThread;
    private final String protoName;
    private final short protoId;
    private int defaultChannel;
    private final Map<Integer, ChannelHandlers> channels;
    private final Map<Short, TimerHandler<? extends ProtoTimer>> timerHandlers;
    private final Map<Short, RequestHandler<? extends ProtoRequest>> requestHandlers;
    private final Map<Short, ReplyHandler<? extends ProtoReply>> replyHandlers;
    private final Map<Short, NotificationHandler<? extends ProtoNotification>> notificationHandlers;
    private static final Babel babel = Babel.getInstance();
    ProtocolMetrics metrics = new ProtocolMetrics();

    public GenericProtocol(String protoName, short protoId, BlockingQueue<InternalEvent> policy) {
        this.queue = policy;
        this.protoId = protoId;
        this.protoName = protoName;
        this.executionThread = new Thread(this::mainLoop, protoId + "-" + protoName);
        this.channels = new HashMap<Integer, ChannelHandlers>();
        this.defaultChannel = -1;
        this.timerHandlers = new HashMap<Short, TimerHandler<? extends ProtoTimer>>();
        this.requestHandlers = new HashMap<Short, RequestHandler<? extends ProtoRequest>>();
        this.replyHandlers = new HashMap<Short, ReplyHandler<? extends ProtoReply>>();
        this.notificationHandlers = new HashMap<Short, NotificationHandler<? extends ProtoNotification>>();
    }

    public GenericProtocol(String protoName, short protoId) {
        this(protoName, protoId, new LinkedBlockingQueue<InternalEvent>());
    }

    public final short getProtoId() {
        return this.protoId;
    }

    public final String getProtoName() {
        return this.protoName;
    }

    public abstract void init(Properties var1) throws HandlerRegistrationException, IOException;

    public final void start() {
        this.executionThread.start();
    }

    public ProtocolMetrics getMetrics() {
        return this.metrics;
    }

    protected long getMillisSinceBabelStart() {
        return babel.getMillisSinceStart();
    }

    protected void registerMetric(Metric m4) {
        MetricsManager.getInstance().registerMetric(m4);
    }

    private <V> void registerHandler(short id, V handler, Map<Short, V> handlerMap) throws HandlerRegistrationException {
        if (handlerMap.putIfAbsent(id, handler) != null) {
            throw new HandlerRegistrationException("Conflict in registering handler for " + handler.getClass().toString() + " with id " + id + ".");
        }
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, null, null);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, MessageSentHandler<V> sentHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, sentHandler, null);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, MessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, null, failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, MessageSentHandler<V> sentHandler, MessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerHandler(msgId, inHandler, this.getChannelOrThrow(cId).messageInHandlers);
        if (sentHandler != null) {
            this.registerHandler(msgId, sentHandler, this.getChannelOrThrow(cId).messageSentHandlers);
        }
        if (failHandler != null) {
            this.registerHandler(msgId, failHandler, this.getChannelOrThrow(cId).messageFailedHandlers);
        }
    }

    protected final <V extends ChannelEvent> void registerChannelEventHandler(int cId, short eventId, ChannelEventHandler<V> handler) throws HandlerRegistrationException {
        this.registerHandler(eventId, handler, this.getChannelOrThrow(cId).channelEventHandlers);
    }

    protected final <V extends ProtoTimer> void registerTimerHandler(short timerID, TimerHandler<V> handler) throws HandlerRegistrationException {
        this.registerHandler(timerID, handler, this.timerHandlers);
    }

    protected final <V extends ProtoRequest> void registerRequestHandler(short requestId, RequestHandler<V> handler) throws HandlerRegistrationException {
        this.registerHandler(requestId, handler, this.requestHandlers);
    }

    protected final <V extends ProtoReply> void registerReplyHandler(short replyId, ReplyHandler<V> handler) throws HandlerRegistrationException {
        this.registerHandler(replyId, handler, this.replyHandlers);
    }

    private ChannelHandlers getChannelOrThrow(int channelId) {
        ChannelHandlers handlers = this.channels.get(channelId);
        if (handlers == null) {
            throw new AssertionError((Object)("Channel does not exist: " + channelId));
        }
        return handlers;
    }

    protected final void registerMessageSerializer(int channelId, short msgId, ISerializer<? extends ProtoMessage> serializer) {
        babel.registerSerializer(channelId, msgId, serializer);
    }

    protected final int createChannel(String channelName, Properties props) throws IOException {
        int channelId = babel.createChannel(channelName, this.protoId, props);
        this.registerSharedChannel(channelId);
        return channelId;
    }

    protected final void registerSharedChannel(int channelId) {
        babel.registerChannelInterest(channelId, this.protoId, this);
        this.channels.put(channelId, new ChannelHandlers());
        if (this.defaultChannel == -1) {
            this.setDefaultChannel(channelId);
        }
    }

    protected final void setDefaultChannel(int channelId) {
        this.getChannelOrThrow(channelId);
        this.defaultChannel = channelId;
    }

    protected final void sendMessage(ProtoMessage msg, Host destination) {
        this.sendMessage(this.defaultChannel, msg, this.protoId, destination, 0);
    }

    protected final void sendMessage(int channelId, ProtoMessage msg, Host destination) {
        this.sendMessage(channelId, msg, this.protoId, destination, 0);
    }

    protected final void sendMessage(ProtoMessage msg, short destProto, Host destination) {
        this.sendMessage(this.defaultChannel, msg, destProto, destination, 0);
    }

    protected final void sendMessage(ProtoMessage msg, Host destination, int connection) {
        this.sendMessage(this.defaultChannel, msg, this.protoId, destination, connection);
    }

    protected final void sendMessage(int channelId, ProtoMessage msg, Host destination, int connection) {
        this.sendMessage(channelId, msg, this.protoId, destination, connection);
    }

    protected final void sendMessage(ProtoMessage msg, short destProto, Host destination, int connection) {
        this.sendMessage(this.defaultChannel, msg, destProto, destination, connection);
    }

    protected final void sendMessage(int channelId, ProtoMessage msg, short destProto, Host destination, int connection) {
        this.getChannelOrThrow(channelId);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending: " + msg + " to " + destination + " proto " + destProto + " channel " + channelId);
        }
        babel.sendMessage(channelId, connection, new BabelMessage(msg, this.protoId, destProto), destination);
    }

    protected final void openConnection(Host peer) {
        this.openConnection(peer, this.defaultChannel);
    }

    protected final void openConnection(Host peer, int channelId) {
        babel.openConnection(channelId, peer, this.protoId);
    }

    protected final void closeConnection(Host peer) {
        this.closeConnection(peer, this.defaultChannel);
    }

    protected final void closeConnection(Host peer, int channelId) {
        this.closeConnection(peer, channelId, this.protoId);
    }

    protected final void closeConnection(Host peer, int channelId, int connection) {
        babel.closeConnection(channelId, peer, connection);
    }

    protected final void sendRequest(ProtoRequest request, short destination) throws NoSuchProtocolException {
        babel.sendIPC(new IPCEvent(request, this.protoId, destination));
    }

    protected final void sendReply(ProtoReply reply, short destination) throws NoSuchProtocolException {
        babel.sendIPC(new IPCEvent(reply, this.protoId, destination));
    }

    protected final <V extends ProtoNotification> void subscribeNotification(short nId, NotificationHandler<V> h2) throws HandlerRegistrationException {
        this.registerHandler(nId, h2, this.notificationHandlers);
        babel.subscribeNotification(nId, this);
    }

    protected final void unsubscribeNotification(short nId) {
        this.notificationHandlers.remove(nId);
        babel.unsubscribeNotification(nId, this);
    }

    protected final void triggerNotification(ProtoNotification n) {
        babel.triggerNotification(new NotificationEvent(n, this.protoId));
    }

    protected long setupPeriodicTimer(ProtoTimer timer, long first, long period) {
        return babel.setupPeriodicTimer(timer, this, first, period);
    }

    protected long setupTimer(ProtoTimer t2, long timeout) {
        return babel.setupTimer(t2, this, timeout);
    }

    protected ProtoTimer cancelTimer(long timerID) {
        return babel.cancelTimer(timerID);
    }

    final void deliverChannelEvent(CustomChannelEvent event) {
        this.queue.add(event);
    }

    protected final void deliverMessageIn(MessageInEvent msgIn) {
        this.queue.add(msgIn);
    }

    final void deliverMessageSent(MessageSentEvent event) {
        this.queue.add(event);
    }

    final void deliverMessageFailed(MessageFailedEvent event) {
        this.queue.add(event);
    }

    final void deliverTimer(TimerEvent timer) {
        this.queue.add(timer);
    }

    final void deliverNotification(NotificationEvent notification) {
        this.queue.add(notification);
    }

    final void deliverIPC(IPCEvent ipc) {
        this.queue.add(ipc);
    }

    private void mainLoop() {
        block15: while (true) {
            try {
                InternalEvent pe = this.queue.take();
                this.metrics.totalEventsCount++;
                if (logger.isDebugEnabled()) {
                    logger.debug("Handling event: " + pe);
                }
                switch (pe.getType()) {
                    case MESSAGE_IN_EVENT: {
                        this.metrics.messagesInCount++;
                        this.handleMessageIn((MessageInEvent)pe);
                        continue block15;
                    }
                    case MESSAGE_FAILED_EVENT: {
                        this.metrics.messagesFailedCount++;
                        this.handleMessageFailed((MessageFailedEvent)pe);
                        continue block15;
                    }
                    case MESSAGE_SENT_EVENT: {
                        this.metrics.messagesSentCount++;
                        this.handleMessageSent((MessageSentEvent)pe);
                        continue block15;
                    }
                    case TIMER_EVENT: {
                        this.metrics.timersCount++;
                        this.handleTimer((TimerEvent)pe);
                        continue block15;
                    }
                    case NOTIFICATION_EVENT: {
                        this.metrics.notificationsCount++;
                        this.handleNotification((NotificationEvent)pe);
                        continue block15;
                    }
                    case IPC_EVENT: {
                        IPCEvent i = (IPCEvent)pe;
                        switch (i.getIpc().getType()) {
                            case REPLY: {
                                this.metrics.repliesCount++;
                                this.handleReply((ProtoReply)i.getIpc(), i.getSenderID());
                                continue block15;
                            }
                            case REQUEST: {
                                this.metrics.requestsCount++;
                                this.handleRequest((ProtoRequest)i.getIpc(), i.getSenderID());
                                continue block15;
                            }
                        }
                        throw new AssertionError((Object)"Ups");
                    }
                    case CUSTOM_CHANNEL_EVENT: {
                        this.metrics.customChannelEventsCount++;
                        this.handleChannelEvent((CustomChannelEvent)pe);
                        continue block15;
                    }
                }
                throw new AssertionError((Object)("Unexpected event received by babel. protocol " + this.protoId + " (" + this.protoName + ")"));
            }
            catch (Exception e) {
                logger.error("Unhandled exception in protocol " + this.getProtoName() + " (" + this.getProtoId() + ") " + e, (Throwable)e);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void handleMessageIn(MessageInEvent m4) {
        BabelMessage msg = m4.getMsg();
        MessageInHandler h2 = (MessageInHandler)this.getChannelOrThrow(m4.getChannelId()).messageInHandlers.get(msg.getMessage().getId());
        if (h2 != null) {
            h2.receive(msg.getMessage(), m4.getFrom(), msg.getSourceProto(), m4.getChannelId());
        } else {
            logger.warn("Discarding unexpected message (id " + msg.getMessage().getId() + "): " + m4);
        }
    }

    private void handleMessageFailed(MessageFailedEvent e) {
        BabelMessage msg = e.getMsg();
        MessageFailedHandler h2 = (MessageFailedHandler)this.getChannelOrThrow(e.getChannelId()).messageFailedHandlers.get(msg.getMessage().getId());
        if (h2 != null) {
            h2.onMessageFailed(msg.getMessage(), e.getTo(), msg.getDestProto(), e.getCause(), e.getChannelId());
        } else if (logger.isDebugEnabled()) {
            logger.debug("Discarding unhandled message failed event " + e);
        }
    }

    private void handleMessageSent(MessageSentEvent e) {
        BabelMessage msg = e.getMsg();
        MessageSentHandler h2 = (MessageSentHandler)this.getChannelOrThrow(e.getChannelId()).messageSentHandlers.get(msg.getMessage().getId());
        if (h2 != null) {
            h2.onMessageSent(msg.getMessage(), e.getTo(), msg.getDestProto(), e.getChannelId());
        }
    }

    private void handleChannelEvent(CustomChannelEvent m4) {
        ChannelEventHandler h2 = (ChannelEventHandler)this.getChannelOrThrow(m4.getChannelId()).channelEventHandlers.get(m4.getEvent().getId());
        if (h2 != null) {
            h2.handleEvent(m4.getEvent(), m4.getChannelId());
        } else if (logger.isDebugEnabled()) {
            logger.debug("Discarding unhandled channel event (id " + m4.getChannelId() + "): " + m4);
        }
    }

    private void handleTimer(TimerEvent t2) {
        TimerHandler<? extends ProtoTimer> h2 = this.timerHandlers.get(t2.getTimer().getId());
        if (h2 != null) {
            h2.uponTimer(t2.getTimer().clone(), t2.getUuid());
        } else {
            logger.warn("Discarding unexpected timer (id " + t2.getTimer().getId() + "): " + t2);
        }
    }

    private void handleNotification(NotificationEvent n) {
        NotificationHandler<? extends ProtoNotification> h2 = this.notificationHandlers.get(n.getNotification().getId());
        if (h2 != null) {
            h2.uponNotification(n.getNotification(), n.getEmitterID());
        } else {
            logger.warn("Discarding unexpected notification (id " + n.getNotification().getId() + "): " + n);
        }
    }

    private void handleRequest(ProtoRequest r, short from) {
        RequestHandler<? extends ProtoRequest> h2 = this.requestHandlers.get(r.getId());
        if (h2 != null) {
            h2.uponRequest(r, from);
        } else {
            logger.warn("Discarding unexpected request (id " + r.getId() + "): " + r);
        }
    }

    private void handleReply(ProtoReply r, short from) {
        ReplyHandler<? extends ProtoReply> h2 = this.replyHandlers.get(r.getId());
        if (h2 != null) {
            h2.uponReply(r, from);
        } else {
            logger.warn("Discarding unexpected reply (id " + r.getId() + "): " + r);
        }
    }

    public static class ProtocolMetrics {
        private long totalEventsCount;
        private long messagesInCount;
        private long messagesFailedCount;
        private long messagesSentCount;
        private long timersCount;
        private long notificationsCount;
        private long requestsCount;
        private long repliesCount;
        private long customChannelEventsCount;

        public String toString() {
            return "ProtocolMetrics{totalEvents=" + this.totalEventsCount + ", messagesIn=" + this.messagesInCount + ", messagesFailed=" + this.messagesFailedCount + ", messagesSent=" + this.messagesSentCount + ", timers=" + this.timersCount + ", notifications=" + this.notificationsCount + ", requests=" + this.requestsCount + ", replies=" + this.repliesCount + ", customChannelEvents=" + this.customChannelEventsCount + '}';
        }

        public void reset() {
            this.customChannelEventsCount = 0L;
            this.requestsCount = 0L;
            this.repliesCount = 0L;
            this.notificationsCount = 0L;
            this.timersCount = 0L;
            this.messagesSentCount = 0L;
            this.messagesInCount = 0L;
            this.messagesFailedCount = 0L;
            this.totalEventsCount = 0L;
        }

        public long getCustomChannelEventsCount() {
            return this.customChannelEventsCount;
        }

        public long getMessagesFailedCount() {
            return this.messagesFailedCount;
        }

        public long getMessagesInCount() {
            return this.messagesInCount;
        }

        public long getMessagesSentCount() {
            return this.messagesSentCount;
        }

        public long getNotificationsCount() {
            return this.notificationsCount;
        }

        public long getRepliesCount() {
            return this.repliesCount;
        }

        public long getRequestsCount() {
            return this.requestsCount;
        }

        public long getTimersCount() {
            return this.timersCount;
        }

        public long getTotalEventsCount() {
            return this.totalEventsCount;
        }
    }

    private static class ChannelHandlers {
        private final Map<Short, MessageInHandler<? extends ProtoMessage>> messageInHandlers = new HashMap<Short, MessageInHandler<? extends ProtoMessage>>();
        private final Map<Short, MessageSentHandler<? extends ProtoMessage>> messageSentHandlers = new HashMap<Short, MessageSentHandler<? extends ProtoMessage>>();
        private final Map<Short, MessageFailedHandler<? extends ProtoMessage>> messageFailedHandlers = new HashMap<Short, MessageFailedHandler<? extends ProtoMessage>>();
        private final Map<Short, ChannelEventHandler<? extends ChannelEvent>> channelEventHandlers = new HashMap<Short, ChannelEventHandler<? extends ChannelEvent>>();
    }
}

