/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.internal;

import java.util.Comparator;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.generic.ProtoTimer;
import pt.unl.fct.di.novasys.babel.internal.InternalEvent;

public class TimerEvent
extends InternalEvent
implements Comparable<TimerEvent>,
Comparator<TimerEvent> {
    private final long uuid;
    private final ProtoTimer timer;
    private final GenericProtocol consumer;
    private final boolean periodic;
    private final long period;
    private long triggerTime;

    public TimerEvent(ProtoTimer timer, long uuid, GenericProtocol consumer, long triggerTime, boolean periodic, long period) {
        super(InternalEvent.EventType.TIMER_EVENT);
        this.timer = timer;
        this.uuid = uuid;
        this.consumer = consumer;
        this.triggerTime = triggerTime;
        this.period = period;
        this.periodic = periodic;
    }

    public ProtoTimer getTimer() {
        return this.timer;
    }

    public String toString() {
        return "TimerEvent{uuid=" + this.uuid + ", timer=" + this.timer + ", consumer=" + this.consumer + ", triggerTime=" + this.triggerTime + ", periodic=" + this.periodic + ", period=" + this.period + '}';
    }

    public long getUuid() {
        return this.uuid;
    }

    public long getPeriod() {
        return this.period;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public long getTriggerTime() {
        return this.triggerTime;
    }

    public GenericProtocol getConsumer() {
        return this.consumer;
    }

    public void setTriggerTime(long triggerTime) {
        this.triggerTime = triggerTime;
    }

    @Override
    public int compareTo(TimerEvent o) {
        return Long.compare(this.triggerTime, o.triggerTime);
    }

    @Override
    public int compare(TimerEvent o1, TimerEvent o2) {
        return Long.compare(o1.triggerTime, o2.triggerTime);
    }
}

