/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.antientropy.messages;

import com.google.common.hash.BloomFilter;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class AntiEntrophyAnnounce
extends ProtoMessage {
    public static final short MSG_CODE = 901;
    private final Host sender;
    private final int setSize;
    private final BloomFilter<String> receivedMessages;
    private static final Logger logger = LogManager.getLogger(AntiEntrophyAnnounce.class);
    public static final ISerializer<AntiEntrophyAnnounce> serializer = new ISerializer<AntiEntrophyAnnounce>(){

        @Override
        public void serialize(AntiEntrophyAnnounce t2, ByteBuf out) throws IOException {
            Host.serializer.serialize(t2.getSender(), out);
            out.writeInt(t2.setSize);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(byteArrayOutputStream);
            output.writeObject(t2.receivedMessages);
            byte[] representation = byteArrayOutputStream.toByteArray();
            logger.debug("Serialized bloom filter to a " + representation.length + "bytes (numebr of elementes is: " + t2.getSetSize() + ") ");
            output.close();
            out.writeInt(representation.length);
            out.writeBytes(representation);
        }

        @Override
        public AntiEntrophyAnnounce deserialize(ByteBuf in) throws IOException {
            Host h2 = Host.serializer.deserialize(in);
            int setSize = in.readInt();
            byte[] representation = new byte[in.readInt()];
            in.readBytes(representation);
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(representation));
            BloomFilter filter = null;
            try {
                filter = (BloomFilter)input.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
            }
            return new AntiEntrophyAnnounce(h2, filter, setSize);
        }
    };

    public AntiEntrophyAnnounce(Host sender, BloomFilter<String> bf, int setSize) {
        super((short)901);
        this.sender = sender;
        this.receivedMessages = bf;
        this.setSize = setSize;
    }

    public Host getSender() {
        return this.sender;
    }

    public int getSetSize() {
        return this.setSize;
    }

    public boolean contains(String id) {
        return this.receivedMessages.mightContain(id);
    }

    public String toString() {
        return "AntiEntropyAnnounce{sender=" + this.sender + ", setSize=" + this.setSize + ", receivedMessages=" + this.receivedMessages.toString() + '}';
    }
}

