/*
 * Decompiled with CFR 0.152.
 */
package tardis.app;

import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.notifications.BroadcastDelivery;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.requests.BroadcastRequest;
import pt.unl.fct.di.novasys.network.data.Host;
import tardis.app.data.UserMessage;
import tardis.app.timers.AppWorkloadGenerateTimer;

public class DataDisseminationApp
extends GenericProtocol {
    public static final String PROTO_NAME = "TaRDIS Simple App";
    public static final short PROTO_ID = 9999;
    public static final String PAR_GENERATE_WORKLOAD = "app.automatic";
    private boolean generateWorkload;
    public static final String PAR_WORKLOAD_PERIOD = "app.workload.period";
    public static final String PAR_WOKRLOAD_SIZE = "app.workload.payload";
    public static final long DEFAULT_WORKLOAD_PERIOD = 10000L;
    public static final int DEFAULT_WORKLOAD_SIZE = 63000;
    public static final String PAR_BCAST_PROTOCOL_ID = "app.bcast.id";
    public static final String PAR_BCAST_INIT_ENABLED = "app.bcast.enable";
    public static final boolean DEFAULT_BCAST_INIT_ENABLED = true;
    private long workloadPeriod;
    private int payloadSize;
    private short bcastProtoID;
    private final Host myself;
    private Logger logger = LogManager.getLogger(DataDisseminationApp.class);
    private AtomicBoolean executing;

    public DataDisseminationApp(Host myself) throws HandlerRegistrationException {
        super(PROTO_NAME, (short)9999);
        this.myself = myself;
        this.registerTimerHandler((short)9999, this::handleAppWorkloadGenerateTimer);
        this.subscribeNotification((short)501, this::handleDMessageDeliveryEvent);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        if (props.containsKey(PAR_BCAST_PROTOCOL_ID)) {
            this.bcastProtoID = Short.parseShort(props.getProperty(PAR_BCAST_PROTOCOL_ID));
            this.logger.debug("DataDisseminationApp is configured to used broadcast protocol with id: " + this.bcastProtoID);
        } else {
            this.logger.error("The applicaiton requires the id of the broadcast protocol being used. Parameter: 'app.bcast.id'");
            System.exit(1);
        }
        this.generateWorkload = props.containsKey(PAR_GENERATE_WORKLOAD);
        if (this.generateWorkload) {
            this.workloadPeriod = props.containsKey(PAR_WORKLOAD_PERIOD) ? Long.parseLong(props.getProperty(PAR_WORKLOAD_PERIOD)) : 10000L;
            this.payloadSize = props.containsKey(PAR_WOKRLOAD_SIZE) ? Integer.parseInt(PAR_WOKRLOAD_SIZE) : 63000;
            this.setupPeriodicTimer(new AppWorkloadGenerateTimer(), this.workloadPeriod, this.workloadPeriod);
            this.logger.debug("DataDisseminationApp has workload generation enabled.");
        } else {
            this.logger.debug("DataDisseminationApp has workload generation disabled.");
        }
        boolean b = true;
        if (props.containsKey(PAR_BCAST_INIT_ENABLED)) {
            b = Boolean.parseBoolean(props.getProperty(PAR_BCAST_INIT_ENABLED));
        }
        this.executing = new AtomicBoolean(b);
    }

    private void handleAppWorkloadGenerateTimer(AppWorkloadGenerateTimer t2, long time) {
        if (!this.executing.getAcquire()) {
            return;
        }
        this.logger.debug("DataDisseminationApp generating workload.");
        String payload = DataDisseminationApp.randomCapitalLetters(this.payloadSize);
        UserMessage message = new UserMessage(this.myself.toString(), this.myself.getAddress().getHostName() + "-bot", payload);
        byte[] data = null;
        try {
            data = message.toByteArray();
        }
        catch (Exception e) {
            this.logger.error("Failed to serialize UserMessage, falling back to String", (Throwable)e);
            data = payload.getBytes();
            message = null;
        }
        BroadcastRequest request = new BroadcastRequest(this.myself, data, 9999);
        this.sendRequest(request, this.bcastProtoID);
        if (message == null) {
            this.logger.info(String.valueOf(this.myself) + " sent message: [" + String.valueOf(this.myself) + "::::" + DataDisseminationApp.readableOutput(payload) + "]");
        } else if (message.hasAttachment()) {
            this.logger.info(String.valueOf(this.myself) + " sent message: [" + String.valueOf(this.myself) + "::::" + DataDisseminationApp.readableOutput(message.getMessage(), message.getAttachmentName()) + "]");
        } else {
            this.logger.info(String.valueOf(this.myself) + " sent message: [" + String.valueOf(this.myself) + "::::" + DataDisseminationApp.readableOutput(message.getMessage()) + "]");
        }
    }

    private void handleDMessageDeliveryEvent(BroadcastDelivery msg, short proto) {
        String payload = null;
        UserMessage um = null;
        try {
            um = UserMessage.fromByteArray(msg.getPayload());
        }
        catch (Exception e) {
            this.logger.error("Failed to deserialize UserMessage, falling back to String", (Throwable)e);
            payload = new String(msg.getPayload());
        }
        if (um == null) {
            this.logger.info(String.valueOf(this.myself) + " recv message: [" + String.valueOf(msg.getSender()) + "::::" + DataDisseminationApp.readableOutput(payload) + "]");
        } else if (um.hasAttachment()) {
            this.logger.info(String.valueOf(this.myself) + " recv message: [" + String.valueOf(msg.getSender()) + "::::" + DataDisseminationApp.readableOutput(um.getMessage(), um.getAttachmentName()) + "]");
        } else {
            this.logger.info(String.valueOf(this.myself) + " recv message: [" + String.valueOf(msg.getSender()) + "::::" + DataDisseminationApp.readableOutput(um.getMessage()) + "]");
        }
    }

    public static String randomCapitalLetters(int length) {
        int leftLimit = 65;
        int rightLimit = 90;
        Random random = new Random();
        return random.ints(leftLimit, rightLimit + 1).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static String readableOutput(String msg, String attachName) {
        return Hashing.sha256().hashString(msg + "::" + attachName, StandardCharsets.UTF_8).toString();
    }

    public static String readableOutput(String msg) {
        if (msg.length() > 32) {
            return Hashing.sha256().hashString(msg, StandardCharsets.UTF_8).toString();
        }
        return msg;
    }

    public void disableTransmissions() {
        this.executing.set(false);
    }

    public boolean isTransmitting() {
        return this.executing.get();
    }

    public void enableTransmission() {
        this.executing.set(true);
    }
}

