/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.type.DefaultUserDefinedType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class UserDefinedTypeBuilder {
    private final CqlIdentifier keyspaceName;
    private final CqlIdentifier typeName;
    private boolean frozen;
    private final ImmutableList.Builder<CqlIdentifier> fieldNames;
    private final ImmutableList.Builder<DataType> fieldTypes;

    public UserDefinedTypeBuilder(CqlIdentifier keyspaceName, CqlIdentifier typeName) {
        this.keyspaceName = keyspaceName;
        this.typeName = typeName;
        this.fieldNames = ImmutableList.builder();
        this.fieldTypes = ImmutableList.builder();
    }

    public UserDefinedTypeBuilder(String keyspaceName, String typeName) {
        this(CqlIdentifier.fromCql(keyspaceName), CqlIdentifier.fromCql(typeName));
    }

    public UserDefinedTypeBuilder withField(CqlIdentifier name, DataType type) {
        this.fieldNames.add((Object)name);
        this.fieldTypes.add((Object)type);
        return this;
    }

    public UserDefinedTypeBuilder withField(String name, DataType type) {
        return this.withField(CqlIdentifier.fromCql(name), type);
    }

    public UserDefinedTypeBuilder frozen() {
        this.frozen = true;
        return this;
    }

    public UserDefinedType build() {
        return new DefaultUserDefinedType(this.keyspaceName, this.typeName, this.frozen, (List<CqlIdentifier>)((Object)this.fieldNames.build()), (List<DataType>)((Object)this.fieldTypes.build()));
    }
}

