/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ListCodec<ElementT>
implements TypeCodec<List<ElementT>> {
    private final DataType cqlType;
    private final GenericType<List<ElementT>> javaType;
    private final TypeCodec<ElementT> elementCodec;

    public ListCodec(DataType cqlType, TypeCodec<ElementT> elementCodec) {
        this.cqlType = cqlType;
        this.javaType = GenericType.listOf(elementCodec.getJavaType());
        this.elementCodec = elementCodec;
        Preconditions.checkArgument(cqlType instanceof ListType);
    }

    @Override
    @NonNull
    public GenericType<List<ElementT>> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        if (List.class.isAssignableFrom(value.getClass())) {
            List list = (List)value;
            return list.isEmpty() || this.elementCodec.accepts(list.get(0));
        }
        return false;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable List<ElementT> value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        int i = 0;
        ByteBuffer[] encodedElements = new ByteBuffer[value.size()];
        int toAllocate = 4;
        for (ElementT element : value) {
            ByteBuffer encodedElement;
            if (element == null) {
                throw new NullPointerException("Collection elements cannot be null");
            }
            try {
                encodedElement = this.elementCodec.encode(element, protocolVersion);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid type for element: " + element.getClass());
            }
            if (encodedElement == null) {
                throw new NullPointerException("Collection elements cannot encode to CQL NULL");
            }
            encodedElements[i++] = encodedElement;
            toAllocate += 4 + encodedElement.remaining();
        }
        ByteBuffer result = ByteBuffer.allocate(toAllocate);
        result.putInt(value.size());
        for (ByteBuffer encodedElement : encodedElements) {
            result.putInt(encodedElement.remaining());
            result.put(encodedElement);
        }
        result.flip();
        return result;
    }

    @Override
    @Nullable
    public List<ElementT> decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return new ArrayList(0);
        }
        ByteBuffer input = bytes.duplicate();
        int size = input.getInt();
        ArrayList<ElementT> result = new ArrayList<ElementT>(size);
        for (int i = 0; i < size; ++i) {
            int elementSize = input.getInt();
            ByteBuffer encodedElement = input.slice();
            encodedElement.limit(elementSize);
            input.position(input.position() + elementSize);
            result.add(this.elementCodec.decode(encodedElement, protocolVersion));
        }
        return result;
    }

    @Override
    @NonNull
    public String format(@Nullable List<ElementT> value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (ElementT t2 : value) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(this.elementCodec.format(t2));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    @Nullable
    public List<ElementT> parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        int idx = ParseUtils.skipSpaces(value, 0);
        if (value.charAt(idx++) != '[') {
            throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", at character %d expecting '[' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
        }
        if (value.charAt(idx = ParseUtils.skipSpaces(value, idx)) == ']') {
            return new ArrayList(0);
        }
        ArrayList<ElementT> list = new ArrayList<ElementT>();
        while (idx < value.length()) {
            int n;
            try {
                n = ParseUtils.skipCQLValue(value, idx);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", invalid CQL value at character %d", value, idx), e);
            }
            list.add(this.elementCodec.parse(value.substring(idx, n)));
            idx = n;
            idx = ParseUtils.skipSpaces(value, idx);
            if (value.charAt(idx) == ']') {
                return list;
            }
            if (value.charAt(idx++) != ',') {
                throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", at character %d expecting ',' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
            }
            idx = ParseUtils.skipSpaces(value, idx);
        }
        throw new IllegalArgumentException(String.format("Malformed list value \"%s\", missing closing ']'", value));
    }
}

