/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.internal.core.util.concurrent.CycleDetector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class LazyReference<T> {
    private final String name;
    private final Supplier<T> supplier;
    private final CycleDetector checker;
    private volatile T value;
    private ReentrantLock lock = new ReentrantLock();

    public LazyReference(String name, Supplier<T> supplier, CycleDetector cycleDetector) {
        this.name = name;
        this.supplier = supplier;
        this.checker = cycleDetector;
    }

    public LazyReference(Supplier<T> supplier) {
        this(null, supplier, null);
    }

    public T get() {
        T t2 = this.value;
        if (t2 == null) {
            if (this.checker != null) {
                this.checker.onTryLock(this);
            }
            this.lock.lock();
            try {
                if (this.checker != null) {
                    this.checker.onLockAcquired(this);
                }
                if ((t2 = this.value) == null) {
                    this.value = t2 = this.supplier.get();
                }
            }
            finally {
                if (this.checker != null) {
                    this.checker.onReleaseLock(this);
                }
                this.lock.unlock();
            }
        }
        return t2;
    }

    public String getName() {
        return this.name;
    }
}

