/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableDoubleProperty
extends DoublePropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin = null;
    private TransitionMediatorImpl mediator = null;

    public StyleableDoubleProperty() {
    }

    public StyleableDoubleProperty(double d) {
        super(d);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        double d;
        TransitionDefinition transitionDefinition;
        Object object;
        if (this.origin != null && (object = this.getBean()) instanceof Node) {
            Node node = (Node)object;
            transitionDefinition = NodeHelper.findTransitionDefinition(node, this.getCssMetaData());
        } else {
            transitionDefinition = null;
        }
        TransitionDefinition transitionDefinition2 = transitionDefinition;
        double d2 = d = number != null ? number.doubleValue() : 0.0;
        if (transitionDefinition2 == null) {
            this.set(d);
        } else if (this.mediator == null || this.mediator.newValue != d) {
            this.mediator = new TransitionMediatorImpl(this.get(), d);
            this.mediator.run(transitionDefinition2);
        }
        this.origin = styleOrigin;
    }

    @Override
    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel(true);
        }
    }

    @Override
    public void set(double d) {
        super.set(d);
        if (this.mediator == null || this.mediator.cancel(false)) {
            this.origin = StyleOrigin.USER;
        }
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private class TransitionMediatorImpl
    extends TransitionMediator {
        private final double oldValue;
        private final double newValue;

        public TransitionMediatorImpl(double d, double d2) {
            this.oldValue = d;
            this.newValue = d2;
        }

        @Override
        public void onUpdate(double d) {
            StyleableDoubleProperty.this.set(d < 1.0 ? this.oldValue + (this.newValue - this.oldValue) * d : this.newValue);
        }

        @Override
        public void onStop() {
            if (StyleableDoubleProperty.this.mediator == this) {
                StyleableDoubleProperty.this.mediator = null;
            }
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableDoubleProperty.this;
        }
    }
}

