/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.SelfConfigurableProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.requests.FoundServiceReply;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.Parameter;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.SelfConfigurationProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.messages.ParameterMessage;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.timers.SearchTimer;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.utils.NetworkingUtilities;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.data.Host;

public class CopySelfConfigurationProtocol
extends SelfConfigurationProtocol {
    private static final Logger logger = LogManager.getLogger(CopySelfConfigurationProtocol.class);
    public static final String DEFAULT_PORT = "19349";
    public static final short PROTO_ID = 32000;
    public static final String PROTO_NAME = "BabelCopySelfConfiguration";
    public static final int SEARCH_COOLDOWN = 5000;
    public static final int CONFIRMATION_TIMEOUT = 30000;
    protected final Map<String, Map<String, MutableTriple<Parameter, CountDownLatch, Pair<Map<String, Integer>, Set<Host>>>>> protocolToParameterToConfigure = new ConcurrentHashMap<String, Map<String, MutableTriple<Parameter, CountDownLatch, Pair<Map<String, Integer>, Set<Host>>>>>();
    protected final Map<String, Map<String, Parameter>> protocolToParameterConfigured = new ConcurrentHashMap<String, Map<String, Parameter>>();
    protected final Map<String, SelfConfigurableProtocol> protocolMap = new ConcurrentHashMap<String, SelfConfigurableProtocol>();
    protected final Map<Host, ParameterMessage> msgToSend = new HashMap<Host, ParameterMessage>();
    protected final Map<String, Set<Host>> whisperers = new ConcurrentHashMap<String, Set<Host>>();
    private Host myself;
    private int defaultChannelID;
    private int confirmationsNeeded = 1;

    public CopySelfConfigurationProtocol() {
        super(PROTO_NAME, (short)32000);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        String networkInterface = props.getProperty("BabelWhisperer.Unicast.Interface");
        String address = null;
        if (networkInterface == null) {
            address = props.getProperty("BabelWhisperer.Unicast.Address");
            if (address == null) {
                address = NetworkingUtilities.getAddress("eth0");
            }
        } else {
            address = NetworkingUtilities.getAddress(networkInterface);
        }
        String port = props.getProperty("BabelWhisperer.Unicast.Port", DEFAULT_PORT);
        String confirmations = props.getProperty("BabelWhisperer.Confirmations");
        if (confirmations != null) {
            this.confirmationsNeeded = Integer.valueOf(confirmations);
        }
        Properties channelProps = new Properties(2);
        channelProps.setProperty("address", address);
        channelProps.setProperty("port", port);
        this.defaultChannelID = this.createChannel("TCPChannel", channelProps);
        this.myself = new Host(InetAddress.getByName(address), Integer.valueOf(port));
        this.registerChannelEventHandler(this.defaultChannelID, (short)1, this::uponInConnectionDown);
        this.registerChannelEventHandler(this.defaultChannelID, (short)2, this::uponInConnectionUp);
        this.registerChannelEventHandler(this.defaultChannelID, (short)3, this::uponOutConnectionDown);
        this.registerChannelEventHandler(this.defaultChannelID, (short)5, this::uponOutConnectionUp);
        this.registerChannelEventHandler(this.defaultChannelID, (short)4, this::uponOutConnectionFailed);
        this.registerMessageSerializer(this.defaultChannelID, (short)10604, ParameterMessage.serializer);
        this.registerMessageHandler(this.defaultChannelID, (short)10604, this::uponParameterMessage, this::uponMessageFailed);
        this.registerTimerHandler((short)341, this::search);
        this.setupPeriodicTimer(new SearchTimer(), 5000L, 5000L);
        this.registerReplyHandler((short)32302, this::uponFoundServiceReply);
    }

    @Override
    public void addProtocolParameterToConfigure(String parameterName, Method setter, Method getter, SelfConfigurableProtocol proto) {
        if (this.protocolToParameterToConfigure.isEmpty()) {
            babel.askRunningDiscovery(this, this.myself, true);
        }
        Parameter parameter = new Parameter(getter, setter, proto);
        Map<String, MutableTriple<Parameter, CountDownLatch, Pair<Map<String, Integer>, Set<Host>>>> protocolParameters = this.protocolToParameterToConfigure.get(proto.getProtoName());
        if (protocolParameters == null) {
            protocolParameters = new ConcurrentHashMap<String, MutableTriple<Parameter, CountDownLatch, Pair<Map<String, Integer>, Set<Host>>>>();
            this.protocolToParameterToConfigure.put(proto.getProtoName(), protocolParameters);
        }
        protocolParameters.put(parameterName, new MutableTriple(parameter, null, new ImmutablePair(new HashMap(), new HashSet())));
        this.protocolMap.put(proto.getProtoName(), proto);
    }

    @Override
    public void addProtocolParameterConfigured(String parameterName, Method setter, Method getter, SelfConfigurableProtocol proto) {
        Parameter parameter = new Parameter(getter, setter, proto);
        Map<String, Parameter> protocolParameter = this.protocolToParameterConfigured.get(proto.getProtoName());
        if (protocolParameter == null) {
            protocolParameter = new ConcurrentHashMap<String, Parameter>();
            this.protocolToParameterConfigured.put(proto.getProtoName(), protocolParameter);
        }
        protocolParameter.put(parameterName, parameter);
        this.protocolMap.put(proto.getProtoName(), proto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(SearchTimer timer, long timerId) {
        logger.info("Trying to search");
        for (Map.Entry<String, Map<String, MutableTriple<Parameter, CountDownLatch, Pair<Map<String, Integer>, Set<Host>>>>> protoEntry : this.protocolToParameterToConfigure.entrySet()) {
            Set<Host> protoHost = this.whisperers.get("*");
            Map<Host, ParameterMessage> map = this.msgToSend;
            synchronized (map) {
                for (Host host : protoHost) {
                    ParameterMessage msg = this.msgToSend.get(host);
                    if (msg == null) {
                        msg = new ParameterMessage();
                        this.msgToSend.put(host, msg);
                        logger.info("Opening connection to " + String.valueOf(protoHost));
                        this.openConnection(host, this.defaultChannelID);
                    }
                    for (Map.Entry<String, MutableTriple<Parameter, CountDownLatch, Pair<Map<String, Integer>, Set<Host>>>> paramEntry : protoEntry.getValue().entrySet()) {
                        msg.addAskingParameter(protoEntry.getKey(), paramEntry.getKey());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countdownParameter(SelfConfigurableProtocol proto, Triple<Parameter, CountDownLatch, Pair<Map<String, Integer>, Set<Host>>> paramToConfigure) {
        try {
            paramToConfigure.getMiddle().await(30000L, TimeUnit.MILLISECONDS);
            String confirmedValue = paramToConfigure.getRight().getLeft().entrySet().stream().max(new Comparator<Map.Entry<String, Integer>>(this){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    int compare = o1.getValue().compareTo(o2.getValue());
                    if (compare == 0) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                    return compare;
                }
            }).get().getKey();
            paramToConfigure.getLeft().setter().invoke((Object)proto, confirmedValue);
            SelfConfigurableProtocol selfConfigurableProtocol = proto;
            synchronized (selfConfigurableProtocol) {
                if (proto.readyToStart()) {
                    babel.setupSelfConfiguration(proto);
                    this.protocolToParameterToConfigure.remove(proto.getProtoName());
                    if (this.protocolToParameterToConfigure.isEmpty()) {
                        babel.askRunningDiscovery(this, this.myself, false);
                    }
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Protocol badly constructed");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for confirmation for " + paramToConfigure.getLeft().getter().getName());
        }
    }

    private void addFoundConfiguration(String config, Triple<Parameter, CountDownLatch, Pair<Map<String, Integer>, Set<Host>>> paramToConfigure, Host from) {
        if (paramToConfigure.getRight().getRight().add(from)) {
            Map<String, Integer> possibilities;
            Integer confirmations = (possibilities = paramToConfigure.getRight().getLeft()).get(config);
            possibilities.put(config, confirmations == null ? 1 : confirmations + 1);
            paramToConfigure.getMiddle().countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uponParameterMessage(ParameterMessage msg, Host from, short sourceProto, int channelId) {
        logger.info("Got parameter message from " + String.valueOf(from));
        Map<String, Map<String, String>> receivedParams = msg.getAllProtocolParams();
        ParameterMessage replyMsg = new ParameterMessage();
        for (Map.Entry<String, Map<String, String>> protoEntry : receivedParams.entrySet()) {
            SelfConfigurableProtocol proto = this.protocolMap.get(protoEntry.getKey());
            Map<String, MutableTriple<Parameter, CountDownLatch, Pair<Map<String, Integer>, Set<Host>>>> thisProtocolToConfigure = this.protocolToParameterToConfigure.get(protoEntry.getKey());
            Map<String, Parameter> thisProtocolConfigured = this.protocolToParameterConfigured.get(protoEntry.getKey());
            for (Map.Entry<String, String> paramEntry : protoEntry.getValue().entrySet()) {
                Parameter paramConfigured;
                MutableTriple<Parameter, CountDownLatch, Pair<Map<String, Integer>, Set<Host>>> paramToConfigure = thisProtocolToConfigure != null ? thisProtocolToConfigure.get(paramEntry.getKey()) : null;
                Parameter parameter = paramConfigured = thisProtocolConfigured != null ? thisProtocolConfigured.get(paramEntry.getKey()) : null;
                if (paramEntry.getValue() != null && paramToConfigure != null) {
                    if (paramToConfigure.getMiddle() == null) {
                        paramToConfigure.setMiddle(new CountDownLatch(this.confirmationsNeeded));
                        new Thread(() -> this.countdownParameter(proto, paramToConfigure)).start();
                    }
                    this.addFoundConfiguration(paramEntry.getValue(), paramToConfigure, from);
                    continue;
                }
                if (paramEntry.getValue() != null || paramConfigured == null) continue;
                try {
                    String value = (String)paramConfigured.getter().invoke((Object)proto, new Object[0]);
                    replyMsg.addParameter(protoEntry.getKey(), paramEntry.getKey(), value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Protocol badly constructed");
                }
            }
        }
        Map<Host, ParameterMessage> map = this.msgToSend;
        synchronized (map) {
            ParameterMessage oldMsg = this.msgToSend.get(from);
            if (oldMsg != null) {
                oldMsg.join(replyMsg);
            } else {
                this.msgToSend.put(from, replyMsg);
            }
            if (oldMsg != null && oldMsg.getAllProtocolParams().size() > 0 || replyMsg.getAllProtocolParams().size() > 0) {
                this.openConnection(from);
            }
        }
    }

    private void uponMessageFailed(ProtoMessage msg, Host host, short destProto, Throwable error, int channelId) {
        logger.warn("Failed message: {} to host: {} with error: {}", (Object)msg, (Object)host, (Object)error.getMessage());
    }

    private void uponInConnectionUp(InConnectionUp event, int channel) {
        logger.debug(event);
    }

    private void uponInConnectionDown(InConnectionDown event, int channel) {
        logger.info(event);
    }

    private void uponOutConnectionDown(OutConnectionDown event, int channel) {
        logger.warn(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uponOutConnectionUp(OutConnectionUp event, int channel) {
        logger.info("Connection to {} is now up", (Object)event.getNode());
        Map<Host, ParameterMessage> map = this.msgToSend;
        synchronized (map) {
            this.sendMessage(this.msgToSend.remove(event.getNode()), event.getNode());
            this.closeConnection(event.getNode(), this.defaultChannelID);
        }
    }

    private void uponOutConnectionFailed(OutConnectionFailed<ProtoMessage> event, int channel) {
        logger.debug(event);
    }

    private void uponFoundServiceReply(FoundServiceReply reply, short sourceProto) {
        Set<Host> serviceWhisperers = this.whisperers.get("*");
        if (serviceWhisperers == null) {
            serviceWhisperers = ConcurrentHashMap.newKeySet();
            this.whisperers.put("*", serviceWhisperers);
        }
        serviceWhisperers.add(reply.getServiceHost());
    }

    @Override
    public Host getMyself() {
        return this.myself;
    }
}

