/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.util.OptionalDouble;
import java.util.concurrent.ConcurrentLinkedQueue;
import pt.unl.fct.di.novasys.babel.metrics.Metric;

public class Reducer
extends Metric {
    private final ConcurrentLinkedQueue<Double> collection;
    private final Operation op;

    public Reducer(String name, boolean logPeriodically, long period, boolean resetOnLog, Operation op) {
        super(name, logPeriodically, period, false, resetOnLog);
        this.op = op;
        this.collection = new ConcurrentLinkedQueue();
    }

    public synchronized void add(Double val) {
        this.collection.add(val);
    }

    @Override
    protected synchronized void reset() {
        this.collection.clear();
    }

    @Override
    protected synchronized String computeValue() {
        int nEntries = this.collection.size();
        return (switch (this.op.ordinal()) {
            case 0 -> {
                OptionalDouble val = this.collection.stream().mapToDouble(i -> i).average();
                yield val.isPresent() ? String.valueOf(val.getAsDouble()) : "null";
            }
            case 1 -> {
                OptionalDouble maxVal = this.collection.stream().mapToDouble(i -> i).max();
                yield maxVal.isPresent() ? String.valueOf(maxVal.getAsDouble()) : "null";
            }
            case 2 -> {
                OptionalDouble minVal = this.collection.stream().mapToDouble(i -> i).min();
                yield minVal.isPresent() ? String.valueOf(minVal.getAsDouble()) : "null";
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.op));
        }) + " " + nEntries;
    }

    public static enum Operation {
        AVG,
        MAX,
        MIN;

    }
}

