/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.listeners.InConnListener;
import pt.unl.fct.di.novasys.network.listeners.MessageListener;
import pt.unl.fct.di.novasys.network.listeners.OutConnListener;
import pt.unl.fct.di.novasys.network.pipeline.InConnectionHandler;
import pt.unl.fct.di.novasys.network.pipeline.InHandshakeHandler;
import pt.unl.fct.di.novasys.network.pipeline.MessageDecoder;
import pt.unl.fct.di.novasys.network.pipeline.MessageEncoder;
import pt.unl.fct.di.novasys.network.pipeline.OutConnectionHandler;

public class NetworkManager<T> {
    private static final Logger logger = LogManager.getLogger(NetworkManager.class);
    private final Bootstrap clientBootstrap;
    private final EventLoopGroup workerGroup;
    private Channel serverChannel;
    private final ISerializer<T> serializer;
    private final MessageListener<T> consumer;
    private final int hbInterval;
    private final int hbTolerance;
    static final Class<? extends Channel> channelClass;
    static final Class<? extends ServerChannel> serverChannelClass;

    public NetworkManager(ISerializer<T> serializer, MessageListener<T> consumer, int hbInterval, int hbTolerance, int connectTimeout) {
        this(serializer, consumer, hbInterval, hbTolerance, connectTimeout, 0);
    }

    public NetworkManager(ISerializer<T> serializer, MessageListener<T> consumer, int hbInterval, int hbTolerance, int connectTimeout, int nWorkerThreads) {
        this(serializer, consumer, hbInterval, hbTolerance, connectTimeout, NetworkManager.createNewWorkerGroup(nWorkerThreads));
    }

    public NetworkManager(ISerializer<T> serializer, MessageListener<T> consumer, int hbInterval, int hbTolerance, int connectTimeout, EventLoopGroup workerGroup) {
        this.serializer = serializer;
        this.consumer = consumer;
        this.hbInterval = hbInterval;
        this.hbTolerance = hbTolerance;
        this.workerGroup = workerGroup;
        this.clientBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(channelClass)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectTimeout);
    }

    public Connection<T> createConnection(Host peer, Attributes attrs, OutConnListener<T> listener) {
        return new OutConnectionHandler<T>(peer, this.clientBootstrap, listener, this.consumer, this.serializer, this.workerGroup.next(), attrs, this.hbInterval, this.hbTolerance);
    }

    public void createServerSocket(InConnListener<T> l, Host addr, AttributeValidator v, int childThreads) {
        this.createServerSocket(l, addr, v, childThreads, 1);
    }

    public void createServerSocket(InConnListener<T> l, Host addr, Attributes attr, AttributeValidator v, int childThreads) {
        this.createServerSocket(l, addr, attr, v, childThreads, 1);
    }

    public void createServerSocket(InConnListener<T> l, Host addr, AttributeValidator v) {
        this.createServerSocket(l, addr, v, 0, 1);
    }

    public void createServerSocket(InConnListener<T> l, Host addr, Attributes attr, AttributeValidator v) {
        this.createServerSocket(l, addr, attr, v, 0, 1);
    }

    public void createServerSocket(InConnListener<T> l, Host addr, AttributeValidator v, int childThreads, int parentThreads) {
        this.createServerSocket(l, addr, Attributes.EMPTY, v, NetworkManager.createNewWorkerGroup(childThreads), NetworkManager.createNewWorkerGroup(parentThreads));
    }

    public void createServerSocket(InConnListener<T> l, Host addr, Attributes attr, AttributeValidator v, int childThreads, int parentThreads) {
        this.createServerSocket(l, addr, attr, v, NetworkManager.createNewWorkerGroup(childThreads), NetworkManager.createNewWorkerGroup(parentThreads));
    }

    public void createServerSocket(InConnListener<T> l, Host addr, AttributeValidator v, EventLoopGroup childGroup) {
        this.createServerSocket(l, addr, Attributes.EMPTY, v, childGroup, NetworkManager.createNewWorkerGroup(1));
    }

    public void createServerSocket(InConnListener<T> l, Host addr, Attributes attr, AttributeValidator v, EventLoopGroup childGroup) {
        this.createServerSocket(l, addr, attr, v, childGroup, NetworkManager.createNewWorkerGroup(1));
    }

    public void createServerSocket(final InConnListener<T> listener, Host listenAddr, final Attributes attrs, final AttributeValidator validator, EventLoopGroup childGroup, EventLoopGroup parentGroup) {
        if (this.serverChannel != null) {
            throw new IllegalStateException("Server socket already created");
        }
        if (attrs == null) {
            throw new IllegalArgumentException("Attributes argument is NULL");
        }
        ServerBootstrap b = new ServerBootstrap();
        b.group(parentGroup, childGroup).channel(serverChannelClass);
        b.childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                MessageEncoder encoder = new MessageEncoder(NetworkManager.this.serializer);
                MessageDecoder decoder = new MessageDecoder(NetworkManager.this.serializer);
                if (NetworkManager.this.hbTolerance > 0 || NetworkManager.this.hbInterval > 0) {
                    ch.pipeline().addLast("IdleHandler", (ChannelHandler)new IdleStateHandler(NetworkManager.this.hbTolerance, NetworkManager.this.hbInterval, 0L, TimeUnit.MILLISECONDS));
                }
                ch.pipeline().addLast("MessageDecoder", decoder);
                ch.pipeline().addLast("MessageEncoder", encoder);
                ch.pipeline().addLast("InHandshakeHandler", (ChannelHandler)new InHandshakeHandler(validator, attrs));
                ch.pipeline().addLast("InCon", new InConnectionHandler(listener, NetworkManager.this.consumer, ch.eventLoop(), attrs, encoder, decoder));
            }
        });
        b.option(ChannelOption.SO_BACKLOG, 128);
        b.childOption(ChannelOption.SO_KEEPALIVE, true);
        b.childOption(ChannelOption.TCP_NODELAY, true);
        try {
            this.serverChannel = b.bind(listenAddr.getAddress(), listenAddr.getPort()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)cf -> listener.serverSocketBind(cf.isSuccess(), cf.cause()))).channel();
            this.serverChannel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)cf -> listener.serverSocketClose(cf.isSuccess(), cf.cause())));
        }
        catch (Exception e) {
            listener.serverSocketBind(false, e);
        }
    }

    public static EventLoopGroup createNewWorkerGroup(int nThreads) {
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(nThreads);
        }
        if (KQueue.isAvailable()) {
            return new KQueueEventLoopGroup(nThreads);
        }
        return new NioEventLoopGroup(nThreads);
    }

    public static EventLoopGroup createNewWorkerGroup() {
        return NetworkManager.createNewWorkerGroup(0);
    }

    static {
        if (Epoll.isAvailable()) {
            channelClass = EpollSocketChannel.class;
            serverChannelClass = EpollServerSocketChannel.class;
        } else if (KQueue.isAvailable()) {
            channelClass = KQueueSocketChannel.class;
            serverChannelClass = KQueueServerSocketChannel.class;
        } else {
            channelClass = NioSocketChannel.class;
            serverChannelClass = NioServerSocketChannel.class;
        }
    }
}

