/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.data;

import io.netty.buffer.ByteBuf;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import pt.unl.fct.di.novasys.network.ISerializer;

public class Host
implements Comparable<Host> {
    private final int port;
    private final InetAddress address;
    private final byte[] addressBytes;
    public static ISerializer<Host> serializer = new ISerializer<Host>(){

        @Override
        public void serialize(Host host, ByteBuf out) {
            out.writeBytes(host.addressBytes);
            out.writeShort(host.port);
        }

        @Override
        public Host deserialize(ByteBuf in) throws UnknownHostException {
            byte[] addrBytes = new byte[4];
            in.readBytes(addrBytes);
            int port = in.readShort() & 0xFFFF;
            return new Host(InetAddress.getByAddress(addrBytes), addrBytes, port);
        }
    };

    public Host(InetAddress address, int port) {
        this(address, address.getAddress(), port);
    }

    private Host(InetAddress address, byte[] addressBytes, int port) {
        if (!(address instanceof Inet4Address)) {
            throw new AssertionError((Object)(address + " not and IPv4 address"));
        }
        this.address = address;
        this.port = port;
        this.addressBytes = addressBytes;
        assert (addressBytes.length == 4);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.address.getHostAddress() + ":" + this.port;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Host)) {
            return false;
        }
        Host o = (Host)other;
        return o.port == this.port && o.address.equals(this.address);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.address);
    }

    @Override
    public int compareTo(Host other) {
        for (int i = 0; i < 4; ++i) {
            int cmp = Byte.compare(this.addressBytes[i], other.addressBytes[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(this.port, other.port);
    }
}

