/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.ObjectGraphNode;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.Queue;
import net.jcip.annotations.NotThreadSafe;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;

@NotThreadSafe
class GraphResultIterator
extends CountingIterator<GraphNode> {
    private final Queue<GraphNode> data;
    private final GraphProtocol graphProtocol;
    private long repeat = 0L;
    private GraphNode lastGraphNode = null;

    GraphResultIterator(Queue<GraphNode> data, GraphProtocol graphProtocol) {
        super(data.size());
        this.data = data;
        this.graphProtocol = graphProtocol;
    }

    @Override
    protected GraphNode computeNext() {
        if (this.repeat > 1L) {
            --this.repeat;
            return this.lastGraphNode;
        }
        GraphNode container = this.data.poll();
        if (container == null) {
            return (GraphNode)this.endOfData();
        }
        if (this.graphProtocol.isGraphBinary()) {
            Preconditions.checkState(container.as(Object.class) instanceof Traverser, "Graph protocol error. Received object should be a Traverser but it is not.");
            Traverser t2 = container.as(Traverser.class);
            this.repeat = t2.bulk();
            this.lastGraphNode = new ObjectGraphNode(t2.get());
            return this.lastGraphNode;
        }
        GraphNode b = container.getByKey("bulk");
        if (b != null) {
            this.repeat = b.asLong();
        }
        this.lastGraphNode = container.getByKey("result");
        return this.lastGraphNode;
    }
}

