/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.PrepareRequest;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareHandler;
import com.datastax.oss.driver.internal.core.metadata.schema.events.TypeChangeEvent;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.core.util.concurrent.RunOrSchedule;
import com.datastax.oss.driver.shaded.guava.common.base.Functions;
import com.datastax.oss.driver.shaded.guava.common.cache.Cache;
import com.datastax.oss.driver.shaded.guava.common.cache.CacheBuilder;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.util.concurrent.EventExecutor;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CqlPrepareAsyncProcessor
implements RequestProcessor<PrepareRequest, CompletionStage<PreparedStatement>> {
    private static final Logger LOG = LoggerFactory.getLogger(CqlPrepareAsyncProcessor.class);
    protected final Cache<PrepareRequest, CompletableFuture<PreparedStatement>> cache;

    public CqlPrepareAsyncProcessor() {
        this(Optional.empty());
    }

    public CqlPrepareAsyncProcessor(@NonNull Optional<? extends DefaultDriverContext> context) {
        this(context, Functions.identity());
    }

    protected CqlPrepareAsyncProcessor(Optional<? extends DefaultDriverContext> context, Function<CacheBuilder<Object, Object>, CacheBuilder<Object, Object>> decorator) {
        CacheBuilder<Object, Object> baseCache = CacheBuilder.newBuilder().weakValues();
        this.cache = decorator.apply(baseCache).build();
        context.ifPresent(ctx -> {
            LOG.info("Adding handler to invalidate cached prepared statements on type changes");
            EventExecutor adminExecutor = ctx.getNettyOptions().adminEventExecutorGroup().next();
            ctx.getEventBus().register(TypeChangeEvent.class, RunOrSchedule.on(adminExecutor, this::onTypeChanged));
        });
    }

    private static boolean typeMatches(UserDefinedType oldType, DataType typeToCheck) {
        switch (typeToCheck.getProtocolCode()) {
            case 48: {
                UserDefinedType udtType = (UserDefinedType)typeToCheck;
                return udtType.equals(oldType) ? true : Iterables.any(udtType.getFieldTypes(), testType -> CqlPrepareAsyncProcessor.typeMatches(oldType, testType));
            }
            case 32: {
                ListType listType = (ListType)typeToCheck;
                return CqlPrepareAsyncProcessor.typeMatches(oldType, listType.getElementType());
            }
            case 34: {
                SetType setType = (SetType)typeToCheck;
                return CqlPrepareAsyncProcessor.typeMatches(oldType, setType.getElementType());
            }
            case 33: {
                MapType mapType = (MapType)typeToCheck;
                return CqlPrepareAsyncProcessor.typeMatches(oldType, mapType.getKeyType()) || CqlPrepareAsyncProcessor.typeMatches(oldType, mapType.getValueType());
            }
            case 49: {
                TupleType tupleType = (TupleType)typeToCheck;
                return Iterables.any(tupleType.getComponentTypes(), testType -> CqlPrepareAsyncProcessor.typeMatches(oldType, testType));
            }
        }
        return false;
    }

    private void onTypeChanged(TypeChangeEvent event) {
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            try {
                PreparedStatement stmt = (PreparedStatement)((CompletableFuture)entry.getValue()).get();
                if (!Iterables.any(stmt.getResultSetDefinitions(), def -> CqlPrepareAsyncProcessor.typeMatches(event.oldType, def.getType())) && !Iterables.any(stmt.getVariableDefinitions(), def -> CqlPrepareAsyncProcessor.typeMatches(event.oldType, def.getType()))) continue;
                this.cache.invalidate(entry.getKey());
                this.cache.cleanUp();
            }
            catch (Exception e) {
                LOG.info("Exception while invalidating prepared statement cache due to UDT change", e);
            }
        }
    }

    @Override
    public boolean canProcess(Request request, GenericType<?> resultType) {
        return request instanceof PrepareRequest && resultType.equals(PrepareRequest.ASYNC);
    }

    @Override
    public CompletionStage<PreparedStatement> process(PrepareRequest request, DefaultSession session, InternalDriverContext context, String sessionLogPrefix) {
        try {
            CompletableFuture mine;
            CompletableFuture result = this.cache.getIfPresent(request);
            if (result == null && (result = this.cache.get(request, () -> CqlPrepareAsyncProcessor.lambda$process$5(mine = new CompletableFuture()))) == mine) {
                new CqlPrepareHandler(request, session, context, sessionLogPrefix).handle().whenComplete((preparedStatement, error) -> {
                    if (error != null) {
                        mine.completeExceptionally((Throwable)error);
                        this.cache.invalidate(request);
                    } else {
                        mine.complete(preparedStatement);
                    }
                });
            }
            return result.thenApply(x -> x);
        }
        catch (ExecutionException e) {
            return CompletableFutures.failedFuture(e.getCause());
        }
    }

    @Override
    public CompletionStage<PreparedStatement> newFailure(RuntimeException error) {
        return CompletableFutures.failedFuture(error);
    }

    public Cache<PrepareRequest, CompletableFuture<PreparedStatement>> getCache() {
        return this.cache;
    }

    private static /* synthetic */ CompletableFuture lambda$process$5(CompletableFuture mine) throws Exception {
        return mine;
    }
}

