/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.AbstractMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.HdrReservoir;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class DropwizardMetricUpdater<MetricT>
extends AbstractMetricUpdater<MetricT> {
    private static final Logger LOG = LoggerFactory.getLogger(DropwizardMetricUpdater.class);
    protected final MetricRegistry registry;
    protected final ConcurrentMap<MetricT, Metric> metrics = new ConcurrentHashMap<MetricT, Metric>();
    protected final ConcurrentMap<MetricT, Reservoir> reservoirs = new ConcurrentHashMap<MetricT, Reservoir>();

    protected DropwizardMetricUpdater(InternalDriverContext context, Set<MetricT> enabledMetrics, MetricRegistry registry) {
        super(context, enabledMetrics);
        this.registry = registry;
    }

    public <T extends Metric> T getMetric(MetricT metric, String profileName) {
        return (T)((Metric)this.metrics.get(metric));
    }

    @Override
    public void incrementCounter(MetricT metric, @Nullable String profileName, long amount) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateCounterFor(metric).inc(amount);
        }
    }

    @Override
    public void updateHistogram(MetricT metric, @Nullable String profileName, long value) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateHistogramFor(metric).update(value);
        }
    }

    @Override
    public void markMeter(MetricT metric, @Nullable String profileName, long amount) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateMeterFor(metric).mark(amount);
        }
    }

    @Override
    public void updateTimer(MetricT metric, @Nullable String profileName, long duration, TimeUnit unit) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateTimerFor(metric).update(duration, unit);
        }
    }

    @Override
    public void clearMetrics() {
        for (Object metric : this.metrics.keySet()) {
            MetricId id = this.getMetricId(metric);
            this.registry.remove(id.getName());
        }
        this.metrics.clear();
        this.reservoirs.clear();
    }

    protected abstract MetricId getMetricId(MetricT var1);

    protected void initializeGauge(MetricT metric, DriverExecutionProfile profile, Supplier<Number> supplier) {
        if (this.isEnabled(metric, profile.getName())) {
            this.metrics.computeIfAbsent(metric, m4 -> {
                MetricId id = this.getMetricId(m4);
                return this.registry.gauge(id.getName(), () -> DropwizardMetricUpdater.lambda$initializeGauge$0((Supplier)supplier));
            });
        }
    }

    protected void initializeCounter(MetricT metric, DriverExecutionProfile profile) {
        if (this.isEnabled(metric, profile.getName())) {
            this.getOrCreateCounterFor(metric);
        }
    }

    protected void initializeHdrTimer(MetricT metric, DriverExecutionProfile profile, DriverOption highestLatency, DriverOption significantDigits, DriverOption interval) {
        if (this.isEnabled(metric, profile.getName())) {
            this.reservoirs.computeIfAbsent(metric, m4 -> this.createHdrReservoir(m4, profile, highestLatency, significantDigits, interval));
            this.getOrCreateTimerFor(metric);
        }
    }

    protected Counter getOrCreateCounterFor(MetricT metric) {
        return (Counter)this.metrics.computeIfAbsent(metric, m4 -> {
            MetricId id = this.getMetricId(m4);
            return this.registry.counter(id.getName());
        });
    }

    protected Meter getOrCreateMeterFor(MetricT metric) {
        return (Meter)this.metrics.computeIfAbsent(metric, m4 -> {
            MetricId id = this.getMetricId(m4);
            return this.registry.meter(id.getName());
        });
    }

    protected Histogram getOrCreateHistogramFor(MetricT metric) {
        return (Histogram)this.metrics.computeIfAbsent(metric, m4 -> {
            MetricId id = this.getMetricId(m4);
            return this.registry.histogram(id.getName());
        });
    }

    protected Timer getOrCreateTimerFor(MetricT metric) {
        return (Timer)this.metrics.computeIfAbsent(metric, m4 -> {
            MetricId id = this.getMetricId(m4);
            Reservoir reservoir = (Reservoir)this.reservoirs.get(metric);
            Timer timer = reservoir == null ? new Timer() : new Timer(reservoir);
            return this.registry.timer(id.getName(), () -> timer);
        });
    }

    protected HdrReservoir createHdrReservoir(MetricT metric, DriverExecutionProfile profile, DriverOption highestLatencyOption, DriverOption significantDigitsOption, DriverOption intervalOption) {
        MetricId id = this.getMetricId(metric);
        Duration highestLatency = profile.getDuration(highestLatencyOption);
        int significantDigits = profile.getInt(significantDigitsOption);
        if (significantDigits < 0 || significantDigits > 5) {
            LOG.warn("[{}] Configuration option {} is out of range (expected between 0 and 5, found {}); using 3 instead.", id.getName(), significantDigitsOption, significantDigits);
            significantDigits = 3;
        }
        Duration refreshInterval = profile.getDuration(intervalOption);
        return new HdrReservoir(highestLatency, significantDigits, refreshInterval, id.getName());
    }

    private static /* synthetic */ Gauge lambda$initializeGauge$0(Supplier supplier) {
        return ((Supplier)supplier)::get;
    }
}

