/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import pt.unl.fct.di.novasys.babel.core.security.IdFromCertExtractor;
import pt.unl.fct.di.novasys.babel.core.security.IdentityCrypt;
import pt.unl.fct.di.novasys.babel.core.security.IdentityGenerator;
import pt.unl.fct.di.novasys.babel.core.security.IdentityPair;
import pt.unl.fct.di.novasys.babel.core.security.SecretCrypt;
import pt.unl.fct.di.novasys.babel.exceptions.InvalidParameterException;
import pt.unl.fct.di.novasys.babel.internal.security.BabelCredentialHandler;
import pt.unl.fct.di.novasys.babel.internal.security.IdAliasMapper;
import pt.unl.fct.di.novasys.babel.internal.security.PeerIdEncoder;
import pt.unl.fct.di.novasys.babel.internal.security.X509BabelKeyManager;
import pt.unl.fct.di.novasys.babel.internal.security.X509BabelTrustManager;
import pt.unl.fct.di.novasys.babel.internal.security.X509CertificateChainPredicate;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;
import pt.unl.fct.di.novasys.network.security.X509ITrustManager;

public class BabelSecurity {
    private static final Logger logger = LogManager.getLogger(BabelSecurity.class);
    private final KeyStore.ProtectionParameter EMPTY_PWD = new KeyStore.PasswordProtection(new char[0]);
    private static BabelSecurity instance;
    public static final String PREFIX = "babel.security";
    public static final String PRNG_ALG = "DEFAULT";
    public static final String NONCE_ALG = "NonceAndIV";
    private static final String PAR_KEY_STORE_TYPE = "babel.security.keystore.type";
    private String keyStoreType = "PKCS12";
    private static final String PAR_KEY_STORE_PATH = "babel.security.keystore.path";
    private String keyStoreLoadPath = "babelKeyStore.jks";
    private static final String PAR_KEY_STORE_WRITABLE = "babel.security.keystore.writable";
    private String keyStoreWritePath = null;
    private static final String PAR_KEY_STORE_PWD = "babel.security.keystore.password";
    private static final String PAR_KEY_STORE_PROTECTION = "babel.security.keystore.protection_handler";
    private KeyStore.ProtectionParameter keyStoreProtection = this.EMPTY_PWD;
    private static final String PAR_DEFAULT_ID = "babel.security.keystore.default_identity";
    private static final String PAR_ASYM_KEY_ALG = "babel.security.asym_key_algorithm";
    private String asymKeyAlgorithm = "RSA";
    private static final String PAR_ASYM_KEY_LEN = "babel.security.asym_key_length";
    private int asymKeyLength = 2048;
    private static final String PAR_ASYM_KEY_PARAMS = "babel.security.asym_key_parameter_supplier";
    private AlgorithmParameterSpec asymKeyParameters = new RSAKeyGenParameterSpec(this.asymKeyLength, RSAKeyGenParameterSpec.F4);
    private static final String PAR_ID_EXTRACTOR = "babel.security.identity_extractor";
    private IdFromCertExtractor identityExtractor = new BabelCredentialHandler();
    private static final String PAR_ID_GENERATOR = "babel.security.identity_generator";
    private IdentityGenerator identityGenerator = (BabelCredentialHandler)this.identityExtractor;
    private static final String PAR_TRUST_STORE_TYPE = "babel.security.truststore.type";
    private String trustStoreType;
    private static final String PAR_TRUST_STORE_PWD = "babel.security.truststore.password";
    private static final String PAR_TRUST_STORE_PROTECTION = "babel.security.truststore.protection_handler";
    private KeyStore.ProtectionParameter trustStoreProtection = this.EMPTY_PWD;
    private static final String PAR_TRUST_STORE_PATH = "babel.security.truststore.path";
    private String trustStoreLoadPath = "babelTrustStore.jks";
    private static final String PAR_TRUST_STORE_WRITABLE = "babel.security.truststore.writable";
    private String trustStoreWritePath = null;
    private static final String PAR_TRUST_MANAGER_POLICY = "babel.security.trustmanager.policy";
    private X509BabelTrustManager.TrustPolicy trustManagerPolicy = X509BabelTrustManager.TrustPolicy.UNKNOWN;
    private static final String PAR_TRUST_MANAGER_SAVE_ENCOUNTERED = "babel.security.trustmanager.save_encountered";
    private boolean trustManagerSaveEncountered = true;
    private static final String PAR_TRUST_MANAGER_PERSIST_DISCOVERED_CERTS = "babel.security.trustmanager.persist_discovered_certificates";
    private boolean trustManagerPersistCerts = false;
    private static final String PAR_TRUST_MANAGER_UNKNOWN_PEER_CALLBACK = "babel.security.trustmanager.unknown_peer_callback";
    private X509CertificateChainPredicate trustManagerUknownPeerCallback = (certChain, id) -> false;
    private static final String PAR_TRUST_MANAGER_VERIFY_SIGNATURE_CALLBACK = "babel.security.trustmanager.verify_cert_signature_callback";
    private X509CertificateChainPredicate trustManagerVerifySignatureCallback = (certChain, id) -> {
        try {
            certChain[0].verify(certChain[0].getPublicKey());
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new CertificateException("Failed self-signed certificate verification.", e);
        }
    };
    private static final String PAR_SECRET_STORE_TYPE = "babel.security.secretstore.type";
    private String secretStoreType;
    private static final String PAR_SECRET_STORE_PWD = "babel.security.secretstore.password";
    private static final String PAR_SECRET_STORE_PROTECTION = "babel.security.secretstore.protection_handler";
    private KeyStore.ProtectionParameter secretStoreProtection = this.EMPTY_PWD;
    private static final String PAR_SECRET_STORE_PATH = "babel.security.secretstore.path";
    private String secretStoreLoadPath = "babelSecretStore.jks";
    private static final String PAR_SECRET_STORE_WRITABLE = "babel.security.secretstore.writable";
    private String secretStoreWritePath = null;
    private static final String PAR_SYM_KEY_ALG = "babel.security.sym_key_algorithm";
    private String symKeyAlgorithm = "AES";
    private static final String PAR_SYM_KEY_LEN = "babel.security.secretkey_length";
    private int symKeyLength = 128;
    private static final String PAR_PBKDF_ALG = "babel.security.pbkdf.algorithm";
    private String pbkdfAlgorithm = "PBKDF2WithHmacSHA256";
    private static final String PAR_PBKDF_SALT = "babel.security.pbkdf.salt";
    private byte[] pbkdfSalt = "Babel sa(u)lt defa(u)lt! You (or I?) should change this!!!".getBytes();
    private static final String PAR_PBKDF_ITERATIONS = "babel.security.pbkdf.iterations";
    private int pbkdfIterations = 131072;
    private static final String PAR_PBKDF_KEY_LEN = "babel.security.pbkdf.key_length";
    private int pbkdfKeyLength = 256;
    private static final String PAR_PBKDF_PWD = "babel.security.pbkdf.initial_secret_password";
    private static final String STARTUP_PWD_DERIVED_KEY_ALIAS = "babel.password_derived";
    public static final String PAR_HASH_ALG = "babel.security.hash_algorithm";
    private String hashAlgorithm = "SHA256";
    public static final String PAR_MAC_ALG = "babel.security.mac_algorithm";
    private String macAlgorithm = null;
    public static final String PAR_CIPHER_TRANSFORM = "babel.security.cipher.transformation";
    private String cipherTransform = null;
    public static final String PAR_CIPHER_MODE = "babel.security.cipher.mode";
    private String cipherMode = "GCM";
    public static final String PAR_CIPHER_PADDING = "babel.security.cipher.padding";
    private String cipherPadding = "NoPadding";
    public static final String PAR_CIPHER_IV_SIZE = "babel.security.cipher.iv_size";
    public static final String PAR_CIPHER_PARAM_SUPPLIER = "babel.security.cipher.parameter_supplier";
    private Supplier<AlgorithmParameterSpec> cipherParameterSupplier = () -> new GCMParameterSpec(128, this.generateIv(12));
    private KeyStore keyStore;
    private KeyStore ephKeyStore;
    private X509IKeyManager keyManager;
    private KeyStore trustStore;
    private KeyStore ephTrustStore;
    private X509ITrustManager trustManager;
    private KeyStore secretStore;
    private KeyStore ephSecretStore;
    public final Provider PROVIDER = new BouncyCastleProvider();
    private final IdAliasMapper idAliasMapper;
    private final SecureRandom keyRng;
    private final SecureRandom nonceRng;

    public static synchronized BabelSecurity getInstance() {
        if (instance == null) {
            instance = new BabelSecurity();
        }
        return instance;
    }

    private BabelSecurity() {
        Security.addProvider(this.PROVIDER);
        try {
            this.keyRng = SecureRandom.getInstance(PRNG_ALG, this.PROVIDER);
            this.nonceRng = SecureRandom.getInstance(NONCE_ALG, this.PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        this.idAliasMapper = new IdAliasMapper();
    }

    public synchronized KeyStore getKeyStore() {
        if (this.keyStore == null) {
            try {
                this.keyStore = BabelSecurity.loadOrCreateStore(this.keyStoreLoadPath, this.keyStoreType, this.keyStoreProtection);
                if (this.keyStore.size() == 0) {
                    logger.debug("Empty key store loaded. Generating an identity...");
                    this.generateIdentityWithAliasPrefix(true, "babel");
                } else {
                    logger.debug("Non-empty key store loaded. Analyzing its private key entries...");
                    this.idAliasMapper.populateFromPrivateKeyStore(this.keyStore, this.keyStoreProtection, this.identityExtractor);
                }
            }
            catch (KeyStoreException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.keyStore;
    }

    public synchronized KeyStore getEphemeralKeyStore() {
        if (this.ephKeyStore == null) {
            try {
                logger.debug("Creating new ephemeral key store with an auto-generated identity.");
                this.ephKeyStore = KeyStore.Builder.newInstance(this.keyStoreType, null, this.EMPTY_PWD).getKeyStore();
                this.generateIdentityWithAliasPrefix(false, "babel");
            }
            catch (KeyStoreException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.ephKeyStore;
    }

    public synchronized X509IKeyManager getKeyManager() {
        if (this.keyManager == null) {
            try {
                this.keyManager = new X509BabelKeyManager(this.keyStoreProtection, this.idAliasMapper, this.getKeyStore(), this.getEphemeralKeyStore());
            }
            catch (KeyStoreException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.keyManager;
    }

    public synchronized KeyStore getTrustStore() {
        if (this.trustStore == null) {
            try {
                this.trustStore = BabelSecurity.loadOrCreateStore(this.trustStoreLoadPath, this.trustStoreType, this.trustStoreProtection);
            }
            catch (KeyStoreException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.trustStore;
    }

    public synchronized KeyStore getEphemeralTrustStore() {
        if (this.ephTrustStore == null) {
            try {
                logger.debug("Creating new ephemeral trust store");
                this.ephTrustStore = KeyStore.Builder.newInstance(this.trustStoreType, null, this.EMPTY_PWD).getKeyStore();
            }
            catch (KeyStoreException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.ephTrustStore;
    }

    public synchronized X509ITrustManager getTrustManager() {
        if (this.trustManager == null) {
            try {
                KeyStore targetStore = this.trustManagerSaveEncountered ? (this.trustManagerPersistCerts ? this.getTrustStore() : this.getEphemeralTrustStore()) : null;
                this.trustManager = new X509BabelTrustManager(this.identityExtractor, List.of(this.getTrustStore(), this.getEphemeralTrustStore()), this.trustManagerPolicy, this.trustManagerUknownPeerCallback, this.trustManagerVerifySignatureCallback, targetStore);
            }
            catch (KeyStoreException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.trustManager;
    }

    public synchronized KeyStore getSecretStore() {
        if (this.secretStore == null) {
            try {
                this.secretStore = BabelSecurity.loadOrCreateStore(this.secretStoreLoadPath, this.secretStoreType, this.secretStoreProtection);
            }
            catch (KeyStoreException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.secretStore;
    }

    public synchronized KeyStore getEphemeralSecretStore() {
        if (this.ephSecretStore == null) {
            try {
                logger.debug("Creating new ephemeral trust store");
                this.ephSecretStore = KeyStore.Builder.newInstance(this.secretStoreType, null, this.EMPTY_PWD).getKeyStore();
            }
            catch (KeyStoreException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.ephSecretStore;
    }

    private static KeyStore loadOrCreateStore(String loadPath, String storeType, KeyStore.ProtectionParameter protection) throws KeyStoreException {
        logger.debug("Loading (or creating) a key store from " + loadPath);
        File file = loadPath != null ? new File(loadPath) : null;
        return file != null && file.exists() ? KeyStore.Builder.newInstance(file, protection).getKeyStore() : KeyStore.Builder.newInstance(storeType, null, protection).getKeyStore();
    }

    public byte[] generateIv(int size) {
        byte[] iv = new byte[size];
        this.nonceRng.nextBytes(iv);
        return iv;
    }

    public IvParameterSpec generateIvParam(int size) {
        return new IvParameterSpec(this.generateIv(size));
    }

    public SecureRandom getSecureRandom() {
        return this.keyRng;
    }

    public KeyPair generateKeyPair() {
        KeyPairGenerator keyPairGen;
        try {
            keyPairGen = KeyPairGenerator.getInstance(this.asymKeyAlgorithm, this.PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                keyPairGen = KeyPairGenerator.getInstance(this.asymKeyAlgorithm);
            }
            catch (NoSuchAlgorithmException e1) {
                throw new AssertionError((Object)e1);
            }
        }
        try {
            if (this.asymKeyParameters != null) {
                keyPairGen.initialize(this.asymKeyParameters, this.keyRng);
            } else {
                keyPairGen.initialize(this.asymKeyLength, this.keyRng);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new AssertionError((Object)e);
        }
        return keyPairGen.generateKeyPair();
    }

    private char[] getPassword(KeyStore.ProtectionParameter protParam, String storeName) throws IOException, UnsupportedCallbackException {
        if (protParam instanceof KeyStore.PasswordProtection) {
            KeyStore.PasswordProtection pwdProt = (KeyStore.PasswordProtection)protParam;
            return pwdProt.getPassword();
        }
        if (protParam instanceof KeyStore.CallbackHandlerProtection) {
            KeyStore.CallbackHandlerProtection callbackProt = (KeyStore.CallbackHandlerProtection)protParam;
            PasswordCallback callback = new PasswordCallback("Password for " + storeName, false);
            callbackProt.getCallbackHandler().handle(new Callback[]{callback});
            return callback.getPassword();
        }
        return null;
    }

    public boolean verifySignature(byte[] signature, PublicKey publicKey, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = this.initVerifySignature(publicKey, data);
        return sig.verify(signature);
    }

    public boolean verifySignature(byte[] signature, PublicKey publicKey, ByteBuffer data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = this.initVerifySignature(publicKey, data);
        return sig.verify(signature);
    }

    public boolean verifySignature(byte[] signature, byte[] signerId, byte[] ... data) throws NoSuchAlgorithmException, SignatureException, NoSuchElementException, InvalidKeyException {
        Signature signature2;
        Certificate cert = this.getTrustedCertificate(signerId);
        if (cert == null) {
            throw new NoSuchElementException("No known certificate for %s that can be used to verify the signature".formatted(PeerIdEncoder.encodeToString(signerId)));
        }
        if (cert instanceof X509Certificate) {
            X509Certificate x509Cert = (X509Certificate)cert;
            signature2 = this.initVerifySignature(x509Cert.getSigAlgName(), x509Cert.getPublicKey(), data);
        } else {
            signature2 = this.initVerifySignature(cert.getPublicKey(), data);
        }
        Signature sig = signature2;
        return sig.verify(signature);
    }

    public boolean verifySignature(byte[] signature, byte[] signerId, ByteBuffer data) throws NoSuchAlgorithmException, SignatureException, NoSuchElementException, InvalidKeyException {
        Signature signature2;
        Certificate cert = this.getTrustedCertificate(signerId);
        if (cert == null) {
            throw new NoSuchElementException("No known certificate for %s that can be used to verify the signature".formatted(PeerIdEncoder.encodeToString(signerId)));
        }
        if (cert instanceof X509Certificate) {
            X509Certificate x509Cert = (X509Certificate)cert;
            signature2 = this.initVerifySignature(x509Cert.getSigAlgName(), x509Cert.getPublicKey(), data);
        } else {
            signature2 = this.initVerifySignature(cert.getPublicKey(), data);
        }
        Signature sig = signature2;
        return sig.verify(signature);
    }

    public boolean verifySignature(String algorithm, byte[] signature, PublicKey publicKey, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = this.initVerifySignature(algorithm, publicKey, data);
        return sig.verify(signature);
    }

    public boolean verifySignature(String algorithm, byte[] signature, PublicKey publicKey, ByteBuffer data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = this.initVerifySignature(algorithm, publicKey, data);
        return sig.verify(signature);
    }

    public boolean verifySignature(String algorithm, byte[] signature, byte[] signerId, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchElementException {
        Certificate cert = this.getTrustedCertificate(signerId);
        if (cert == null) {
            throw new NoSuchElementException("No known certificate for %s that can be used to verify the signature".formatted(PeerIdEncoder.encodeToString(signerId)));
        }
        Signature sig = this.initVerifySignature(algorithm, cert.getPublicKey(), data);
        return sig.verify(signature);
    }

    public boolean verifySignature(String algorithm, byte[] signature, byte[] signerId, ByteBuffer data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchElementException {
        Certificate cert = this.getTrustedCertificate(signerId);
        if (cert == null) {
            throw new NoSuchElementException("No known certificate for %s that can be used to verify the signature".formatted(PeerIdEncoder.encodeToString(signerId)));
        }
        Signature sig = this.initVerifySignature(algorithm, cert.getPublicKey(), data);
        return sig.verify(signature);
    }

    public Signature initVerifySignature(byte[] signerId, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature signature;
        Certificate cert = this.getTrustedCertificate(signerId);
        if (cert == null) {
            throw new NoSuchElementException("No known certificate for %s that can be used to verify the signature".formatted(PeerIdEncoder.encodeToString(signerId)));
        }
        if (cert instanceof X509Certificate) {
            X509Certificate x509Cert = (X509Certificate)cert;
            signature = this.initVerifySignature(x509Cert.getSigAlgName(), x509Cert.getPublicKey(), data);
        } else {
            signature = this.initVerifySignature(cert.getPublicKey(), data);
        }
        return signature;
    }

    public Signature initVerifySignature(byte[] signerId, ByteBuffer data) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchElementException {
        Signature signature;
        Certificate cert = this.getTrustedCertificate(signerId);
        if (cert == null) {
            throw new NoSuchElementException("No known certificate for %s that can be used to verify the signature".formatted(PeerIdEncoder.encodeToString(signerId)));
        }
        if (cert instanceof X509Certificate) {
            X509Certificate x509Cert = (X509Certificate)cert;
            signature = this.initVerifySignature(x509Cert.getSigAlgName(), x509Cert.getPublicKey(), data);
        } else {
            signature = this.initVerifySignature(cert.getPublicKey(), data);
        }
        return signature;
    }

    public Signature initVerifySignature(PublicKey publicKey, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.initVerifySignature(this.getSignatureAlgorithmFor(publicKey.getAlgorithm()), publicKey, data);
    }

    public Signature initVerifySignature(PublicKey publicKey, ByteBuffer data) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.initVerifySignature(this.getSignatureAlgorithmFor(publicKey.getAlgorithm()), publicKey, data);
    }

    public Signature initVerifySignature(String algorithm, byte[] signerId, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchElementException {
        Certificate cert = this.getTrustedCertificate(signerId);
        if (cert == null) {
            throw new NoSuchElementException("No known certificate for %s that can be used to verify the signature".formatted(PeerIdEncoder.encodeToString(signerId)));
        }
        return this.initVerifySignature(algorithm, cert.getPublicKey(), data);
    }

    public Signature initVerifySignature(String algorithm, byte[] signerId, ByteBuffer data) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchElementException {
        Certificate cert = this.getTrustedCertificate(signerId);
        if (cert == null) {
            throw new NoSuchElementException("No known certificate for %s that can be used to verify the signature".formatted(PeerIdEncoder.encodeToString(signerId)));
        }
        return this.initVerifySignature(algorithm, cert.getPublicKey(), data);
    }

    public Signature initVerifySignature(String algorithm, PublicKey publicKey, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature sig;
        try {
            sig = Signature.getInstance(algorithm, this.PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            sig = Signature.getInstance(algorithm);
        }
        sig.initVerify(publicKey);
        try {
            for (byte[] part : data) {
                sig.update(part);
            }
        }
        catch (SignatureException e) {
            throw new AssertionError((Object)e);
        }
        return sig;
    }

    public Signature initVerifySignature(String algorithm, PublicKey publicKey, ByteBuffer data) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature sig;
        try {
            sig = Signature.getInstance(algorithm, this.PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            sig = Signature.getInstance(algorithm);
        }
        sig.initVerify(publicKey);
        try {
            sig.update(data);
        }
        catch (SignatureException e) {
            throw new AssertionError((Object)e);
        }
        return sig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<KeyStore.PrivateKeyEntry, String> deleteIdentity(byte[] identity) throws UnrecoverableEntryException {
        IdAliasMapper idAliasMapper = this.idAliasMapper;
        synchronized (idAliasMapper) {
            String alias = this.idAliasMapper.getAlias(identity);
            Pair<KeyStore.PrivateKeyEntry, byte[]> result = this.deleteIdentity(alias);
            assert (Arrays.equals(result.getRight(), identity));
            return Pair.of(result.getLeft(), alias);
        }
    }

    public Pair<KeyStore.PrivateKeyEntry, byte[]> deleteIdentity(String alias) throws UnrecoverableEntryException {
        IdAliasMapper idAliasMapper = this.idAliasMapper;
        synchronized (idAliasMapper) {
            try {
                Pair<KeyStore, KeyStore.ProtectionParameter> chosenPair = this.chooseKeyStore(store -> store.containsAlias(alias));
                KeyStore keyStore = chosenPair.getLeft();
                KeyStore.ProtectionParameter protection = chosenPair.getRight();
                try {
                    KeyStore.Entry entry = keyStore.getEntry(alias, protection);
                    if (entry instanceof KeyStore.PrivateKeyEntry) {
                        KeyStore.PrivateKeyEntry deleted = (KeyStore.PrivateKeyEntry)entry;
                        keyStore.deleteEntry(alias);
                        byte[] removedId = this.idAliasMapper.removeAlias(alias);
                        return Pair.of(deleted, removedId);
                    }
                    return null;
                }
                catch (NoSuchAlgorithmException e) {
                    keyStore.deleteEntry(alias);
                    byte[] removedId = this.idAliasMapper.removeAlias(alias);
                    return Pair.of(null, removedId);
                }
            }
            catch (KeyStoreException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public IdentityCrypt generateIdentity(boolean persistOnDisk) {
        try {
            return this.addIdentity(persistOnDisk, this.identityGenerator.generateRandomCredentials());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The defined IdentityGenerator failed to generate a new identity", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed generating identity. Proabably the defined IdentityGenerator is incompatible with the defined IdFromCertExtractor", e);
        }
    }

    public IdentityCrypt generateIdentityWithAliasPrefix(boolean persistOnDisk, String aliasPrefix) {
        try {
            return this.addIdentityWithAliasPrefix(persistOnDisk, aliasPrefix, this.identityGenerator.generateRandomCredentials());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public IdentityCrypt generateIdentity(boolean persistOnDisk, String alias) {
        try {
            return this.addIdentity(persistOnDisk, alias, this.identityGenerator.generateRandomCredentials());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("The defined IdentityGenerator failed to generate a new identity", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed generating identity. Proabably the defined IdentityGenerator is incompatible with the defined IdFromCertExtractor", e);
        }
    }

    public IdentityCrypt generateIdentity(boolean persistOnDisk, KeyPair keyPair) throws NoSuchAlgorithmException {
        try {
            return this.addIdentity(persistOnDisk, this.identityGenerator.generateCredentials(keyPair));
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed generating identity. Proabably the defined IdentityGenerator is incompatible with the defined IdFromCertExtractor", e);
        }
    }

    public IdentityCrypt generateIdentityWithAliasPrefix(boolean persistOnDisk, String aliasPrefix, KeyPair keyPair) throws NoSuchAlgorithmException {
        return this.addIdentityWithAliasPrefix(persistOnDisk, aliasPrefix, this.identityGenerator.generateCredentials(keyPair));
    }

    public IdentityCrypt generateIdentity(boolean persistOnDisk, String alias, KeyPair keyPair) throws NoSuchAlgorithmException {
        try {
            return this.addIdentity(persistOnDisk, alias, this.identityGenerator.generateCredentials(keyPair));
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed generating identity. Proabably the defined IdentityGenerator is incompatible with the defined IdFromCertExtractor", e);
        }
    }

    public IdentityCrypt addIdentity(boolean persistOnDisk, KeyStore.PrivateKeyEntry keyStoreEntry) throws NoSuchAlgorithmException, CertificateException {
        return this.addIdentity(persistOnDisk, null, keyStoreEntry);
    }

    public IdentityCrypt addIdentityWithAliasPrefix(boolean persistOnDisk, String aliasPrefix, KeyStore.PrivateKeyEntry keyStoreEntry) throws NoSuchAlgorithmException {
        byte[] id;
        try {
            id = this.identityExtractor.extractIdentity(keyStoreEntry.getCertificate());
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        String alias = aliasPrefix + "." + PeerIdEncoder.encodeToString(id);
        this.addIdentity(persistOnDisk, alias, id, keyStoreEntry);
        return this.getIdentityCrypt(alias, id, keyStoreEntry);
    }

    public IdentityCrypt addIdentity(boolean persistOnDisk, String alias, KeyStore.PrivateKeyEntry keyStoreEntry) throws NoSuchAlgorithmException, CertificateException {
        byte[] id = this.identityExtractor.extractIdentity(keyStoreEntry.getCertificate());
        alias = alias == null ? PeerIdEncoder.encodeToString(id) : alias;
        this.addIdentity(persistOnDisk, alias, id, keyStoreEntry);
        return this.getIdentityCrypt(alias, id, keyStoreEntry);
    }

    public IdentityCrypt getDefaultIdentityCrypt() throws NoSuchAlgorithmException, UnrecoverableEntryException {
        IdentityPair idPair = this.idAliasMapper.getDefault();
        return idPair != null ? this.getIdentityCrypt(idPair.alias(), idPair.identity()) : this.generateIdentity(false);
    }

    public IdentityCrypt getIdentityCrypt(String alias) throws NoSuchAlgorithmException, UnrecoverableEntryException {
        byte[] id = this.idAliasMapper.getId(alias);
        return id == null ? null : this.getIdentityCrypt(alias, id);
    }

    public IdentityCrypt getIdentityCrypt(byte[] identity) throws NoSuchAlgorithmException, UnrecoverableEntryException {
        String alias = this.idAliasMapper.getAlias(identity);
        return alias == null ? null : this.getIdentityCrypt(alias, identity);
    }

    public Set<IdentityPair> getAllIdentities() {
        try {
            HashSet<IdentityPair> ids = new HashSet<IdentityPair>(this.getKeyStore().size() + this.getEphemeralKeyStore().size());
            this.getKeyStore().aliases().asIterator().forEachRemaining(alias -> ids.add(new IdentityPair((String)alias, this.idAliasMapper.getId((String)alias))));
            this.getEphemeralKeyStore().aliases().asIterator().forEachRemaining(alias -> ids.add(new IdentityPair((String)alias, this.idAliasMapper.getId((String)alias))));
            return ids;
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Set<IdentityPair> getAllIdentitiesWithPrefix(String aliasPrefix) {
        try {
            HashSet<IdentityPair> ids = new HashSet<IdentityPair>(this.getKeyStore().size() + this.getEphemeralKeyStore().size());
            aliasPrefix = aliasPrefix.toLowerCase();
            for (Enumeration<String> enumeration : List.of(this.getKeyStore().aliases(), this.getEphemeralKeyStore().aliases())) {
                while (enumeration.hasMoreElements()) {
                    String alias = enumeration.nextElement();
                    if (!alias.toLowerCase().startsWith(aliasPrefix + ".")) continue;
                    ids.add(new IdentityPair(alias, this.idAliasMapper.getId(alias)));
                }
            }
            return ids;
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getIdentityAlias(byte[] identity) {
        return this.idAliasMapper.getAlias(identity);
    }

    public byte[] getAliasIdentity(String alias) {
        return this.idAliasMapper.getId(alias);
    }

    public IdentityPair getDefaultIdentity() {
        this.getKeyStore();
        return this.idAliasMapper.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdentity(boolean peristOnDisk, String alias, byte[] id, KeyStore.PrivateKeyEntry entry) {
        IdAliasMapper idAliasMapper = this.idAliasMapper;
        synchronized (idAliasMapper) {
            try {
                Pair<KeyStore, KeyStore.ProtectionParameter> chosenPair = this.chooseKeyStore(__ -> peristOnDisk);
                KeyStore store = chosenPair.getLeft();
                KeyStore.ProtectionParameter protection = chosenPair.getRight();
                this.idAliasMapper.put(alias, id);
                store.setEntry(alias, entry, protection);
                if (peristOnDisk && this.keyStoreWritePath != null) {
                    store.store(new FileOutputStream(this.keyStoreWritePath), this.getPassword(this.keyStoreProtection, this.keyStoreWritePath));
                }
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException | UnsupportedCallbackException e) {
                logger.error("Couldn't persist key store to {} after adding identity {}. Cause: {}", (Object)this.keyStoreWritePath, (Object)alias, (Object)e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private IdentityCrypt getIdentityCrypt(String alias, byte[] id) throws NoSuchAlgorithmException, UnrecoverableEntryException {
        return this.getIdentityCrypt(alias, id, (String)null);
    }

    private IdentityCrypt getIdentityCrypt(String alias, byte[] id, String sigHashOrAlg) throws NoSuchAlgorithmException, UnrecoverableEntryException {
        try {
            Pair<KeyStore, KeyStore.ProtectionParameter> chosenPair = this.chooseKeyStore(store -> store.containsAlias(alias));
            KeyStore.Entry entry = chosenPair.getLeft().getEntry(alias, chosenPair.getRight());
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)entry;
                return sigHashOrAlg == null ? this.getIdentityCrypt(alias, id, pkEntry) : this.getIdentityCrypt(alias, id, pkEntry, sigHashOrAlg);
            }
            return null;
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    private IdentityCrypt getIdentityCrypt(String alias, byte[] id, KeyStore.PrivateKeyEntry entry) throws NoSuchAlgorithmException {
        return this.getIdentityCrypt(alias, id, entry, this.getSignatureAlgorithmFor(entry.getPrivateKey().getAlgorithm()));
    }

    private IdentityCrypt getIdentityCrypt(String alias, byte[] id, KeyStore.PrivateKeyEntry entry, String sigHashOrAlg) throws NoSuchAlgorithmException {
        PrivateKey privKey = entry.getPrivateKey();
        PublicKey pubKey = entry.getCertificate().getPublicKey();
        Certificate[] certChain = entry.getCertificateChain();
        return new IdentityCrypt(alias, id, privKey, pubKey, certChain, sigHashOrAlg);
    }

    public String getSignatureAlgorithmFor(String keyAlgorithm) throws NoSuchAlgorithmException {
        if (keyAlgorithm.equals("EdDSA")) {
            return "EdDSA";
        }
        String sigAlg = this.hashAlgorithm + "WITH" + keyAlgorithm;
        if (Security.getAlgorithms("Signature").contains(sigAlg.toUpperCase())) {
            return sigAlg;
        }
        throw new NoSuchAlgorithmException("No such Signature algorithm: " + sigAlg);
    }

    private Pair<KeyStore, KeyStore.ProtectionParameter> chooseKeyStore(KeyStorePredicate shouldBePersistent) throws KeyStoreException {
        KeyStore persistent = this.getKeyStore();
        return shouldBePersistent.test(persistent) ? Pair.of(persistent, this.keyStoreProtection) : Pair.of(this.getEphemeralKeyStore(), this.EMPTY_PWD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrustedCertificate(boolean peristOnDisk, Certificate certificate) throws KeyStoreException, CertificateException {
        KeyStore trustStore = peristOnDisk ? this.getTrustStore() : this.getEphemeralTrustStore();
        String alias = PeerIdEncoder.encodeToString(this.identityExtractor.extractIdentity(certificate));
        KeyStore keyStore = trustStore;
        synchronized (keyStore) {
            trustStore.setCertificateEntry(alias, certificate);
            if (peristOnDisk && this.trustStoreWritePath != null) {
                try {
                    trustStore.store(new FileOutputStream(this.trustStoreWritePath), this.getPassword(this.trustStoreProtection, this.trustStoreWritePath));
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException | UnsupportedCallbackException e) {
                    logger.error("Couldn't persist trust store to {} after adding trusted certificate {}. Cause: {}", (Object)this.trustStoreWritePath, (Object)alias, (Object)e);
                }
            }
        }
    }

    public void addTrustedPeerIdentity(byte[] peerId) {
        this.getTrustManager().addTrustedId(peerId);
    }

    public void removeTrustedPeerIdentity(byte[] peerId) {
        this.getTrustManager().removeTrustedId(peerId);
    }

    public Certificate getTrustedCertificate(byte[] peerId) {
        Certificate persistent = this.getTrustedCertificateFrom(this.getTrustStore(), peerId);
        return persistent != null ? persistent : this.getTrustedCertificateFrom(this.getEphemeralTrustStore(), peerId);
    }

    public boolean setTrustManagerPolicy(X509BabelTrustManager.TrustPolicy newPolicy) {
        X509ITrustManager x509ITrustManager = this.getTrustManager();
        if (x509ITrustManager instanceof X509BabelTrustManager) {
            X509BabelTrustManager trustMan = (X509BabelTrustManager)x509ITrustManager;
            trustMan.setTrustPolicy(newPolicy);
            return true;
        }
        return false;
    }

    private Certificate getTrustedCertificateFrom(KeyStore trustStore, byte[] peerId) {
        try {
            byte[] trustedId;
            String alias = PeerIdEncoder.encodeToString(peerId);
            Certificate cert = trustStore.getCertificate(alias);
            if (cert != null && Arrays.equals(trustedId = this.identityExtractor.extractIdentity(cert), peerId)) {
                return cert;
            }
        }
        catch (KeyStoreException | CertificateException generalSecurityException) {
            // empty catch block
        }
        return null;
    }

    public SecretCrypt generateSecretFromPasswordWithAliasPrefix(boolean persistOnDisk, String aliasPrefix, String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return this.addSecretWithAliasPrefix(persistOnDisk, aliasPrefix, this.applyPBKDF(password.toCharArray(), this.pbkdfSalt));
    }

    public SecretCrypt generateSecretFromPasswordWithAliasPrefix(boolean persistOnDisk, String aliasPrefix, String password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return this.addSecretWithAliasPrefix(persistOnDisk, aliasPrefix, this.applyPBKDF(password.toCharArray(), salt));
    }

    public SecretCrypt generateSecretFromPassword(boolean persistOnDisk, String alias, String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return this.addSecret(persistOnDisk, alias, this.applyPBKDF(password.toCharArray(), this.pbkdfSalt));
    }

    public SecretCrypt generateSecretFromPassword(boolean persistOnDisk, String alias, String password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return this.addSecret(persistOnDisk, alias, this.applyPBKDF(password.toCharArray(), salt));
    }

    public SecretCrypt generateSecret(boolean persistOnDisk) throws NoSuchAlgorithmException {
        return this.addSecret(persistOnDisk, this.generateSecretKey());
    }

    public SecretCrypt generateSecretWithAliasPrefix(boolean persistOnDisk, String aliasPrefix) throws NoSuchAlgorithmException {
        return this.addSecretWithAliasPrefix(persistOnDisk, aliasPrefix, this.generateSecretKey());
    }

    public SecretCrypt generateSecret(boolean persistOnDisk, String alias) throws NoSuchAlgorithmException {
        return this.addSecret(persistOnDisk, alias, this.generateSecretKey());
    }

    public SecretCrypt addSecretWithAliasPrefix(boolean peristOnDisk, String aliasPrefix, SecretKey secretKey) throws NoSuchAlgorithmException {
        return this.addSecret(peristOnDisk, aliasPrefix + "." + this.generateSecretAlias(secretKey), secretKey);
    }

    public SecretCrypt addSecret(boolean peristOnDisk, SecretKey secretKey) throws NoSuchAlgorithmException {
        return this.addSecret(peristOnDisk, this.generateSecretAlias(secretKey), secretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretCrypt addSecret(boolean peristOnDisk, String alias, SecretKey secretKey) throws NoSuchAlgorithmException {
        try {
            KeyStore store;
            Pair<KeyStore, KeyStore.ProtectionParameter> chosenPair = this.chooseSecretStore(__ -> peristOnDisk);
            KeyStore keyStore = store = chosenPair.getLeft();
            synchronized (keyStore) {
                store.setEntry(alias, new KeyStore.SecretKeyEntry(secretKey), chosenPair.getRight());
                if (peristOnDisk && this.keyStoreWritePath != null) {
                    store.store(new FileOutputStream(this.secretStoreWritePath), this.getPassword(this.secretStoreProtection, this.secretStoreWritePath));
                }
            }
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | UnsupportedCallbackException e) {
            logger.error("Couldn't persist secret store to {} after adding secret {}. Cause: {}", (Object)this.secretStoreWritePath, (Object)alias, (Object)e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        return this.getSecretCrypt(alias, secretKey);
    }

    public SecretCrypt getSecretCrypt(String alias) throws NoSuchAlgorithmException, UnrecoverableEntryException {
        try {
            Pair<KeyStore, KeyStore.ProtectionParameter> chosenPair = this.chooseSecretStore(store -> store.containsAlias(alias));
            KeyStore.Entry entry = chosenPair.getLeft().getEntry(alias, chosenPair.getRight());
            if (entry instanceof KeyStore.SecretKeyEntry) {
                KeyStore.SecretKeyEntry secreteEntry = (KeyStore.SecretKeyEntry)entry;
                return this.getSecretCrypt(alias, secreteEntry.getSecretKey());
            }
            return null;
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    private SecretCrypt getSecretCrypt(String alias, SecretKey key) throws NoSuchAlgorithmException {
        Object macAlgorithm = this.macAlgorithm == null ? "Hmac" + this.hashAlgorithm : this.macAlgorithm;
        return this.cipherTransform == null ? new SecretCrypt(alias, key, (String)macAlgorithm, this.cipherMode, this.cipherPadding, this.cipherParameterSupplier) : new SecretCrypt(alias, key, (String)macAlgorithm, this.cipherTransform, this.cipherParameterSupplier);
    }

    private SecretKey generateSecretKey() {
        try {
            KeyGenerator gen = KeyGenerator.getInstance(this.symKeyAlgorithm);
            gen.init(this.symKeyLength, this.keyRng);
            return gen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Pair<KeyStore, KeyStore.ProtectionParameter> chooseSecretStore(KeyStorePredicate shouldBePersistent) throws KeyStoreException {
        KeyStore persistent = this.getSecretStore();
        return shouldBePersistent.test(persistent) ? Pair.of(persistent, this.secretStoreProtection) : Pair.of(this.getEphemeralSecretStore(), this.EMPTY_PWD);
    }

    private String generateSecretAlias(SecretKey key) {
        try {
            MessageDigest digest = MessageDigest.getInstance(this.hashAlgorithm);
            digest.update(key.getEncoded());
            return Base64.getEncoder().encodeToString(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private SecretKey applyPBKDF(char[] password, byte[] salt) throws InvalidKeySpecException {
        SecretKeyFactory fac;
        try {
            fac = SecretKeyFactory.getInstance(this.pbkdfAlgorithm, this.PROVIDER);
        }
        catch (NoSuchAlgorithmException e1) {
            try {
                fac = SecretKeyFactory.getInstance(this.pbkdfAlgorithm);
            }
            catch (NoSuchAlgorithmException e2) {
                throw new AssertionError((Object)e2);
            }
        }
        SecretKey pbkdfKey = fac.generateSecret(new PBEKeySpec(password, salt, this.pbkdfIterations, this.pbkdfKeyLength));
        return new SecretKeySpec(pbkdfKey.getEncoded(), this.symKeyAlgorithm);
    }

    synchronized void loadConfig(Properties config) throws InvalidParameterException {
        if (this.keyStore != null || this.ephKeyStore != null || this.trustStore != null || this.ephTrustStore != null || this.secretStore != null || this.ephSecretStore != null) {
            logger.warn("Loading configuration after one of the key stores was already loaded. This might lead to unexpected behaviour.");
        }
        this.keyStoreType = BabelSecurity.getAlgorithmParam("KeyStore", config, PAR_KEY_STORE_TYPE, this.keyStoreType);
        this.keyStoreLoadPath = config.getProperty(PAR_KEY_STORE_PATH, this.keyStoreLoadPath);
        String param = config.getProperty(PAR_KEY_STORE_WRITABLE);
        this.keyStoreWritePath = param == null || param.toUpperCase().equals("FALSE") ? null : (param.toUpperCase().equals("TRUE") ? this.keyStoreLoadPath : param);
        param = config.getProperty(PAR_KEY_STORE_PWD);
        this.keyStoreProtection = param != null ? new KeyStore.PasswordProtection(param.toCharArray()) : BabelSecurity.loadClassParam(config, PAR_KEY_STORE_PROTECTION, this.keyStoreProtection);
        param = config.getProperty(PAR_DEFAULT_ID);
        if (param != null) {
            this.idAliasMapper.setDefaultAlias(param);
        }
        this.asymKeyAlgorithm = BabelSecurity.getAlgorithmParam("KeyFactory", config, PAR_ASYM_KEY_ALG, this.asymKeyAlgorithm);
        AlgorithmParameterSpec algParamParam = BabelSecurity.loadClassParam(AlgorithmParameterSpec.class, config, PAR_ASYM_KEY_PARAMS);
        if (algParamParam == null) {
            Integer keyLenParam = BabelSecurity.getObjectParam(config, PAR_ASYM_KEY_LEN, null, Integer::parseInt);
            if (keyLenParam != null) {
                try {
                    KeyPairGenerator.getInstance(this.asymKeyAlgorithm).initialize(keyLenParam);
                }
                catch (java.security.InvalidParameterException | NoSuchAlgorithmException e) {
                    throw BabelSecurity.getConfigParamException(PAR_ASYM_KEY_LEN, keyLenParam.toString(), "Invalid parameter for asymmetric key algorithm " + this.asymKeyAlgorithm, e);
                }
                this.asymKeyParameters = null;
                this.asymKeyLength = keyLenParam;
            } else if (config.contains(PAR_ASYM_KEY_ALG)) {
                try {
                    KeyPairGenerator.getInstance(this.asymKeyAlgorithm).initialize(algParamParam);
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                    throw new InvalidParameterException("Asymmetric key algorithm was set without setting proper corresponding algorithm parameters", e);
                }
            }
        } else {
            try {
                KeyPairGenerator.getInstance(this.asymKeyAlgorithm).initialize(algParamParam);
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                throw BabelSecurity.getConfigParamException(PAR_ASYM_KEY_PARAMS, algParamParam.getClass().getName(), "Invalid parameter spec for asymmetric key algorithm " + this.asymKeyAlgorithm, e);
            }
            this.asymKeyParameters = algParamParam;
        }
        this.identityExtractor = BabelSecurity.loadClassParam(config, PAR_ID_EXTRACTOR, this.identityExtractor);
        this.identityGenerator = BabelSecurity.loadClassParam(config, PAR_ID_GENERATOR, this.identityGenerator);
        this.trustStoreType = BabelSecurity.getAlgorithmParam("KeyStore", config, PAR_TRUST_STORE_TYPE, this.keyStoreType);
        this.trustStoreLoadPath = config.getProperty(PAR_TRUST_STORE_PATH, this.trustStoreLoadPath);
        param = config.getProperty(PAR_TRUST_STORE_PWD);
        this.trustStoreProtection = param != null ? new KeyStore.PasswordProtection(param.toCharArray()) : BabelSecurity.loadClassParam(config, PAR_TRUST_STORE_PROTECTION, this.trustStoreProtection);
        param = config.getProperty(PAR_TRUST_STORE_WRITABLE);
        this.trustStoreWritePath = param == null || param.toUpperCase().equals("FALSE") ? null : (param.toUpperCase().equals("TRUE") ? this.trustStoreLoadPath : param);
        this.trustManagerPolicy = BabelSecurity.getObjectParamUpperCase(config, PAR_TRUST_MANAGER_POLICY, this.trustManagerPolicy, X509BabelTrustManager.TrustPolicy::valueOf);
        this.trustManagerSaveEncountered = BabelSecurity.getObjectParam(config, PAR_TRUST_MANAGER_SAVE_ENCOUNTERED, this.trustManagerSaveEncountered, Boolean::valueOf);
        if (this.trustManagerSaveEncountered) {
            this.trustManagerPersistCerts = BabelSecurity.getObjectParam(config, PAR_TRUST_MANAGER_PERSIST_DISCOVERED_CERTS, this.trustManagerPersistCerts, Boolean::valueOf);
        }
        this.trustManagerUknownPeerCallback = BabelSecurity.loadClassParam(config, PAR_TRUST_MANAGER_UNKNOWN_PEER_CALLBACK, this.trustManagerUknownPeerCallback);
        this.trustManagerVerifySignatureCallback = BabelSecurity.loadClassParam(config, PAR_TRUST_MANAGER_VERIFY_SIGNATURE_CALLBACK, this.trustManagerVerifySignatureCallback);
        this.secretStoreType = BabelSecurity.getAlgorithmParam("KeyStore", config, PAR_SECRET_STORE_TYPE, this.keyStoreType);
        this.secretStoreLoadPath = config.getProperty(PAR_SECRET_STORE_PATH, this.secretStoreLoadPath);
        param = config.getProperty(PAR_SECRET_STORE_PWD);
        this.secretStoreProtection = param != null ? new KeyStore.PasswordProtection(param.toCharArray()) : BabelSecurity.loadClassParam(config, PAR_SECRET_STORE_PROTECTION, this.secretStoreProtection);
        param = config.getProperty(PAR_SECRET_STORE_WRITABLE);
        this.secretStoreWritePath = param == null || param.toUpperCase().equals("FALSE") ? null : (param.toUpperCase().equals("TRUE") ? this.secretStoreLoadPath : param);
        this.symKeyAlgorithm = BabelSecurity.getAlgorithmParam("SecretKeyFactory", config, PAR_SYM_KEY_ALG, this.symKeyAlgorithm);
        this.symKeyLength = BabelSecurity.getObjectParam(config, PAR_SYM_KEY_LEN, this.symKeyLength, Integer::parseInt);
        this.pbkdfAlgorithm = BabelSecurity.getAlgorithmParam("SecretKeyFactory", config, PAR_PBKDF_ALG, this.pbkdfAlgorithm);
        this.pbkdfSalt = BabelSecurity.getObjectParam(config, PAR_PBKDF_SALT, this.pbkdfSalt, Base64.getDecoder()::decode);
        this.pbkdfIterations = BabelSecurity.getObjectParam(config, PAR_PBKDF_ITERATIONS, this.pbkdfIterations, Integer::parseInt);
        this.pbkdfKeyLength = BabelSecurity.getObjectParam(config, PAR_PBKDF_KEY_LEN, this.pbkdfKeyLength, Integer::parseInt);
        param = config.getProperty(PAR_PBKDF_PWD);
        if (param != null) {
            try {
                this.generateSecretFromPassword(false, STARTUP_PWD_DERIVED_KEY_ALIAS, param);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new InvalidParameterException("babel.password_derived: Couldn't generate secret from password in config.", e);
            }
        }
        if ((param = config.getProperty(PAR_HASH_ALG)) != null) {
            try {
                MessageDigest.getInstance(param);
            }
            catch (NoSuchAlgorithmException e) {
                throw BabelSecurity.getConfigParamException(PAR_HASH_ALG, param, "No such algorithm available for MessageDigest.", e);
            }
            this.hashAlgorithm = param;
        }
        this.macAlgorithm = BabelSecurity.getAlgorithmParam("Mac", config, PAR_MAC_ALG);
        this.cipherTransform = BabelSecurity.getAlgorithmParam("Cipher", config, PAR_CIPHER_TRANSFORM);
        if (this.cipherTransform == null) {
            boolean changed = false;
            param = config.getProperty(PAR_CIPHER_MODE);
            if (param != null) {
                changed = true;
                this.cipherMode = param;
            }
            if ((param = config.getProperty(PAR_CIPHER_PADDING)) != null) {
                changed = true;
                this.cipherPadding = param;
            }
            if (changed) {
                boolean modeFound = false;
                boolean paddingFound = false;
                for (String algorithm : Security.getAlgorithms("Cipher")) {
                    if (!modeFound && algorithm.contains("/" + this.cipherMode + "/")) {
                        if (paddingFound) break;
                        modeFound = true;
                    }
                    if (paddingFound || !algorithm.endsWith("/" + this.cipherPadding)) continue;
                    if (modeFound) break;
                    paddingFound = true;
                }
                if (!modeFound) {
                    throw BabelSecurity.getConfigParamException(PAR_CIPHER_MODE, this.cipherMode, "No such cipher mode available.", null);
                }
                if (!paddingFound) {
                    throw BabelSecurity.getConfigParamException(PAR_CIPHER_PADDING, this.cipherPadding, "No such cipher padding available.", null);
                }
            }
        }
        if (config.contains(PAR_CIPHER_PARAM_SUPPLIER)) {
            this.cipherParameterSupplier = (Supplier)BabelSecurity.loadClassParam((Class)null, config, PAR_CIPHER_PARAM_SUPPLIER);
        } else {
            Integer ivSize = BabelSecurity.getObjectParam(config, PAR_CIPHER_IV_SIZE, null, Integer::parseInt);
            if (ivSize != null) {
                this.cipherParameterSupplier = () -> new IvParameterSpec(this.generateIv(ivSize));
            }
        }
    }

    private static InvalidParameterException getConfigParamException(String param, String value, String explanation, Throwable cause) {
        String msg = "%s: Invalid value \"%s\"".formatted(param, value) + (String)(explanation == null ? "." : ": " + explanation);
        return cause == null ? new InvalidParameterException(msg) : new InvalidParameterException(msg, cause);
    }

    private static <T> T loadClassParam(Class<T> clazz, Properties props, String key) throws InvalidParameterException {
        return BabelSecurity.loadClassParam(props, key, null);
    }

    private static <T> T loadClassParam(Properties props, String key, T defaultValue) throws InvalidParameterException {
        String className = props.getProperty(key);
        if (className == null) {
            return defaultValue;
        }
        try {
            return (T)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw BabelSecurity.getConfigParamException(key, className, null, e);
        }
    }

    private static <T> T getObjectParam(Properties props, String key, T defaultValue, Function<String, T> parser) throws InvalidParameterException {
        String param = props.getProperty(key);
        return param != null ? parser.apply(param) : defaultValue;
    }

    private static <T> T getObjectParamUpperCase(Properties props, String key, T defaultValue, Function<String, T> parser) throws InvalidParameterException {
        String param = props.getProperty(key);
        try {
            return param != null ? parser.apply(param.toUpperCase()) : defaultValue;
        }
        catch (Exception e) {
            throw BabelSecurity.getConfigParamException(key, param, "Failed to parse Object", e);
        }
    }

    private static String getAlgorithmParam(String service, Properties props, String key) throws InvalidParameterException {
        String alg = props.getProperty(key);
        if (alg != null) {
            alg = alg.toUpperCase();
            if (!Security.getAlgorithms(service).contains(alg)) {
                throw BabelSecurity.getConfigParamException(key, alg, "No such algorithm available for " + service, null);
            }
        }
        return alg;
    }

    private static String getAlgorithmParam(String service, Properties props, String key, String defaultValue) throws InvalidParameterException {
        String alg = props.getProperty(key, defaultValue).toUpperCase();
        if (!Security.getAlgorithms(service).contains(alg)) {
            throw BabelSecurity.getConfigParamException(key, alg, "No such algorithm available for " + service, null);
        }
        return alg;
    }

    @FunctionalInterface
    private static interface KeyStorePredicate {
        public boolean test(KeyStore var1) throws KeyStoreException;
    }
}

