/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.adaptive;

import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.adaptive.AdaptiveProtocol;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.DecreaseNumberNeighbors;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.GetAdaptiveFieldsReply;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.IncreaseNumberNeighbors;
import pt.unl.fct.di.novasys.babel.core.adaptive.timers.DiameterTimer;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.internal.InternalEvent;

public abstract class AdaptiveMembershipProtocol
extends AdaptiveProtocol {
    private static final Logger logger = LogManager.getLogger(AdaptiveMembershipProtocol.class);
    public static final String NUMBER_OF_NEIGHBORS = "Number of Neighbors";

    public AdaptiveMembershipProtocol(String protoName, short protoId) throws HandlerRegistrationException {
        super(protoName, protoId);
        this.initialize();
    }

    public AdaptiveMembershipProtocol(String protoName, short protoId, BlockingQueue<InternalEvent> policy) throws HandlerRegistrationException {
        super(protoName, protoId, policy);
        this.initialize();
    }

    private void initialize() throws HandlerRegistrationException {
        this.subscribeNotifications();
        this.setupPeriodicTimer(new DiameterTimer(), 1000L, 10000L);
    }

    @Override
    protected GetAdaptiveFieldsReply.GetAdaptiveFieldsReplyBuilder getPopulatedAdaptiveFieldBuilder() {
        GetAdaptiveFieldsReply.GetAdaptiveFieldsReplyBuilder builder = super.getPopulatedAdaptiveFieldBuilder();
        builder.addField(NUMBER_OF_NEIGHBORS, this.getCurrentNeighborsSize());
        return builder;
    }

    @Override
    protected void registerRequestsHandlers() throws HandlerRegistrationException {
        super.registerRequestsHandlers();
        this.registerRequestHandler((short)702, this::uponIncreaseNumberNeighbors);
        this.registerRequestHandler((short)703, this::uponDecreaseNumberNeighbors);
    }

    private final void subscribeNotifications() throws HandlerRegistrationException {
    }

    protected abstract void uponIncreaseNumberNeighbors(IncreaseNumberNeighbors var1, short var2);

    protected abstract void uponDecreaseNumberNeighbors(DecreaseNumberNeighbors var1, short var2);

    protected abstract long getCurrentNeighborsSize();
}

