/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.adaptive.messages;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.javatuples.Pair;
import pt.unl.fct.di.novasys.babel.core.adaptive.AdaptiveProtocol;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;

public class ReconfigureMessage
extends ProtoMessage {
    private static final Logger logger = LogManager.getLogger(ReconfigureMessage.class);
    public static final short MSG_CODE = 801;
    private final Map<String, Pair<Class<?>, Object>> props;
    public static final ISerializer<ReconfigureMessage> serializer = new ISerializer<ReconfigureMessage>(){
        private static Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Pair.class), new PairTypeAdapter()).create();

        @Override
        public void serialize(ReconfigureMessage m4, ByteBuf out) throws IOException {
            logger.debug("Serializing ReconfigureMessage with {} entries", (Object)m4.props.size());
            int sizeInBytes = 4;
            Iterator<Map.Entry<String, Pair<Class<?>, Object>>> it = m4.props.entrySet().iterator();
            out.writeInt(m4.props.size());
            while (it.hasNext()) {
                Map.Entry<String, Pair<Class<?>, Object>> entry = it.next();
                byte[] keyBytes = entry.getKey().getBytes();
                out.writeInt(keyBytes.length);
                out.writeBytes(keyBytes);
                byte[] jsonBytes = gson.toJson((Object)entry.getValue(), (Type)((Object)Pair.class)).getBytes();
                out.writeInt(jsonBytes.length);
                out.writeBytes(jsonBytes);
                sizeInBytes += 4 + keyBytes.length + 4 + jsonBytes.length;
            }
            logger.debug("Serialized message size: {}", (Object)sizeInBytes);
        }

        @Override
        public ReconfigureMessage deserialize(ByteBuf in) throws IOException {
            int size = in.readInt();
            logger.debug("Deserializing ReconfigureMessage with {} entries", (Object)size);
            ReconfigureMessageBuilder builder = new ReconfigureMessageBuilder();
            for (int i = 0; i < size; ++i) {
                byte[] keyBytes = new byte[in.readInt()];
                in.readBytes(keyBytes);
                String key = new String(keyBytes);
                byte[] jsonBytes = new byte[in.readInt()];
                in.readBytes(jsonBytes);
                String json = new String(jsonBytes);
                Pair valuePair = gson.fromJson(json, Pair.class);
                builder.addProperty(key, valuePair);
                logger.debug("Deserialized key: {} value: {} Type: {}", (Object)key, valuePair.getValue1(), (Object)((Class)valuePair.getValue0()).getCanonicalName());
            }
            return builder.build();
        }

        static class PairTypeAdapter
        implements JsonSerializer<Pair<Class<?>, Object>>,
        JsonDeserializer<Pair<Class<?>, Object>> {
            private static final String CLASS_META_KEY = "type";
            private static final String OBJECT_DATA_KEY = "value";

            PairTypeAdapter() {
            }

            @Override
            public JsonElement serialize(Pair<Class<?>, Object> src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty(CLASS_META_KEY, src.getValue0().getCanonicalName());
                jsonObject.add(OBJECT_DATA_KEY, context.serialize(src.getValue1()));
                return jsonObject;
            }

            @Override
            public Pair<Class<?>, Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                String className = jsonObject.get(CLASS_META_KEY).getAsString();
                try {
                    Class<?> clazz = Class.forName(className);
                    logger.debug("Deserializing object of type {}", (Object)className);
                    return new Pair(clazz, context.deserialize(jsonObject.get(OBJECT_DATA_KEY), clazz));
                }
                catch (ClassNotFoundException e) {
                    logger.error("Failed to deserialize object of type {}", (Object)className);
                    throw new JsonParseException(e);
                }
            }
        }
    };

    public ReconfigureMessage(Map<String, Pair<Class<?>, Object>> props) {
        super((short)801);
        this.props = props;
    }

    public String toString() {
        Object ret = "Reconfiguration of parameters: ";
        for (String o : this.props.keySet()) {
            ret = " " + o + ": " + String.valueOf(this.props.get(o));
        }
        return ret;
    }

    public Iterator<Map.Entry<String, Object>> iterator() {
        return new Iterator<Map.Entry<String, Object>>(){
            private Iterator<Map.Entry<String, Pair<Class<?>, Object>>> it;
            {
                this.it = ReconfigureMessage.this.props.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                final Map.Entry<String, Pair<Class<?>, Object>> entry = this.it.next();
                return new Map.Entry<String, Object>(){

                    @Override
                    public String getKey() {
                        return (String)entry.getKey();
                    }

                    @Override
                    public Object getValue() {
                        Pair pair = (Pair)entry.getValue();
                        return ((Class)pair.getValue0()).cast(pair.getValue1());
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static class ReconfigureMessageBuilder {
        private Map<String, Pair<Class<?>, Object>> props = new HashMap();

        public ReconfigureMessageBuilder addProperty(String name, Object value) {
            this.props.put(name, new Pair(AdaptiveProtocol.typeOrWrapper(value.getClass()), value));
            return this;
        }

        public ReconfigureMessageBuilder addProperty(String name, Class<?> clazz, Object value) {
            this.props.put(name, new Pair(clazz, value));
            return this;
        }

        public ReconfigureMessageBuilder addProperty(String name, Pair<Class<?>, Object> value) {
            this.props.put(name, value);
            return this;
        }

        public ReconfigureMessage build() {
            return new ReconfigureMessage(this.props);
        }
    }
}

