/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.discovery;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.LocalDiscoveryProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;

public class BroadcastDiscoveryProtocol
extends LocalDiscoveryProtocol {
    private static final Logger logger = LogManager.getLogger(BroadcastDiscoveryProtocol.class);
    public static final int DEFAULT_PORT = 1025;
    public static final int ANOUNCEMENT_COOLDOWN = 1000;
    public static final short PROTO_ID = 32700;
    public static final String PROTO_NAME = "BabelBroadcastDiscovery";
    public static final String PAR_DISCOVERY_BROADCAST_INTERFACE = "babel.discovery.broadcast.interface";
    public static final String PAR_DISCOVERY_BROADCAST_PORT = "babel.discovery.broadcast.port";
    private int bcastPort;
    private Thread listeningThread;

    public BroadcastDiscoveryProtocol() throws IOException, HandlerRegistrationException {
        super(PROTO_NAME, (short)32700);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        super.init(props);
        if (!props.containsKey(PAR_DISCOVERY_BROADCAST_INTERFACE) && props.containsKey("babel.interface")) {
            props.put(PAR_DISCOVERY_BROADCAST_INTERFACE, props.get("babel.interface"));
        }
        this.bcastPort = 1025;
        if (props.containsKey(PAR_DISCOVERY_BROADCAST_PORT)) {
            this.bcastPort = Integer.parseInt(props.getProperty(PAR_DISCOVERY_BROADCAST_PORT));
        }
        HashSet<NetworkInterface> broadcastInterfaces = new HashSet<NetworkInterface>();
        if (!props.containsKey(PAR_DISCOVERY_BROADCAST_INTERFACE)) {
            Enumeration<NetworkInterface> iterator = NetworkInterface.getNetworkInterfaces();
            while (iterator.hasMoreElements()) {
                NetworkInterface n = iterator.nextElement();
                if (n.isLoopback() || n.isVirtual() || !n.isUp()) continue;
                broadcastInterfaces.add(n);
            }
        } else {
            broadcastInterfaces.add(NetworkInterface.getByName(props.getProperty(PAR_DISCOVERY_BROADCAST_INTERFACE)));
        }
        for (NetworkInterface n : broadcastInterfaces) {
            for (InterfaceAddress a : n.getInterfaceAddresses()) {
                if (!(a.getBroadcast() instanceof Inet4Address)) continue;
                this.addInetSocketAddress(a.getBroadcast(), this.bcastPort);
            }
        }
        if (!this.hasSocketAddresses()) {
            throw new RuntimeException("No available broadcast address in network interface");
        }
        InetAddress address = Inet4Address.getByName("0.0.0.0");
        DatagramSocket socket = this.setSocket(address, this.bcastPort, true);
        logger.info("BroadcastDiscoveryProtocol set up");
        this.listeningThread = new Thread(() -> this.listen(socket));
        this.listeningThread.start();
        logger.info("DiscoveryProtocol initialized");
    }
}

