/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;

public class ParameterMessage
extends ProtoMessage {
    public static final short MSG_ID = 10604;
    public static final byte PROTO_SEPARATOR = 30;
    public static final char PROTO_AND_PARAM_SEPARATOR = ';';
    public static final char PARAM_AND_PARAM_SEPARATOR = ',';
    public static final char PARAM_AND_VALUE_SEPARATOR = ':';
    private final Map<String, Map<String, String>> protoParam;
    public static final ISerializer<ParameterMessage> serializer = new ISerializer<ParameterMessage>(){

        @Override
        public ParameterMessage deserialize(ByteBuf in) throws IOException {
            HashMap<String, Map<String, String>> protoParam = new HashMap<String, Map<String, String>>();
            byte[] tmpBuf = new byte[in.readableBytes()];
            String currentProto = null;
            HashMap<String, String> currentMapping = null;
            String currentParam = null;
            String paramValue = null;
            int idx = 0;
            while (in.readableBytes() > 0) {
                byte readByte = in.readByte();
                tmpBuf[idx++] = readByte;
                if (readByte == 30) {
                    idx = 0;
                    currentProto = null;
                    currentParam = null;
                    paramValue = null;
                    currentMapping = null;
                    continue;
                }
                if (readByte == 59) {
                    currentProto = new String(tmpBuf, 0, idx - 1, StandardCharsets.UTF_8);
                    currentMapping = (HashMap<String, String>)protoParam.get(currentProto);
                    if (currentMapping == null) {
                        currentMapping = new HashMap<String, String>();
                        protoParam.put(currentProto, currentMapping);
                    }
                    idx = 0;
                    continue;
                }
                if (readByte == 44) {
                    if (idx == 1) {
                        idx = 0;
                    } else if (currentParam == null) {
                        currentParam = new String(tmpBuf, 0, idx - 1, StandardCharsets.UTF_8);
                        currentMapping.put(currentParam, null);
                    } else {
                        paramValue = new String(tmpBuf, 0, idx - 1, StandardCharsets.UTF_8);
                        currentMapping.put(currentParam, paramValue);
                    }
                    currentParam = null;
                    paramValue = null;
                    idx = 0;
                    continue;
                }
                if (readByte != 58) continue;
                currentParam = new String(tmpBuf, 0, idx - 1, StandardCharsets.UTF_8);
                idx = 0;
            }
            return new ParameterMessage(protoParam);
        }

        @Override
        public void serialize(ParameterMessage msg, ByteBuf out) throws IOException {
            for (Map.Entry<String, Map<String, String>> protoEntry : msg.getAllProtocolParams().entrySet()) {
                byte[] serializedProtoName = protoEntry.getKey().getBytes(StandardCharsets.UTF_8);
                out.writeByte(30);
                out.writeBytes(serializedProtoName);
                out.writeByte(59);
                for (Map.Entry<String, String> paramEntry : protoEntry.getValue().entrySet()) {
                    out.writeByte(44);
                    byte[] serializedParamName = paramEntry.getKey().getBytes(StandardCharsets.UTF_8);
                    out.writeBytes(serializedParamName);
                    String value = paramEntry.getValue();
                    if (value == null) continue;
                    out.writeByte(58);
                    byte[] serializedValue = paramEntry.getValue().getBytes(StandardCharsets.UTF_8);
                    out.writeBytes(serializedValue);
                }
                out.writeByte(44);
            }
        }
    };

    public ParameterMessage() {
        this(new HashMap<String, Map<String, String>>());
    }

    public ParameterMessage(Map<String, Map<String, String>> protoParam) {
        super((short)10604);
        this.protoParam = protoParam;
    }

    public void addParameter(String protoName, String paramName, String value) {
        Map<String, String> paramValueMap = this.protoParam.get(protoName);
        if (paramValueMap == null) {
            paramValueMap = new HashMap<String, String>();
            this.protoParam.put(protoName, paramValueMap);
        }
        paramValueMap.put(paramName, value);
    }

    public void addAskingParameter(String protoName, String paramName) {
        this.addParameter(protoName, paramName, null);
    }

    public void join(ParameterMessage msg) {
        this.protoParam.putAll(msg.getAllProtocolParams());
    }

    public Map<String, String> getProtocolParams(String protoName) {
        return Collections.unmodifiableMap(this.protoParam.get(protoName));
    }

    public Map<String, Map<String, String>> getAllProtocolParams() {
        return Collections.unmodifiableMap(this.protoParam);
    }
}

