/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.security;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Set;
import pt.unl.fct.di.novasys.babel.core.BabelSecurity;

public class IdentityCrypt {
    private final String alias;
    private final byte[] id;
    private final PrivateKey privKey;
    private final PublicKey pubKey;
    private final Certificate[] certChain;
    private final String signatureAlgorithm;
    private static final BabelSecurity babelSecurity = BabelSecurity.getInstance();

    public IdentityCrypt(String alias, byte[] id, PrivateKey privKey, PublicKey pubKey, Certificate[] certChain, String signatureHashOrAlgorithm) throws NoSuchAlgorithmException {
        this.alias = alias;
        this.id = id;
        this.privKey = privKey;
        this.pubKey = pubKey;
        this.certChain = certChain;
        Set<String> algorithms = Security.getAlgorithms("Signature");
        String string = this.signatureAlgorithm = algorithms.contains(signatureHashOrAlgorithm.toUpperCase()) ? signatureHashOrAlgorithm : signatureHashOrAlgorithm + "WITH" + privKey.getAlgorithm();
        if (!algorithms.contains(this.signatureAlgorithm.toUpperCase())) {
            throw new NoSuchAlgorithmException("Signature hash or algorithm not available: " + signatureHashOrAlgorithm);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public byte[] getIdentity() {
        return this.id;
    }

    public PrivateKey getPrivateKey() {
        return this.privKey;
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public String getKeysAlgorithm() {
        assert (this.pubKey.getAlgorithm() == this.privKey.getAlgorithm());
        return this.privKey.getAlgorithm();
    }

    public Certificate[] getCertChain() {
        return this.certChain;
    }

    public byte[] sign(byte[] ... data) throws InvalidKeyException, SignatureException {
        Signature sig = this.initSignature();
        for (byte[] part : data) {
            sig.update(part);
        }
        return sig.sign();
    }

    public byte[] sign(ByteBuffer data) throws InvalidKeyException, SignatureException {
        Signature sig = this.initSignature();
        sig.update(data);
        return sig.sign();
    }

    public byte[] sign(String algorithm, byte[] ... data) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Signature sig = this.initSignature(algorithm);
        for (byte[] part : data) {
            sig.update(part);
        }
        return sig.sign();
    }

    public byte[] sign(String algorithm, ByteBuffer data) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Signature sig = this.initSignature(algorithm);
        sig.update(data);
        return sig.sign();
    }

    public Signature initSignature() throws InvalidKeyException {
        try {
            return this.initSignature(this.signatureAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Signature initSignature(String algorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        Signature sig;
        try {
            sig = Signature.getInstance(algorithm, IdentityCrypt.babelSecurity.PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            sig = Signature.getInstance(algorithm);
        }
        sig.initSign(this.privKey);
        return sig;
    }
}

