/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang3.tuple.Pair;
import pt.unl.fct.di.novasys.babel.core.BabelSecurity;
import pt.unl.fct.di.novasys.babel.core.security.CipherData;

public class SecretCrypt {
    private final String alias;
    private final SecretKey key;
    private final String macAlgorithm;
    private final String cipherTransform;
    private final Supplier<AlgorithmParameterSpec> cipherParamSupplier;
    private static final BabelSecurity babelSecurity = BabelSecurity.getInstance();

    public SecretCrypt(String alias, SecretKey key, String macAlgorithm, String cipherMode, String cipherPadding, Supplier<AlgorithmParameterSpec> cipherParamSupplier) throws NoSuchAlgorithmException {
        this(alias, key, macAlgorithm, "%s/%s/%s".formatted(key.getAlgorithm(), cipherMode, cipherPadding), cipherParamSupplier);
    }

    public SecretCrypt(String alias, SecretKey key, String macAlgorithm, String cipherTransform, Supplier<AlgorithmParameterSpec> cipherParamSupplier) throws NoSuchAlgorithmException {
        this.alias = alias;
        this.key = key;
        this.macAlgorithm = macAlgorithm;
        this.cipherParamSupplier = cipherParamSupplier;
        Set<String> algorithms = Security.getAlgorithms("Cipher");
        String string = this.cipherTransform = algorithms.contains(cipherTransform.toUpperCase()) ? cipherTransform : key.getAlgorithm();
        if (!algorithms.contains(cipherTransform.toUpperCase())) {
            throw new NoSuchAlgorithmException("Cipher algorithm not available: " + cipherTransform);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public SecretKey getKey() {
        return this.key;
    }

    public byte[] mac(byte[] ... data) throws InvalidKeyException {
        Mac mac = this.initMac();
        Arrays.stream(data).forEach(mac::update);
        return this.initMac().doFinal();
    }

    public byte[] mac(ByteBuffer data) throws InvalidKeyException {
        Mac mac = this.initMac();
        mac.update(data);
        return mac.doFinal();
    }

    public byte[] mac(String algorithm, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = this.initMac(algorithm);
        Arrays.stream(data).forEach(mac::update);
        return this.initMac(algorithm).doFinal();
    }

    public byte[] mac(String algorithm, ByteBuffer data) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = this.initMac(algorithm);
        mac.update(data);
        return mac.doFinal();
    }

    public byte[] mac(String algorithm, AlgorithmParameterSpec params, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        Mac mac = this.initMac(algorithm, params);
        Arrays.stream(data).forEach(mac::update);
        return mac.doFinal();
    }

    public byte[] mac(String algorithm, AlgorithmParameterSpec params, ByteBuffer data) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        Mac mac = this.initMac(algorithm, params);
        mac.update(data);
        return mac.doFinal();
    }

    public Mac initMac() throws InvalidKeyException {
        try {
            return this.initMac(this.macAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Mac initMac(String algorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac mac;
        try {
            mac = Mac.getInstance(algorithm, SecretCrypt.babelSecurity.PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            mac = Mac.getInstance(algorithm);
        }
        mac.init(this.key);
        return mac;
    }

    public Mac initMac(String algorithm, AlgorithmParameterSpec params) throws InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Mac mac;
        try {
            mac = Mac.getInstance(algorithm, SecretCrypt.babelSecurity.PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            mac = Mac.getInstance(algorithm);
        }
        mac.init(this.key, params);
        return mac;
    }

    public byte[] decrypt(byte[] data, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.initDecryptCipher(iv).doFinal(data);
    }

    public int decrypt(ByteBuffer in, ByteBuffer out, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.initDecryptCipher(iv).doFinal(in, out);
    }

    public byte[] decrypt(byte[] data, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.initDecryptCipher(params).doFinal(data);
    }

    public int decrypt(ByteBuffer in, ByteBuffer out, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.initDecryptCipher(params).doFinal(in, out);
    }

    public byte[] decrypt(byte[] data, String transformation, AlgorithmParameterSpec params) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException {
        return this.initDecryptCipher(transformation, params).doFinal(data);
    }

    public int decrypt(ByteBuffer in, ByteBuffer out, String transformation, AlgorithmParameterSpec params) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException {
        return this.initDecryptCipher(transformation, params).doFinal(in, out);
    }

    public CipherInputStream getDecryptionStream(ByteArrayInputStream in, byte[] iv) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        return new CipherInputStream(in, this.initDecryptCipher(iv));
    }

    public CipherInputStream getDecryptionStream(ByteArrayInputStream in, AlgorithmParameterSpec params) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        return new CipherInputStream(in, this.initDecryptCipher(params));
    }

    public CipherInputStream getDecryptionStream(ByteArrayInputStream in, String transformation, byte[] iv) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException {
        return new CipherInputStream(in, this.initDecryptCipher(transformation, iv));
    }

    public CipherInputStream getDecryptionStream(ByteArrayInputStream in, String transformation, AlgorithmParameterSpec params) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException {
        return new CipherInputStream(in, this.initDecryptCipher(transformation, params));
    }

    public Cipher initDecryptCipher(byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return this.initDecryptCipher(new IvParameterSpec(iv));
    }

    public Cipher initDecryptCipher(AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            return this.initDecryptCipher(this.cipherTransform, params);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Cipher initDecryptCipher(String transformation, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        return this.initDecryptCipher(transformation, new IvParameterSpec(iv));
    }

    public Cipher initDecryptCipher(String transformation, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(transformation, SecretCrypt.babelSecurity.PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            cipher = Cipher.getInstance(transformation);
        }
        cipher.init(2, (Key)this.key, params);
        return cipher;
    }

    public CipherData encrypt(byte[] data) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException {
        try {
            Cipher cipher = this.initEncryptCipher();
            byte[] cipherText = cipher.doFinal(data);
            return new CipherData(cipherText, cipher.getParameters());
        }
        catch (BadPaddingException never) {
            throw new AssertionError((Object)never);
        }
    }

    public AlgorithmParameters encrypt(ByteBuffer in, ByteBuffer out) throws InvalidKeyException, InvalidAlgorithmParameterException, ShortBufferException, IllegalBlockSizeException {
        try {
            Cipher cipher = this.initEncryptCipher();
            cipher.doFinal(in, out);
            return cipher.getParameters();
        }
        catch (BadPaddingException never) {
            throw new AssertionError((Object)never);
        }
    }

    public CipherData encrypt(byte[] data, String transformation, AlgorithmParameterSpec params) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException {
        try {
            Cipher cipher = this.initEncryptCipher();
            byte[] cipherText = cipher.doFinal(data);
            return new CipherData(cipherText, cipher.getParameters());
        }
        catch (BadPaddingException never) {
            throw new AssertionError((Object)never);
        }
    }

    public AlgorithmParameters encrypt(ByteBuffer in, ByteBuffer out, String transformation, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException, ShortBufferException, IllegalBlockSizeException {
        try {
            Cipher cipher = this.initEncryptCipher(transformation, params);
            cipher.doFinal(in, out);
            return cipher.getParameters();
        }
        catch (BadPaddingException never) {
            throw new AssertionError((Object)never);
        }
    }

    public Pair<CipherOutputStream, AlgorithmParameters> getEncryptionStream(ByteArrayOutputStream out) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = this.initEncryptCipher();
        return Pair.of(new CipherOutputStream(out, cipher), cipher.getParameters());
    }

    public Pair<CipherOutputStream, AlgorithmParameters> getEncryptionStream(ByteArrayOutputStream out, String transformation, AlgorithmParameterSpec params) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptCipher(transformation, params);
        return Pair.of(new CipherOutputStream(out, cipher), cipher.getParameters());
    }

    public Cipher initEncryptCipher() throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            return this.initEncryptCipher(this.cipherTransform, this.cipherParamSupplier.get());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Cipher initEncryptCipher(String transformation, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        return this.initEncryptCipher(transformation, new IvParameterSpec(iv));
    }

    public Cipher initEncryptCipher(String transformation, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(transformation, SecretCrypt.babelSecurity.PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            cipher = Cipher.getInstance(transformation);
        }
        cipher.init(1, (Key)this.key, params);
        return cipher;
    }
}

