/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.internal;

import java.util.Optional;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.babel.internal.InternalEvent;
import pt.unl.fct.di.novasys.babel.internal.security.PeerIdEncoder;
import pt.unl.fct.di.novasys.network.data.Host;

public class MessageFailedEvent
extends InternalEvent {
    private final BabelMessage msg;
    private final Host to;
    private final Optional<byte[]> toId;
    private final Throwable cause;
    private final int channelId;

    public MessageFailedEvent(BabelMessage msg, Host to, Throwable cause, int channelId) {
        this(msg, to, null, cause, channelId);
    }

    public MessageFailedEvent(BabelMessage msg, Host to, byte[] toId, Throwable cause, int channelId) {
        super(InternalEvent.EventType.MESSAGE_FAILED_EVENT);
        this.msg = msg;
        this.to = to;
        this.toId = Optional.ofNullable(toId);
        this.cause = cause;
        this.channelId = channelId;
    }

    public String toString() {
        return "MessageFailedEvent{msg=" + String.valueOf(this.msg) + ", to=" + String.valueOf(this.to) + this.toId.map(id -> ", toId=" + PeerIdEncoder.encodeToString(id)).orElse("") + ", cause=" + String.valueOf(this.cause) + ", channelId=" + this.channelId + "}";
    }

    public final Host getTo() {
        return this.to;
    }

    public final Optional<byte[]> getToId() {
        return this.toId;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public BabelMessage getMsg() {
        return this.msg;
    }
}

