/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.internal;

import java.util.Optional;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.babel.internal.InternalEvent;
import pt.unl.fct.di.novasys.babel.internal.security.PeerIdEncoder;
import pt.unl.fct.di.novasys.network.data.Host;

public class MessageInEvent
extends InternalEvent {
    private final BabelMessage msg;
    private final Host from;
    private final Optional<byte[]> fromId;
    private final int channelId;

    public MessageInEvent(BabelMessage msg, Host from, int channelId) {
        this(msg, from, null, channelId);
    }

    public MessageInEvent(BabelMessage msg, Host from, byte[] fromId, int channelId) {
        super(InternalEvent.EventType.MESSAGE_IN_EVENT);
        this.from = from;
        this.msg = msg;
        this.fromId = Optional.ofNullable(fromId);
        this.channelId = channelId;
    }

    public String toString() {
        return "MessageInEvent{msg=" + String.valueOf(this.msg) + ", from=" + String.valueOf(this.from) + this.fromId.map(id -> ", fromId=" + PeerIdEncoder.encodeToString(id)).orElse("") + ", channelId=" + this.channelId + "}";
    }

    public final Host getFrom() {
        return this.from;
    }

    public final Optional<byte[]> getFromId() {
        return this.fromId;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public BabelMessage getMsg() {
        return this.msg;
    }
}

