/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.internal.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.security.IdFromCertExtractor;
import pt.unl.fct.di.novasys.babel.core.security.IdentityPair;
import pt.unl.fct.di.novasys.network.data.Bytes;

public class IdAliasMapper {
    private static final Logger logger = LogManager.getLogger(IdAliasMapper.class);
    private final Map<String, byte[]> aliasToId = new ConcurrentHashMap<String, byte[]>();
    private final Map<Bytes, String> idToAlias = new ConcurrentHashMap<Bytes, String>();
    private String defaultAlias;

    public IdAliasMapper() {
    }

    public IdAliasMapper(String defaultAlias) {
        this();
        this.defaultAlias = defaultAlias;
    }

    public IdAliasMapper(String defaultAlias, byte[] defaultId) {
        this();
        this.putDefault(defaultAlias, defaultId);
    }

    public synchronized IdAliasMapper populateFromPrivateKeyStore(KeyStore keyStore, KeyStore.ProtectionParameter protParam, IdFromCertExtractor idExtractor) throws KeyStoreException {
        Iterator<String> it = keyStore.aliases().asIterator();
        while (it.hasNext()) {
            String alias = it.next();
            try {
                KeyStore.Entry entry = keyStore.getEntry(alias, protParam);
                if (!(entry instanceof KeyStore.PrivateKeyEntry)) continue;
                KeyStore.PrivateKeyEntry privEntry = (KeyStore.PrivateKeyEntry)entry;
                byte[] id = idExtractor.extractIdentity(privEntry.getCertificateChain()[0]);
                this.put(alias, id);
            }
            catch (NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
                logger.error("Couldn't read entry with alias. Ignoring. Cause: {}", (Object)alias, (Object)e);
            }
        }
        return this;
    }

    public String getAlias(byte[] id) {
        return id == null ? null : this.idToAlias.get(Bytes.of(id));
    }

    public byte[] getId(String alias) {
        return alias == null ? null : this.aliasToId.get(alias);
    }

    public String getDefaultAlias() {
        return this.defaultAlias;
    }

    public byte[] getDefaultId() {
        return this.getId(this.defaultAlias);
    }

    public IdentityPair getDefault() {
        return this.defaultAlias == null ? null : new IdentityPair(this.defaultAlias, this.getId(this.defaultAlias));
    }

    public synchronized String setDefaultAlias(String alias) {
        String old = this.defaultAlias;
        this.defaultAlias = alias;
        return old;
    }

    public synchronized void putDefault(String alias, byte[] id) {
        this.defaultAlias = alias;
        if (alias != null && id != null) {
            this.idToAlias.put(Bytes.of(id), alias);
            this.aliasToId.put(alias, id);
        }
    }

    public synchronized void setDefaultId(byte[] id) {
        this.defaultAlias = this.getAlias(id);
    }

    public synchronized void put(String alias, byte[] id) {
        if (alias == null || id == null) {
            return;
        }
        if (this.defaultAlias == null) {
            this.defaultAlias = alias;
        }
        this.idToAlias.put(Bytes.of(id), alias);
        this.aliasToId.put(alias, id);
    }

    public synchronized String removeId(byte[] id) {
        if (id == null) {
            return null;
        }
        String alias = this.idToAlias.remove(Bytes.of(id));
        if (this.defaultAlias == alias) {
            this.defaultAlias = this.aliasToId.isEmpty() ? null : this.aliasToId.keySet().iterator().next();
        }
        this.aliasToId.remove(alias);
        return alias;
    }

    public synchronized byte[] removeAlias(String alias) {
        if (alias == null) {
            return null;
        }
        if (this.defaultAlias == alias) {
            this.defaultAlias = this.aliasToId.isEmpty() ? null : this.aliasToId.keySet().iterator().next();
        }
        byte[] id = this.aliasToId.remove(alias);
        this.idToAlias.remove(Bytes.of(id));
        return id;
    }

    public Set<Map.Entry<String, byte[]>> entrySet() {
        return this.aliasToId.entrySet();
    }

    public Set<String> aliasSet() {
        return this.aliasToId.keySet();
    }

    public Set<Bytes> idSet() {
        return this.idToAlias.keySet();
    }
}

