/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.internal.security;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.security.IdFromCertExtractor;
import pt.unl.fct.di.novasys.babel.internal.security.IdAliasMapper;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;

public class X509BabelKeyManager
extends X509IKeyManager {
    private static final Logger logger = LogManager.getLogger(X509BabelKeyManager.class);
    private final IdAliasMapper idAliasMapper;
    private final List<KeyStore> keyStores;
    private final KeyStore.ProtectionParameter protParam;

    public X509BabelKeyManager(KeyStore.ProtectionParameter protParam, IdFromCertExtractor idExtractor, KeyStore ... keyStores) throws KeyStoreException {
        this(protParam, new IdAliasMapper(), keyStores);
        for (KeyStore store : keyStores) {
            this.idAliasMapper.populateFromPrivateKeyStore(store, protParam, idExtractor);
        }
    }

    public X509BabelKeyManager(KeyStore.ProtectionParameter protParam, IdAliasMapper idAliasMapper, KeyStore ... keyStores) throws KeyStoreException {
        for (KeyStore ks : keyStores) {
            ks.size();
        }
        this.keyStores = List.of(keyStores);
        this.protParam = protParam;
        this.idAliasMapper = idAliasMapper;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        Set<String> aliases = this.idAliasMapper.aliasSet();
        return aliases.toArray(new String[aliases.size()]);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.idAliasMapper.getDefaultAlias();
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.idAliasMapper.getDefaultAlias();
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            Certificate[] chain = this.keyStoreWithAlias(alias).getCertificateChain(alias);
            X509Certificate[] x509Chain = new X509Certificate[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                x509Chain[i] = (X509Certificate)chain[i];
            }
            return x509Chain;
        }
        catch (ClassCastException e) {
            logger.error("getCertificateChain(%s): Couldn't cast Certificate[] to X509Certificate[]", (Object)alias);
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            return ((KeyStore.PrivateKeyEntry)this.keyStoreWithAlias(alias).getEntry(alias, this.protParam)).getPrivateKey();
        }
        catch (ClassCastException e) {
            logger.error("getPrivateKey({}) failed because the alias didn't refer to a private key entry", (Object)alias);
            return null;
        }
        catch (NoSuchAlgorithmException | UnrecoverableEntryException e) {
            logger.error("getPrivateKey({}) failed with exception: {}", (Object)alias, (Object)e);
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (KeyStoreException never) {
            throw new AssertionError((Object)never);
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(byte[] id) {
        return this.getCertificateChain(this.idAliasMapper.getAlias(id));
    }

    @Override
    public PrivateKey getPrivateKey(byte[] id) {
        return this.getPrivateKey(this.idAliasMapper.getAlias(id));
    }

    @Override
    public String getIdAlias(byte[] id) {
        return this.idAliasMapper.getAlias(id);
    }

    @Override
    public byte[] getAliasId(String alias) {
        return this.idAliasMapper.getId(alias);
    }

    private KeyStore keyStoreWithAlias(String alias) {
        try {
            for (KeyStore ks : this.keyStores) {
                if (!ks.containsAlias(alias)) continue;
                return ks;
            }
            return null;
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }
}

