/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.internal.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.security.IdFromCertExtractor;
import pt.unl.fct.di.novasys.babel.internal.security.PeerIdEncoder;
import pt.unl.fct.di.novasys.babel.internal.security.X509CertificateChainPredicate;
import pt.unl.fct.di.novasys.network.data.Bytes;
import pt.unl.fct.di.novasys.network.security.X509ITrustManager;

public class X509BabelTrustManager
extends X509ITrustManager {
    private static final Logger logger = LogManager.getLogger(X509BabelTrustManager.class);
    private TrustPolicy trustPolicy;
    private final Lock policyWriteLock;
    private final Lock policyReadLock;
    private final Collection<KeyStore> trustStores;
    private final KeyStore targetTrustStore;
    private final Set<Bytes> expectedIds;
    private X509CertificateChainPredicate trustConsistentCertificate;
    private X509CertificateChainPredicate trustUnknownPeerCallback;
    private X509CertificateChainPredicate verifyCertificateSignature;
    private final IdFromCertExtractor idExtractor;

    public X509BabelTrustManager(IdFromCertExtractor idExtractor, Collection<KeyStore> trustStores, TrustPolicy trustPolicy, X509CertificateChainPredicate trustUnknownPeerCallback, X509CertificateChainPredicate verifyCertificateSignature, KeyStore targetTrustStore) throws KeyStoreException {
        for (KeyStore store : trustStores) {
            store.size();
        }
        targetTrustStore.size();
        ReentrantReadWriteLock policyLock = new ReentrantReadWriteLock();
        this.policyReadLock = policyLock.readLock();
        this.policyWriteLock = policyLock.writeLock();
        this.trustStores = trustStores;
        this.targetTrustStore = targetTrustStore;
        this.expectedIds = Collections.synchronizedSet(new HashSet());
        this.idExtractor = idExtractor;
        this.trustUnknownPeerCallback = trustUnknownPeerCallback;
        this.verifyCertificateSignature = verifyCertificateSignature;
        this.setTrustPolicy(trustPolicy);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkServerTrusted(chain, null, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, byte[] expectedId, String authType) throws CertificateException {
        this.checkServerTrusted(chain, expectedId, authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkServerTrusted(X509Certificate[] chain, byte[] expectedId, String authType) throws CertificateException {
        block10: {
            if (chain == null || chain.length == 0) {
                throw new CertificateException("No certificate.");
            }
            byte[] idInCert = this.idExtractor.extractIdentity(chain[0]);
            if (expectedId != null && !Arrays.equals(idInCert, expectedId)) {
                throw new CertificateException("Expected id: %s Got: %s".formatted(PeerIdEncoder.encodeToString(expectedId), PeerIdEncoder.encodeToString(idInCert)));
            }
            this.policyReadLock.lock();
            try {
                if (!this.verifyCertificateSignature.test(chain, idInCert)) {
                    throw new CertificateException("Certificate signature verification failed for peer %s".formatted(PeerIdEncoder.encodeToString(idInCert)));
                }
                boolean expected = this.expectedIds.remove(Bytes.of(idInCert));
                if (expected || this.trustConsistentCertificate.test(chain, idInCert)) {
                    try {
                        String alias = PeerIdEncoder.encodeToString(idInCert);
                        if (this.targetTrustStore != null) {
                            this.targetTrustStore.setCertificateEntry(alias, chain[0]);
                            logger.debug("Saved peer certificate to trust store: {}", (Object)alias);
                        }
                        break block10;
                    }
                    catch (KeyStoreException e) {
                        logger.error(e);
                    }
                    break block10;
                }
                String msg = "Didn't trust certificate with identity %s. Trust manager policy was %s.".formatted(new Object[]{PeerIdEncoder.encodeToString(idInCert), this.trustPolicy});
                logger.debug(msg);
                throw new CertificateException(msg);
            }
            finally {
                this.policyReadLock.unlock();
            }
        }
    }

    @Override
    public byte[] extractIdFromCertificate(X509Certificate certificate) throws CertificateException {
        return this.idExtractor.extractIdentity(certificate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Bytes> getTrustedIds() {
        HashSet<Bytes> ids = new HashSet<Bytes>(this.expectedIds);
        for (KeyStore store : this.trustStores) {
            try {
                KeyStore keyStore = store;
                synchronized (keyStore) {
                    Enumeration<String> aliases = store.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        Certificate entry = store.getCertificate(alias);
                        byte[] trustedId = this.idExtractor.extractIdentity(entry);
                        ids.add(Bytes.of(trustedId));
                    }
                }
            }
            catch (KeyStoreException | CertificateException e) {
                logger.warn(e);
            }
        }
        return ids;
    }

    @Override
    public void addTrustedId(byte[] id) {
        this.expectedIds.add(Bytes.of(id));
    }

    @Override
    public void removeTrustedId(byte[] id) {
        this.expectedIds.remove(Bytes.of(id));
        for (KeyStore store : this.trustStores) {
            try {
                String alias = PeerIdEncoder.encodeToString(id);
                Certificate entry = store.getCertificate(alias);
                byte[] trustedId = this.idExtractor.extractIdentity(entry);
                if (!Arrays.equals(trustedId, id)) continue;
                store.deleteEntry(alias);
            }
            catch (KeyStoreException | CertificateException e) {
                logger.warn(e);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public TrustPolicy getTrustPolicy() {
        return this.trustPolicy;
    }

    public void setTrustPolicy(TrustPolicy newPolicy) {
        this.policyWriteLock.lock();
        try {
            this.trustPolicy = newPolicy;
            this.trustConsistentCertificate = switch (this.trustPolicy.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> (chain, id) -> true;
                case 2 -> this::knownCertPolicyTrustConsistentCertificate;
                case 1 -> this::knownIdPolicyTrustConsistentCertificate;
            };
        }
        finally {
            this.policyWriteLock.unlock();
        }
    }

    public void setCertificateSignatureVerifier(X509CertificateChainPredicate verifyCertificateSignature) {
        this.policyWriteLock.lock();
        try {
            this.verifyCertificateSignature = verifyCertificateSignature;
        }
        finally {
            this.policyWriteLock.unlock();
        }
    }

    public void setTrustUnknownPeerCallback(X509CertificateChainPredicate trustUnknownCertCallback) {
        this.policyWriteLock.lock();
        try {
            this.trustUnknownPeerCallback = trustUnknownCertCallback;
        }
        finally {
            this.policyWriteLock.unlock();
        }
    }

    private boolean knownIdPolicyTrustConsistentCertificate(X509Certificate[] certificateChain, byte[] idInRootCert) throws CertificateException {
        if (this.getPeerCertificate(idInRootCert) != null) {
            return true;
        }
        logger.debug("Unknown identity received. Calling \"trust unkown\" callback handler.");
        return this.trustUnknownPeerCallback.test(certificateChain, idInRootCert);
    }

    private boolean knownCertPolicyTrustConsistentCertificate(X509Certificate[] certificateChain, byte[] idInRootCert) throws CertificateException {
        Certificate knownCertificate = this.getPeerCertificate(idInRootCert);
        if (knownCertificate != null && Arrays.equals(knownCertificate.getEncoded(), certificateChain[0].getEncoded())) {
            return true;
        }
        logger.debug("Unknown certificate received. Calling \"trust unkown certificate\" callback handler.");
        return this.trustUnknownPeerCallback.test(certificateChain, idInRootCert);
    }

    private Certificate getPeerCertificate(byte[] peerId) {
        for (KeyStore trustStore : this.trustStores) {
            try {
                Certificate cert = trustStore.getCertificate(PeerIdEncoder.encodeToString(peerId));
                byte[] certIdentity = this.idExtractor.extractIdentity(cert);
                if (!Arrays.equals(peerId, certIdentity)) continue;
                return cert;
            }
            catch (KeyStoreException | CertificateException generalSecurityException) {
            }
        }
        return null;
    }

    public static enum TrustPolicy {
        UNKNOWN,
        KNOWN_ID,
        KNOWN_CERT;

    }
}

