/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.Sample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.LabeledMetricException;

public class Gauge
extends Metric<Gauge> {
    private double value;
    private final Object lock = new Object();

    protected Gauge(Builder builder) {
        super(builder);
        if (this.isUnlabeledMetric()) {
            this.value = 0.0;
        }
    }

    private Gauge(Metric<Gauge> metric) {
        super(metric);
        this.value = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resetThisMetric() {
        Object object = this.lock;
        synchronized (object) {
            this.value = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MetricSample collectMetric() {
        Sample sample;
        Object object = this.lock;
        synchronized (object) {
            sample = new Sample(this.value);
        }
        return this.sampleBuilder().build(sample);
    }

    @Override
    protected Gauge newInstance() {
        return new Gauge(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(double value) {
        if (this.isDisabled()) {
            return;
        }
        if (this.isUnlabeledMetric()) {
            Object object = this.lock;
            synchronized (object) {
                this.value = value;
            }
        } else {
            throw new LabeledMetricException();
        }
    }

    public static class Builder
    extends Metric.MetricBuilder<Builder> {
        public Builder(String name, String unit, String ... labelNames) {
            super(name, unit, Metric.MetricType.GAUGE, labelNames);
        }

        @Override
        public Builder self() {
            return this;
        }

        public Gauge build() {
            return new Gauge(this);
        }
    }
}

