/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.metrics.LabelValues;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.Sample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.IncorrectLabelNumberException;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.UnlabelledMetricException;
import pt.unl.fct.di.novasys.babel.metrics.exporters.CollectOptions;

public abstract class Metric<T extends Metric<T>> {
    private static final Logger logger = LogManager.getLogger(Metric.class);
    private final String name;
    private final String unit;
    private final MetricType type;
    private String description;
    private AtomicBoolean disabled = new AtomicBoolean(false);
    private Map<LabelValues, T> labelValues;
    private final String[] labelNames;
    private final boolean hasLabels;
    private CollectOptions collectOptions = CollectOptions.DEFAULT_COLLECT_OPTIONS;

    protected Metric(String name, String unit, MetricType metricType, String ... labelNames) {
        this.name = name.replace(" ", "_");
        this.unit = unit;
        this.type = metricType;
        this.labelNames = labelNames;
        this.hasLabels = labelNames.length > 0;
        this.description = "";
        if (this.hasLabels) {
            this.labelValues = new ConcurrentHashMap<LabelValues, T>();
        }
    }

    protected Metric(MetricBuilder<?> builder) {
        this(builder.name, builder.unit, builder.type, builder.labelNames);
        if (!builder.description.isEmpty()) {
            this.description = builder.description;
        }
        if (builder.collectOptions != null) {
            this.collectOptions = builder.collectOptions;
        }
    }

    protected Metric(Metric<T> m4) {
        this(m4.getName(), m4.getUnit(), m4.getType(), new String[0]);
        this.description = m4.getDescription();
        this.disabled = m4.getDisabled();
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    protected MetricType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    protected boolean isDisabled() {
        return this.disabled.get();
    }

    protected AtomicBoolean getDisabled() {
        return this.disabled;
    }

    private String[] getLabelNames() {
        return Arrays.copyOf(this.labelNames, this.labelNames.length);
    }

    protected boolean isUnlabeledMetric() {
        return !this.hasLabels;
    }

    private int getNumLabels() {
        return this.labelNames.length;
    }

    protected abstract void resetThisMetric();

    protected abstract MetricSample collectMetric();

    protected abstract T newInstance();

    public final synchronized void reset() {
        if (this.isDisabled()) {
            return;
        }
        if (this.isUnlabeledMetric()) {
            this.resetThisMetric();
        } else {
            for (Metric metric : this.labelValues.values()) {
                metric.reset();
            }
        }
    }

    protected void disable() {
        this.disabled.set(true);
        logger.debug("{} isDisabled() {}", (Object)this.name, (Object)this.disabled.get());
    }

    protected MetricSample collect() {
        return this.collect(this.collectOptions);
    }

    protected MetricSample collect(CollectOptions collectOptions) {
        if (this.isDisabled()) {
            return this.sampleBuilder().build(new Sample(0.0));
        }
        if (this.isUnlabeledMetric()) {
            return this.collectMetric();
        }
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (Map.Entry<LabelValues, T> entry : this.labelValues.entrySet()) {
            String[] labelNames;
            LabelValues sampleLabelValues = entry.getKey();
            MetricSample metricSample = ((Metric)entry.getValue()).collectMetric();
            if (metricSample.hasLabels()) {
                int labelLength = this.getNumLabels() + metricSample.getLabelNames().length;
                labelNames = new String[labelLength];
                System.arraycopy(this.getLabelNames(), 0, labelNames, 0, this.getNumLabels());
                System.arraycopy(metricSample.getLabelNames(), 0, labelNames, this.getNumLabels(), metricSample.getLabelNames().length);
                for (int i = 0; i < metricSample.getNSamples(); ++i) {
                    Sample sample = metricSample.getSamples()[i];
                    String[] labelValues = new String[labelLength];
                    System.arraycopy(sampleLabelValues.getLabelValues(), 0, labelValues, 0, this.getNumLabels());
                    System.arraycopy(sample.getLabelsValues(), 0, labelValues, this.getNumLabels(), metricSample.getLabelNames().length);
                    samples.add(new Sample(sample.getValue(), labelNames, labelValues));
                }
                continue;
            }
            labelNames = this.getLabelNames();
            String[] labelValuesSample = Arrays.copyOf(sampleLabelValues.getLabelValues(), this.getNumLabels());
            samples.add(new Sample(metricSample.getSamples()[0].getValue(), labelNames, labelValuesSample));
        }
        if (collectOptions.getResetOnCollect()) {
            this.reset();
        }
        return this.sampleBuilder().labelNames(this.getLabelNames()).build(samples.toArray(new Sample[0]));
    }

    public MetricSample.Builder sampleBuilder() {
        MetricSample.Builder builder = MetricSample.builder(this.unit, this.name, this.type);
        if (this.description != null) {
            builder = builder.description(this.description);
        }
        return builder;
    }

    public T labelValues(String ... labelValues) {
        if (this.isUnlabeledMetric()) {
            throw new UnlabelledMetricException(this.getType(), this.getName());
        }
        if (this.isDisabled()) {
            return this.newInstance();
        }
        if (labelValues.length != this.getNumLabels()) {
            throw new IncorrectLabelNumberException();
        }
        LabelValues lv = new LabelValues(labelValues);
        if (!this.labelValues.containsKey(lv)) {
            T newMetricInstance = this.newInstance();
            this.labelValues.put(lv, newMetricInstance);
            return newMetricInstance;
        }
        return (T)((Metric)this.labelValues.get(lv));
    }

    public static enum MetricType implements Serializable
    {
        COUNTER("counter"),
        GAUGE("gauge"),
        HISTOGRAM("histogram"),
        RECORD("record");

        private final String type;

        private MetricType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    protected static abstract class MetricBuilder<A extends MetricBuilder<A>> {
        private final String name;
        private final String unit;
        private final MetricType type;
        private final String[] labelNames;
        private String description = "";
        private CollectOptions collectOptions;

        public MetricBuilder(String name, String unit, MetricType metricType, String ... labelNames) {
            this.name = name;
            this.unit = unit;
            this.type = metricType;
            this.labelNames = labelNames;
        }

        public A collectOptions(CollectOptions collectOptions) {
            this.collectOptions = collectOptions;
            return this.self();
        }

        public abstract A self();

        public A description(String description) {
            this.description = description;
            return this.self();
        }

        public abstract Metric<?> build();
    }

    public static class Unit {
        public static final String BYTES = "bytes";
        public static final String KBYTES = "Kbytes";
        public static final String SECONDS = "seconds";
        public static final String PERCENTAGE = "%";
        public static final String NONE = "";
    }
}

