/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.exceptions.ProtocolAlreadyExistsException;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolMetrics;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolSample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.DuplicatedProtocolMetric;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.NoProcfsException;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.NoSuchProtocolRegistry;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.OSMetricsConfigException;
import pt.unl.fct.di.novasys.babel.metrics.exporters.Exporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ExporterCollectOptions;
import pt.unl.fct.di.novasys.babel.metrics.exporters.MonitorExporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.PrometheusHTTPExporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ProtocolCollectOptions;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ProtocolExporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ThreadedExporter;
import pt.unl.fct.di.novasys.babel.metrics.generic.os.OSMetrics;
import pt.unl.fct.di.novasys.babel.metrics.instant.InstantExporter;
import pt.unl.fct.di.novasys.babel.metrics.monitor.Aggregation;
import pt.unl.fct.di.novasys.babel.metrics.monitor.Monitor;
import pt.unl.fct.di.novasys.babel.metrics.monitor.SimpleMonitor;
import pt.unl.fct.di.novasys.babel.metrics.monitor.datalayer.MonitorStorage;
import pt.unl.fct.di.novasys.babel.metrics.monitor.datalayer.Storage;
import pt.unl.fct.di.novasys.babel.metrics.utils.JSONParser;
import pt.unl.fct.di.novasys.network.data.Host;

public class MetricsManager {
    private static final String CURRENT_WORKING_DIR = System.getProperty("user.dir");
    public static final String GLOBAL_HOST_IDENTIFIER = "GLOBAL";
    public static final short OS_METRIC_PROTOCOL_ID = -1;
    public static final String OS_PROTO_NAME = "OS";
    private static final Logger logger = LogManager.getLogger(MetricsManager.class);
    private final ConcurrentHashMap<Short, ProtocolMetrics> protocolMetricsMap = new ConcurrentHashMap();
    OSMetrics osMetrics;
    List<ThreadedExporter> threadedExporters = new ArrayList<ThreadedExporter>();
    List<InstantExporter> instantExporters = new ArrayList<InstantExporter>();
    List<Exporter> exporters = new ArrayList<Exporter>();
    private boolean disabled = false;
    private SimpleMonitor simpleMonitor;
    Map<Short, Exporter> protocolExporters = new HashMap<Short, Exporter>();
    private static MetricsManager system;
    private boolean started = false;

    public static synchronized MetricsManager getInstance() {
        if (system == null) {
            system = new MetricsManager();
        }
        return system;
    }

    private MetricsManager() {
    }

    public void registerExporters(ThreadedExporter ... exporters) {
        if (this.started) {
            throw new IllegalStateException("Can't register threaded exporters after starting the MetricsManager");
        }
        if (exporters.length == 0) {
            throw new IllegalArgumentException("No exporters provided");
        }
        this.threadedExporters.addAll(Arrays.asList(exporters));
        this.exporters.addAll(Arrays.asList(exporters));
    }

    public void registerExporters(InstantExporter exporter) {
        if (this.started) {
            throw new IllegalStateException("Can't register threaded exporters after starting the MetricsManager");
        }
        this.instantExporters.add(exporter);
    }

    public void registerExporters(ProtocolExporter ... exporters) {
        if (exporters.length == 0) {
            throw new IllegalArgumentException("No exporters provided");
        }
        this.exporters.addAll(Arrays.asList(exporters));
    }

    public void registerExporters(String configPath) {
        this.registerExportersUsingConfig(configPath);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void registerExportersUsingConfig(String configPath) {
        parsedJson = (List)JSONParser.parseJsonFile(configPath);
        for (E exporter : parsedJson) {
            exporterClass = (String)((Map)exporter).get("type");
            exporterName = (String)((Map)exporter).get("name");
            exporterConfigPath = (String)((Map)exporter).get("exporterConfigs");
            exporterCollectOptionsPath = (String)((Map)exporter).get("exporterCollectOptions");
            ex /* !! */  = null;
            exporterProtocol = null;
            var11_11 = exporterClass;
            var12_13 = -1;
            switch (var11_11.hashCode()) {
                case 1253869075: {
                    if (!var11_11.equals("PrometheusHTTPExporter")) break;
                    var12_13 = 0;
                }
            }
            switch (var12_13) {
                case 0: {
                    ex /* !! */  = ((PrometheusHTTPExporter.Builder)((PrometheusHTTPExporter.Builder)new PrometheusHTTPExporter.Builder(exporterName).exporterConfigPath(exporterConfigPath)).exporterCollectOptionsPath(exporterCollectOptionsPath)).build();
                    break;
                }
                default: {
                    try {
                        try {
                            exporterClassType = Class.forName(exporterClass);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException("Exporter class not found!! " + String.valueOf(e));
                        }
                        if (ThreadedExporter.class.isAssignableFrom(exporterClassType)) {
                            try {
                                exporterBuilder = Class.forName(exporterClass + "$Builder");
                            }
                            catch (ClassNotFoundException e) {
                                throw new RuntimeException("Exporter class must have a Builder class!!" + String.valueOf(e));
                            }
                            try {
                                builderInstance = exporterBuilder.getDeclaredConstructor(new Class[]{String.class}).newInstance(new Object[]{exporterName});
                                exporterBuilder.getMethod("exporterConfigPath", new Class[]{String.class}).invoke(builderInstance, new Object[]{exporterConfigPath});
                                exporterBuilder.getMethod("exporterCollectOptionsPath", new Class[]{String.class}).invoke(builderInstance, new Object[]{exporterCollectOptionsPath});
                                ex /* !! */  = (ThreadedExporter)exporterBuilder.getMethod("build", new Class[0]).invoke(builderInstance, new Object[0]);
                                ** break;
                            }
                            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                                throw new RuntimeException("Builder method not found, wrong arguments or wrong return type!!" + String.valueOf(e));
                            }
                            catch (InvocationTargetException e) {
                                throw new RuntimeException("Builder threw an exception!! " + e.getTargetException().getMessage());
                            }
                        }
                        if (GenericProtocol.class.isAssignableFrom(exporterClassType)) {
                            protocolExporter = ((ProtocolExporter.Builder)((ProtocolExporter.Builder)new ProtocolExporter.Builder(exporterName).exporterConfigPath(exporterConfigPath)).exporterCollectOptionsPath(exporterCollectOptionsPath)).build();
                            try {
                                protocolInstance = exporterClassType.getDeclaredConstructor(new Class[]{ProtocolExporter.class}).newInstance(new Object[]{protocolExporter});
                                exporterProtocol = (GenericProtocol)protocolInstance;
                                ** break;
                            }
                            catch (NoSuchMethodException e) {
                                throw new RuntimeException("Exporter protocol must have a constructor that receives a ProtocolExporter object!!");
                            }
                        }
                        break;
lbl-1000:
                        // 2 sources

                        {
                            break;
                        }
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (ex /* !! */  != null) {
                this.threadedExporters.add(ex /* !! */ );
                continue;
            }
            if (exporterProtocol == null) continue;
            try {
                Babel.getInstance().registerProtocol(exporterProtocol);
            }
            catch (ProtocolAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
            exporterProperties = new Properties();
            if (exporterConfigPath != null) {
                try {
                    reader = new FileReader(exporterConfigPath);
                    exporterProperties.load(reader);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                exporterProtocol.init(exporterProperties);
            }
            catch (Exception e) {
                throw new RuntimeException("Error initializing protocol " + exporterProtocol.getProtoName() + " " + String.valueOf(e));
            }
        }
    }

    public synchronized void registerOSMetrics(OSMetrics.MetricType ... metricTypes) throws NoProcfsException, OSMetricsConfigException, DuplicatedProtocolMetric {
        if (this.osMetrics == null) {
            this.osMetrics = new OSMetrics();
        }
        for (OSMetrics.MetricType mt : metricTypes) {
            this.registerMetric(this.osMetrics.getOSMetric(mt, this.osMetrics), (short)-1, OS_PROTO_NAME);
        }
    }

    public synchronized void registerOSMetricCategory(OSMetrics.MetricCategory ... metricCategories) throws NoProcfsException, OSMetricsConfigException, DuplicatedProtocolMetric {
        if (this.osMetrics == null) {
            this.osMetrics = new OSMetrics();
        }
        Set<OSMetrics.MetricType> mts = this.osMetrics.getMetricsFromCategories(metricCategories);
        this.registerOSMetrics(mts.toArray(new OSMetrics.MetricType[0]));
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        for (ThreadedExporter threadedExporter : this.threadedExporters) {
            new Thread((Runnable)threadedExporter, threadedExporter.getExporterName()).start();
        }
        for (InstantExporter instantExporter : this.instantExporters) {
            new Thread((Runnable)instantExporter, instantExporter.getExporterName()).start();
        }
        this.started = true;
    }

    public synchronized void disable() {
        this.disabled = true;
        for (Exporter ex : this.exporters) {
            ex.disable();
        }
        for (ProtocolMetrics mr : this.protocolMetricsMap.values()) {
            mr.disable();
        }
    }

    public synchronized void registerMetric(Metric m4, short protocolID, String protoName) throws DuplicatedProtocolMetric {
        if (this.disabled) {
            m4.disable();
            return;
        }
        if (this.protocolMetricsMap.containsKey(protocolID)) {
            this.protocolMetricsMap.get(protocolID).register(m4);
        } else {
            ProtocolMetrics pm = new ProtocolMetrics(protocolID, protoName);
            pm.register(m4);
            this.protocolMetricsMap.put(protocolID, pm);
        }
    }

    public NodeSample collectMetricsAllProtocols(ExporterCollectOptions exporterCollectOptions) {
        NodeSample nodeSample = new NodeSample();
        for (Short protocolId : this.protocolMetricsMap.keySet()) {
            if (protocolId == -1 && !exporterCollectOptions.isCollectOSMetrics()) continue;
            nodeSample.addProtocolSample(protocolId, this.collectMetricForProtocol(protocolId, exporterCollectOptions));
        }
        return nodeSample;
    }

    public NodeSample collectMetricsProtocols(boolean collectOSMetrics, ExporterCollectOptions exporterCollectOptions, short ... protocolIds) throws NoSuchProtocolRegistry {
        NodeSample nodeSample = new NodeSample();
        if (collectOSMetrics && this.osMetrics != null) {
            ProtocolSample osSample = this.collectMetricForProtocol((short)-1, exporterCollectOptions);
            nodeSample.addProtocolSample((short)-1, osSample);
        }
        for (short protoId : protocolIds) {
            ProtocolSample protocolSample = this.collectMetricForProtocol(protoId, exporterCollectOptions);
            nodeSample.addProtocolSample(protoId, protocolSample);
        }
        return nodeSample;
    }

    private ProtocolSample collectMetricForProtocol(short protocolId, ExporterCollectOptions exporterCollectOptions) throws NoSuchProtocolRegistry {
        ProtocolMetrics protocolMetrics;
        ProtocolCollectOptions protocolCollectOptions = exporterCollectOptions.getProtocolCollectOptions(protocolId);
        if (protocolCollectOptions == null) {
            protocolCollectOptions = new ProtocolCollectOptions();
        }
        if ((protocolMetrics = this.protocolMetricsMap.get(protocolId)) == null) {
            throw new NoSuchProtocolRegistry(protocolId);
        }
        return protocolMetrics.collect(protocolCollectOptions);
    }

    public String getProtoNameById(short protocolID) {
        if (protocolID == -1) {
            return OS_PROTO_NAME;
        }
        return Babel.getInstance().getProtoNameById(protocolID);
    }

    public void startMonitorExporter(Host self, Host monitor, long interval, ExporterCollectOptions eco) {
        MonitorExporter exporter = new MonitorExporter(self, monitor, interval, eco);
        try {
            Babel.getInstance().registerProtocol(exporter);
            exporter.init(new Properties());
        }
        catch (IOException | HandlerRegistrationException | ProtocolAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
    }

    public Monitor startMonitor(Host myself, Properties props) {
        MonitorStorage monitorStorage = new MonitorStorage(props);
        return this.startMonitor(myself, monitorStorage);
    }

    public Monitor startMonitor(Host myself, Storage storage) {
        if (this.simpleMonitor != null) {
            throw new IllegalStateException("Monitor already started");
        }
        this.simpleMonitor = new SimpleMonitor(myself, storage);
        try {
            Babel.getInstance().registerProtocol(this.simpleMonitor);
            this.simpleMonitor.init(new Properties());
        }
        catch (IOException | HandlerRegistrationException | ProtocolAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
        return this.simpleMonitor;
    }

    public void addAggregation(Aggregation aggregation) {
        this.simpleMonitor.addAggregation(aggregation);
    }
}

