/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pt.unl.fct.di.novasys.babel.metrics.LabelValues;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.Sample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.IncorrectLabelNumberException;

public class Record
extends Metric<Record> {
    private final boolean timestampParam;
    private final String[] recordParams;
    private final List<LabelValues> records;
    private final int numRecordParams;

    protected Record(Builder builder) {
        super(builder);
        this.timestampParam = builder.timestampParam;
        this.recordParams = builder.recordParams;
        this.numRecordParams = this.timestampParam ? this.recordParams.length - 1 : this.recordParams.length;
        this.records = new ArrayList<LabelValues>();
    }

    private Record(Record r) {
        super(r);
        this.timestampParam = r.timestampParam;
        this.recordParams = r.recordParams;
        this.numRecordParams = this.timestampParam ? this.recordParams.length - 1 : this.recordParams.length;
        this.records = new ArrayList<LabelValues>();
    }

    public void record(String ... parameters) {
        String[] lvalues;
        if (this.isDisabled()) {
            return;
        }
        if (this.numRecordParams != parameters.length) {
            throw new IncorrectLabelNumberException();
        }
        if (this.timestampParam) {
            lvalues = new String[parameters.length + 1];
            System.arraycopy(parameters, 0, lvalues, 0, parameters.length);
            lvalues[parameters.length] = String.valueOf(System.currentTimeMillis());
        } else {
            lvalues = parameters;
        }
        LabelValues lv = new LabelValues(lvalues);
        this.records.add(lv);
    }

    public static Builder builder(String name, String ... recordParams) {
        return new Builder(name, recordParams);
    }

    @Override
    protected void resetThisMetric() {
        this.records.clear();
    }

    @Override
    protected MetricSample collectMetric() {
        Sample[] samples = new Sample[this.records.size()];
        int i = 0;
        for (LabelValues lv : this.records) {
            samples[i] = new Sample(0.0, this.recordParams, Arrays.copyOf(lv.getLabelValues(), this.recordParams.length));
            ++i;
        }
        return this.sampleBuilder().labelNames(Arrays.copyOf(this.recordParams, this.recordParams.length)).build(samples);
    }

    @Override
    protected Record newInstance() {
        return new Record(this);
    }

    public static class Builder
    extends Metric.MetricBuilder<Builder> {
        private String[] recordParams;
        private boolean timestampParam = false;

        public Builder(String name, String ... recordParams) {
            super(name, "", Metric.MetricType.RECORD, new String[0]);
            this.recordParams = recordParams;
        }

        public Builder timestampParam() {
            String[] updatedRecordParams = new String[this.recordParams.length + 1];
            System.arraycopy(this.recordParams, 0, updatedRecordParams, 0, this.recordParams.length);
            updatedRecordParams[this.recordParams.length] = "timestamp";
            this.recordParams = updatedRecordParams;
            this.timestampParam = true;
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }

        public Record build() {
            return new Record(this);
        }
    }
}

