/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Sample
implements Serializable {
    private final Map<String, String> labels;
    private final double value;

    public Sample(double sampledValue, String[] labelNames, String[] labelValues) {
        this.value = sampledValue;
        this.labels = new HashMap<String, String>();
        for (int i = 0; i < labelNames.length; ++i) {
            this.labels.put(labelNames[i], labelValues[i]);
        }
    }

    public Sample(double sampledValue) {
        this.value = sampledValue;
        this.labels = new HashMap<String, String>();
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    @JsonIgnore
    public String[] getLabelsNames() {
        return this.labels.keySet().toArray(new String[0]);
    }

    @JsonIgnore
    public String[] getLabelsValues() {
        return this.labels.values().toArray(new String[0]);
    }

    public double getValue() {
        return this.value;
    }

    public Sample clone() {
        return new Sample(this.value, this.getLabelsNames(), this.getLabelsValues());
    }
}

