/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.exporters;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.metrics.MetricsManager;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.NoSuchProtocolRegistry;
import pt.unl.fct.di.novasys.babel.metrics.exporters.CollectOptions;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ExporterCollectOptions;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ProtocolCollectOptions;
import pt.unl.fct.di.novasys.babel.metrics.formatting.JSONFormatter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.NodeSampleFormatter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.PrometheusFormatter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.SimpleFormatter;
import pt.unl.fct.di.novasys.babel.metrics.utils.JSONParser;

public abstract class Exporter {
    private static final Logger logger = LogManager.getLogger(Exporter.class);
    private static final String CONFIG_DEFAULT_PATH = System.getProperty("user.dir") + "configs/exporters/";
    private static final String CONFIG_FILE_FORMAT = ".conf";
    private final String exporterName;
    private Properties exporterConfigs;
    private String configPath;
    private ExporterCollectOptions exporterCollectOptions;
    private AtomicBoolean disabled = new AtomicBoolean(false);

    public Exporter(ExporterBuilder exporterBuilder) {
        this.exporterName = exporterBuilder.exporterName;
        this.configPath = exporterBuilder.exporterConfigPath.endsWith("/") ? exporterBuilder.exporterConfigPath : exporterBuilder.exporterConfigPath + "/";
        this.exporterConfigs = !exporterBuilder.exporterConfigPath.isEmpty() ? this.loadConfigFromFile(exporterBuilder.exporterConfigPath) : this.loadConfigFromProperties(exporterBuilder.exporterConfigs);
        this.exporterCollectOptions = !exporterBuilder.exporterCollectOptionsPath.isEmpty() ? this.jsonLoadCollectOptions(exporterBuilder.exporterCollectOptionsPath) : exporterBuilder.exporterCollectOptions;
    }

    public String getExporterName() {
        return this.exporterName;
    }

    public void disable() {
        this.disabled.set(true);
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public boolean isEnabled() {
        return !this.disabled.get();
    }

    public Properties loadConfigFromFile(String exporterConfigPath) {
        Properties properties = this.loadDefaults();
        File config_file = new File(exporterConfigPath);
        if (config_file.isFile()) {
            try {
                properties.load(Files.newInputStream(config_file.toPath(), new OpenOption[0]));
            }
            catch (Exception e) {
                logger.error("Error loading exporter config file:{}", (Object)config_file.getAbsolutePath());
            }
        }
        return properties;
    }

    private Properties loadConfigFromProperties(Properties exporterConfigs) {
        Properties properties = this.loadDefaults();
        properties.putAll((Map<?, ?>)exporterConfigs);
        return properties;
    }

    public String getProperty(String key) {
        return this.exporterConfigs.getProperty(key);
    }

    public abstract Properties loadDefaults();

    public ExporterCollectOptions jsonLoadCollectOptions(String path) {
        ExporterCollectOptions.Builder exporterCollectOptionsBuilder;
        block7: {
            ExporterCollectOptions exporterCollectOptions = ExporterCollectOptions.builder().build();
            if (!new File(path).isFile()) {
                return exporterCollectOptions;
            }
            exporterCollectOptionsBuilder = ExporterCollectOptions.builder();
            try {
                Map parsedJson = (Map)JSONParser.parseJsonFile(path);
                Boolean collectOSMetrics = (Boolean)parsedJson.get("collectOSMetrics");
                if (collectOSMetrics == null) break block7;
                exporterCollectOptionsBuilder = exporterCollectOptionsBuilder.collectOSMetrics(collectOSMetrics);
                Boolean collectAllProtocols = (Boolean)parsedJson.get("collectAllProtocols");
                logger.debug("Collect all protocols: {}", (Object)collectAllProtocols);
                if (collectAllProtocols != null && collectAllProtocols.booleanValue()) {
                    exporterCollectOptionsBuilder = exporterCollectOptionsBuilder.collectAllMetrics(true);
                    break block7;
                }
                exporterCollectOptionsBuilder = exporterCollectOptionsBuilder.collectAllMetrics(false);
                List protocolsToCollect = (List)parsedJson.get("protocolsToCollect");
                if (protocolsToCollect != null) {
                    short[] protocolsToCollectArray = new short[protocolsToCollect.size()];
                    for (int i = 0; i < protocolsToCollect.size(); ++i) {
                        protocolsToCollectArray[i] = ((Integer)protocolsToCollect.get(i)).shortValue();
                    }
                    exporterCollectOptionsBuilder = exporterCollectOptionsBuilder.protocolsToCollect(protocolsToCollectArray);
                    List perProtocolCollectOptions = (List)parsedJson.get("exporterCollectOptions");
                    if (perProtocolCollectOptions != null) {
                        Map<Short, ProtocolCollectOptions> protocolCollectOptionsMap = this.parsePerProtocolCollectOptions(perProtocolCollectOptions);
                        exporterCollectOptionsBuilder = exporterCollectOptionsBuilder.perProtocolCollectOptions(protocolCollectOptionsMap);
                    }
                    break block7;
                }
                throw new RuntimeException("Error parsing JSON file - protocolsToCollect not found");
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Error parsing JSON file: " + e.getMessage());
            }
        }
        return exporterCollectOptionsBuilder.build();
    }

    private Map<Short, ProtocolCollectOptions> parsePerProtocolCollectOptions(List<Object> perProtocolCollectOptions) {
        HashMap<Short, ProtocolCollectOptions> allProtocolCollectOptionsMap = new HashMap<Short, ProtocolCollectOptions>();
        for (Object proto : perProtocolCollectOptions) {
            Map protocol = (Map)proto;
            short protocolId = (short)((Integer)protocol.get("protocolId")).intValue();
            ProtocolCollectOptions protocolCollectOptions = new ProtocolCollectOptions();
            List metrics = (List)protocol.get("protocolCollectOptions");
            for (Object metric : metrics) {
                CollectOptions collectOptions = new CollectOptions();
                Map metricMap = (Map)metric;
                String metricName = (String)metricMap.get("name");
                Map options = (Map)metricMap.get("collectOptions");
                Boolean resetOnCollect = (Boolean)options.get("resetOnCollect");
                if (resetOnCollect != null) {
                    collectOptions = new CollectOptions(resetOnCollect);
                }
                protocolCollectOptions.addCollectOptions(metricName, collectOptions);
            }
            logger.debug(protocolCollectOptions);
            allProtocolCollectOptionsMap.put(protocolId, protocolCollectOptions);
        }
        return allProtocolCollectOptionsMap;
    }

    public ExporterCollectOptions getExporterCollectOptions() {
        return this.exporterCollectOptions;
    }

    public NodeSample collectAllMetrics() {
        return MetricsManager.getInstance().collectMetricsAllProtocols(this.exporterCollectOptions);
    }

    public NodeSample collectMetrics(boolean collectOsMetrics, short ... protocolIds) throws NoSuchProtocolRegistry {
        return MetricsManager.getInstance().collectMetricsProtocols(collectOsMetrics, this.exporterCollectOptions, protocolIds);
    }

    public NodeSample collectMetrics() throws NoSuchProtocolRegistry {
        if (this.exporterCollectOptions.collectMetricsAllProtocols) {
            return this.collectAllMetrics();
        }
        return this.collectMetrics(this.exporterCollectOptions.isCollectOSMetrics(), this.exporterCollectOptions.getProtocolsToCollect());
    }

    public static NodeSampleFormatter getFormatterOrDefault(String formatterNameOrClass, NodeSampleFormatter defaultFormatter) {
        try {
            switch (formatterNameOrClass) {
                case "SimpleFormatter": {
                    return new SimpleFormatter();
                }
                case "PrometheusFormatter": {
                    return new PrometheusFormatter();
                }
                case "JSONFormatter": {
                    return new JSONFormatter();
                }
            }
            return Class.forName(formatterNameOrClass).asSubclass(NodeSampleFormatter.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return defaultFormatter;
        }
    }

    public static abstract class ExporterBuilder<T extends ExporterBuilder<T>> {
        private final String exporterName;
        private String exporterConfigPath = "";
        private Properties exporterConfigs = new Properties();
        private ExporterCollectOptions exporterCollectOptions = ExporterCollectOptions.builder().build();
        private String exporterCollectOptionsPath = "";

        public ExporterBuilder(String exporterName) {
            this.exporterName = exporterName;
        }

        public abstract T self();

        public T exporterConfigs(Properties exporterConfigs) {
            this.exporterConfigs = exporterConfigs;
            return this.self();
        }

        public T exporterConfigPath(String configPath) {
            this.exporterConfigPath = configPath;
            return this.self();
        }

        public T exporterCollectOptions(ExporterCollectOptions exporterCollectOptions) {
            this.exporterCollectOptions = exporterCollectOptions;
            return this.self();
        }

        public T exporterCollectOptionsPath(String exporterCollectOptionsPath) {
            this.exporterCollectOptionsPath = exporterCollectOptionsPath;
            return this.self();
        }

        public abstract Exporter build();
    }
}

