/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.exporters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ProtocolCollectOptions;

public class ExporterCollectOptions {
    private final Map<Short, ProtocolCollectOptions> perProtocolCollectOptions;
    boolean collectMetricsAllProtocols;
    short[] protocolsToCollect;
    boolean collectOSMetrics;

    public static Builder builder() {
        return new Builder();
    }

    private ExporterCollectOptions(Builder builder) {
        this.perProtocolCollectOptions = builder.perProtocolCollectOptions;
        this.collectMetricsAllProtocols = builder.collectAllMetrics;
        this.protocolsToCollect = builder.protocolsToCollect;
        this.collectOSMetrics = builder.collectOSMetrics;
    }

    public void addRegistryCollectOptions(short protocolId, ProtocolCollectOptions protocolCollectOptions) {
        this.perProtocolCollectOptions.put(protocolId, protocolCollectOptions);
    }

    public ProtocolCollectOptions getProtocolCollectOptions(Short protocolId) {
        return this.perProtocolCollectOptions.get(protocolId);
    }

    public boolean isCollectMetricsAllProtocols() {
        return this.collectMetricsAllProtocols;
    }

    public short[] getProtocolsToCollect() {
        return Arrays.copyOf(this.protocolsToCollect, this.protocolsToCollect.length);
    }

    public boolean isCollectOSMetrics() {
        return this.collectOSMetrics;
    }

    public String toString() {
        return "ExporterCollectOptions{perRegistryCollectOptions=" + String.valueOf(this.perProtocolCollectOptions) + ", collectMetricsAllProtocols=" + this.collectMetricsAllProtocols + ", protocolsToCollect=" + Arrays.toString(this.protocolsToCollect) + ", collectOSMetrics=" + this.collectOSMetrics + "}";
    }

    public static class Builder {
        private Map<Short, ProtocolCollectOptions> perProtocolCollectOptions = new HashMap<Short, ProtocolCollectOptions>();
        private boolean collectAllMetrics = true;
        private short[] protocolsToCollect = new short[0];
        private boolean collectOSMetrics = true;

        public Builder collectAllMetrics(boolean collectAllMetrics) {
            this.collectAllMetrics = collectAllMetrics;
            return this;
        }

        public Builder collectOSMetrics(boolean collectOSMetrics) {
            this.collectOSMetrics = collectOSMetrics;
            return this;
        }

        public Builder protocolsToCollect(short ... protocolsToCollect) {
            if (protocolsToCollect == null) {
                return this;
            }
            this.collectAllMetrics = false;
            this.protocolsToCollect = protocolsToCollect;
            return this;
        }

        public Builder perProtocolCollectOptions(Map<Short, ProtocolCollectOptions> perProtocolCollectOptions) {
            this.perProtocolCollectOptions = perProtocolCollectOptions;
            return this;
        }

        public ExporterCollectOptions build() {
            return new ExporterCollectOptions(this);
        }
    }
}

