/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.exporters;

import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ExporterCollectOptions;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ExporterProtocol;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ProtocolExporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.timers.ExportMetricsTimer;
import pt.unl.fct.di.novasys.babel.metrics.messages.SendMetricsMessage;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.data.Host;

public class MonitorExporter
extends GenericProtocol
implements ExporterProtocol {
    public static final short PROTO_ID = 406;
    public static final String PROTO_NAME = "MonitorExporter";
    private Logger logger = LogManager.getLogger(MonitorExporter.class);
    private long exportPeriod;
    private ProtocolExporter pe;
    private long exportMetricsTimerID;
    private Host myself;
    private Host monitor;

    public MonitorExporter(Host myself, Host monitor, long exportPeriod, ExporterCollectOptions eco) {
        super(PROTO_NAME, (short)406);
        this.myself = myself;
        this.monitor = monitor;
        this.exportPeriod = exportPeriod;
        this.pe = ((ProtocolExporter.Builder)new ProtocolExporter.Builder(PROTO_NAME).exporterCollectOptions(eco)).build();
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        Properties channelProperties = new Properties();
        channelProperties.setProperty("address", this.myself.getAddress().getHostAddress());
        channelProperties.setProperty("port", "" + this.myself.getPort());
        int channelId = this.createChannel("TCPChannel", channelProperties);
        this.registerMessageSerializer(channelId, (short)2929, SendMetricsMessage.serializer);
        this.registerTimerHandler((short)11110, this::uponExportMetricsTimer);
        this.registerChannelEventHandler(channelId, (short)3, this::uponOutConnectionDown);
        this.registerChannelEventHandler(channelId, (short)4, this::uponOutConnectionFailed);
        this.registerChannelEventHandler(channelId, (short)5, this::uponOutConnectionUp);
        this.registerChannelEventHandler(channelId, (short)2, this::uponInConnectionUp);
        this.registerChannelEventHandler(channelId, (short)1, this::uponInConnectionDown);
        this.exportMetricsTimerID = this.setupPeriodicTimer(new ExportMetricsTimer(), this.exportPeriod, this.exportPeriod);
    }

    public void uponExportMetricsTimer(ExportMetricsTimer t2, long time) {
        if (this.pe.isDisabled()) {
            this.logger.debug("Exporter is disabled, not exporting metrics");
            this.cancelTimer(this.exportMetricsTimerID);
            return;
        }
        NodeSample sample = this.pe.collectAllMetrics();
        SendMetricsMessage msg = new SendMetricsMessage(sample);
        this.openConnection(this.monitor);
        this.logger.debug("Sending metrics to {}", (Object)this.monitor);
        this.sendMessage((ProtoMessage)msg, (short)6666, this.monitor);
        this.logger.debug("Sent metrics sucessfully");
    }

    private void uponOutConnectionDown(OutConnectionDown event, int channelId) {
        this.logger.trace("Host {} is down, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }

    private void uponOutConnectionFailed(OutConnectionFailed<?> event, int channelId) {
        this.logger.trace("Connection to host {} failed, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }

    private void uponOutConnectionUp(OutConnectionUp event, int channelId) {
        this.logger.trace("Host (out) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionUp(InConnectionUp event, int channelId) {
        this.logger.trace("Host (in) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionDown(InConnectionDown event, int channelId) {
        this.logger.trace("Connection from host {} is down, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }

    @Override
    public ProtocolExporter getExporter() {
        return this.pe;
    }
}

