/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.exporters;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.NoSuchProtocolRegistry;
import pt.unl.fct.di.novasys.babel.metrics.exporters.Exporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ThreadedExporter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.PrometheusFormatter;

public class PrometheusHTTPExporter
extends ThreadedExporter {
    private static final Logger logger = LogManager.getLogger(PrometheusHTTPExporter.class);
    public static final String CONTENT_TYPE_004 = "text/plain; version=0.0.4; charset=utf-8";
    public static final String PORT = "PORT";

    private PrometheusHTTPExporter(Builder builder) {
        super(builder);
    }

    @Override
    public Properties loadDefaults() {
        Properties defaultProperties = new Properties();
        defaultProperties.setProperty(PORT, "9101");
        return defaultProperties;
    }

    @Override
    public void run() {
        try {
            int port = Integer.parseInt(this.getProperty(PORT));
            HttpServer server = HttpServer.create(new InetSocketAddress(port), 0);
            server.createContext("/metrics", new PrometheusMetricsHandler());
            server.setExecutor(null);
            server.start();
            logger.debug("Prometheus HTTP Exporter started on port {}", (Object)port);
            while (this.isEnabled()) {
                Thread.sleep(1000L);
            }
            server.stop(0);
        }
        catch (IOException e) {
            logger.error("Error starting Prometheus HTTP Exporter", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    class PrometheusMetricsHandler
    implements HttpHandler {
        PrometheusMetricsHandler() {
        }

        @Override
        public void handle(HttpExchange t2) throws IOException {
            try {
                NodeSample mres = PrometheusHTTPExporter.this.collectMetrics();
                PrometheusFormatter formatter = new PrometheusFormatter();
                String collect = formatter.format(mres);
                t2.getResponseHeaders().set("Content-Type", PrometheusHTTPExporter.CONTENT_TYPE_004);
                t2.sendResponseHeaders(200, collect.length());
                OutputStream os = t2.getResponseBody();
                os.write(collect.getBytes());
                os.close();
            }
            catch (NoSuchProtocolRegistry e) {
                t2.sendResponseHeaders(500, 0L);
            }
            t2.close();
        }
    }

    public static class Builder
    extends Exporter.ExporterBuilder<Builder> {
        Properties properties = new Properties();

        public Builder(String exporterName) {
            super(exporterName);
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder setPort(int port) {
            this.properties.setProperty(PrometheusHTTPExporter.PORT, Integer.toString(port));
            return this;
        }

        @Override
        public PrometheusHTTPExporter build() {
            this.exporterConfigs(this.properties);
            return new PrometheusHTTPExporter(this);
        }
    }
}

