/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics.exporters;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.NoSuchProtocolRegistry;
import pt.unl.fct.di.novasys.babel.metrics.exporters.Exporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ThreadedExporter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.NodeSampleFormatter;
import pt.unl.fct.di.novasys.babel.metrics.formatting.SimpleFormatter;

public class TimedLogExporter
extends ThreadedExporter {
    public static final String FORMATTER = "FORMATTER";
    public static final String INTERVAL = "INTERVAL";
    public static final String LOG_PATH = "LOG_PATH";
    private static final long S_TO_MS = 1000L;
    private final NodeSampleFormatter formatter = TimedLogExporter.getFormatterOrDefault(this.getProperty("FORMATTER"), new SimpleFormatter());

    public TimedLogExporter(Builder builder) {
        super(builder);
    }

    @Override
    public Properties loadDefaults() {
        Properties defaultProperties = new Properties();
        defaultProperties.setProperty(INTERVAL, "10");
        defaultProperties.setProperty(LOG_PATH, "./");
        return defaultProperties;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        FileWriter writer;
        long sleep_ms = Long.parseLong(this.getProperty(INTERVAL)) * 1000L;
        try {
            writer = new FileWriter(this.getProperty(LOG_PATH) + this.getExporterName() + ".log", true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (true) {
            try {
                Thread.sleep(sleep_ms);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.isDisabled()) {
                return;
            }
            try {
                NodeSample sample = this.collectAllMetrics();
                String formattedSample = this.formatter.format(sample);
                writer.write(formattedSample);
                writer.write("\n");
                writer.flush();
                continue;
            }
            catch (NoSuchProtocolRegistry noSuchProtocolRegistry) {
                noSuchProtocolRegistry.printStackTrace();
                continue;
            }
            break;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder
    extends Exporter.ExporterBuilder<Builder> {
        private NodeSampleFormatter formatter;
        Properties properties = new Properties();

        public Builder(String exporterName) {
            super(exporterName);
        }

        public Builder setFormatter(NodeSampleFormatter formatter) {
            this.properties.setProperty(TimedLogExporter.FORMATTER, formatter.getFormatterName());
            return this;
        }

        public Builder setLogPath(String path) {
            this.properties.setProperty(TimedLogExporter.LOG_PATH, path);
            return this;
        }

        public Builder setInterval(long interval) {
            this.properties.setProperty(TimedLogExporter.INTERVAL, Long.toString(interval));
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public TimedLogExporter build() {
            this.exporterConfigs(this.properties);
            return new TimedLogExporter(this);
        }
    }
}

